/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectChooserAccessory;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class OpenProject
extends BasicAction {
    private static final String NAME = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Tooltip");

    public OpenProject() {
        super(NAME, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/openProject.png")));
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/openProject.png");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
    }

    public void actionPerformed(ActionEvent evt) {
        File[] projectDirs;
        OpenProjectListSettings opls;
        JFileChooser chooser;
        block5: {
            int option;
            chooser = ProjectChooserAccessory.createProjectChooser(true);
            chooser.setMultiSelectionEnabled(true);
            for (DataObject d : Utilities.actionsGlobalContext().lookupAll(DataObject.class)) {
                File dir;
                Project selected = FileOwnerQuery.getOwner((FileObject)d.getPrimaryFile());
                if (selected == null || OpenProjectList.getDefault().isOpen(selected) || (dir = FileUtil.toFile((FileObject)selected.getProjectDirectory())) == null) continue;
                chooser.setCurrentDirectory(dir.getParentFile());
                chooser.setSelectedFiles(new File[]{dir});
                break;
            }
            opls = OpenProjectListSettings.getInstance();
            while ((option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                projectDirs = chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
                ArrayList<Project> projects = new ArrayList<Project>(projectDirs.length);
                for (int i = 0; i < projectDirs.length; ++i) {
                    Project p = OpenProjectList.fileToProject(FileUtil.normalizeFile((File)projectDirs[i]));
                    if (p == null) continue;
                    projects.add(p);
                }
                if (projects.isEmpty()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenProject.class, (String)"MSG_notProjectDir"), 2));
                    continue;
                }
                Project[] projectsArray = new Project[projects.size()];
                projects.toArray(projectsArray);
                OpenProjectList.getDefault().open(projectsArray, opls.isOpenSubprojects(), true);
                if (opls.isOpenAsMain() && projectsArray.length == 1) {
                    OpenProjectList.getDefault().setMainProject(projectsArray[0]);
                }
                break block5;
            }
            return;
        }
        final ProjectTab ptLogial = ProjectTab.findDefault("projectTabLogical_tc");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Node root = ptLogial.getExplorerManager().getRootContext();
                ArrayList<Node> nodes = new ArrayList<Node>(projectDirs.length);
                for (int i = 0; i < projectDirs.length; ++i) {
                    Node projNode = root.getChildren().findChild(projectDirs[i].getName());
                    if (projNode == null) continue;
                    nodes.add(projNode);
                }
                try {
                    Node[] nodesArray = new Node[nodes.size()];
                    nodes.toArray(nodesArray);
                    ptLogial.getExplorerManager().setSelectedNodes(nodesArray);
                    if (!Boolean.getBoolean("project.tab.no.selection")) {
                        ptLogial.open();
                        ptLogial.requestActive();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        opls.setLastOpenProjectDir(chooser.getCurrentDirectory().getPath());
    }
}

