/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.ErrorManager;
import org.openide.awt.DynamicMenuContent;
import org.openide.loaders.DataFolder;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public final class OpenProjectFolderAction
extends AbstractAction
implements ContextAwareAction {
    public OpenProjectFolderAction() {
        super(NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_action"));
    }

    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new ContextAction(context);
    }

    private final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final Set<Project> projects = new HashSet<Project>();

        public ContextAction(Lookup context) {
            for (DataFolder d : context.lookupAll(DataFolder.class)) {
                Project p = null;
                try {
                    p = ProjectManager.getDefault().findProject(d.getPrimaryFile());
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                if (p == null) continue;
                this.projects.add(p);
            }
            this.projects.removeAll(Arrays.asList(OpenProjectList.getDefault().getOpenProjects()));
            int size = this.projects.size();
            if (size == 1) {
                String name = ProjectUtils.getInformation((Project)this.projects.iterator().next()).getDisplayName();
                this.putValue("Name", NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_menu_one", (Object)name));
            } else if (size > 1) {
                this.putValue("Name", NbBundle.getMessage(OpenProjectFolderAction.class, (String)"OpenProjectFolderAction.LBL_menu_multiple", (Object)new Integer(size)));
            }
        }

        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    OpenProjectList.getDefault().open(ContextAction.this.projects.toArray(new Project[ContextAction.this.projects.size()]), false, true);
                }
            });
        }

        public JMenuItem getPopupPresenter() {
            class Presenter
            extends JMenuItem
            implements DynamicMenuContent {
                public Presenter() {
                    super(ContextAction.this);
                }

                public JComponent[] getMenuPresenters() {
                    if (!ContextAction.this.projects.isEmpty()) {
                        return new JComponent[]{this, null};
                    }
                    return new JComponent[0];
                }

                public JComponent[] synchMenuPresenters(JComponent[] items) {
                    return this.getMenuPresenters();
                }
            }
            return new Presenter();
        }
    }
}

