/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectTab;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class RecentProjects
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup,
PropertyChangeListener {
    private static final String PROJECT_URL_KEY = "org.netbeans.modules.project.ui.RecentProjectItem.Project_URL";
    private final ProjectDirListener prjDirListener = new ProjectDirListener();
    private UpdatingMenu subMenu;
    private boolean recreate;

    public RecentProjects() {
        super(NbBundle.getMessage(RecentProjects.class, (String)"LBL_RecentProjectsAction_Name"));
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.recreate = true;
    }

    public boolean isEnabled() {
        return !OpenProjectList.getDefault().isRecentProjectsEmpty();
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public JMenuItem getMenuPresenter() {
        this.createMainSubMenu();
        return this.subMenu;
    }

    public JMenuItem getPopupPresenter() {
        UpdatingMenu menu = this.createSubMenu();
        this.fillSubMenu(menu);
        return menu;
    }

    private UpdatingMenu createSubMenu() {
        UpdatingMenu menu = new UpdatingMenu(this);
        menu.setMnemonic(NbBundle.getMessage(RecentProjects.class, (String)"MNE_RecentProjectsAction_Name").charAt(0));
        return menu;
    }

    private void createMainSubMenu() {
        if (this.subMenu == null) {
            this.subMenu = this.createSubMenu();
            this.subMenu.getModel().addChangeListener(this.subMenu);
        }
    }

    private void fillSubMenu(JMenu menu) {
        menu.removeAll();
        List<Project> projects = OpenProjectList.getDefault().getRecentProjects();
        if (projects.isEmpty()) {
            menu.setEnabled(false);
            return;
        }
        menu.setEnabled(true);
        MenuItemActionListener jmiActionListener = new MenuItemActionListener();
        for (Project p : projects) {
            FileObject prjDir = p.getProjectDirectory();
            try {
                URL prjDirURL = prjDir.getURL();
                if (prjDirURL == null || prjDir == null || !prjDir.isValid()) continue;
                prjDir.removeFileChangeListener((FileChangeListener)this.prjDirListener);
                prjDir.addFileChangeListener((FileChangeListener)this.prjDirListener);
                ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                JMenuItem jmi = new JMenuItem(pi.getDisplayName(), pi.getIcon());
                menu.add(jmi);
                jmi.putClientProperty(PROJECT_URL_KEY, prjDirURL);
                jmi.addActionListener(jmiActionListener);
            }
            catch (FileStateInvalidException ex) {}
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("RecentProjects".equals(e.getPropertyName())) {
            this.createMainSubMenu();
            this.subMenu.setEnabled(!OpenProjectList.getDefault().isRecentProjectsEmpty());
            this.recreate = true;
        }
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)e.getSource();
                URL url = (URL)jmi.getClientProperty(RecentProjects.PROJECT_URL_KEY);
                Project project = null;
                FileObject dir = URLMapper.findFileObject((URL)url);
                if (dir != null && dir.isFolder()) {
                    try {
                        project = ProjectManager.getDefault().findProject(dir);
                    }
                    catch (IOException ioEx) {
                        // empty catch block
                    }
                }
                if (project != null) {
                    OpenProjectList.getDefault().open(new Project[]{project}, false, true);
                    ProjectTab ptLogial = ProjectTab.findDefault("projectTabLogical_tc");
                    Node root = ptLogial.getExplorerManager().getRootContext();
                    Node projNode = root.getChildren().findChild(project.getProjectDirectory().getName());
                    try {
                        ptLogial.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                        ptLogial.open();
                        ptLogial.requestActive();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class ProjectDirListener
    extends FileChangeAdapter {
        private ProjectDirListener() {
        }

        public void fileDeleted(FileEvent fe) {
            RecentProjects.this.recreate = true;
        }
    }

    private class UpdatingMenu
    extends JMenu
    implements ChangeListener {
        public UpdatingMenu(Action action) {
            super(action);
        }

        public void stateChanged(ChangeEvent e) {
            if (RecentProjects.this.recreate && this.getModel().isSelected()) {
                RecentProjects.this.fillSubMenu(this);
                RecentProjects.this.recreate = false;
            }
        }
    }
}

