/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.actions.CloseProject;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class SelectNodeAction
extends LookupSensitiveAction
implements Presenter.Menu,
Presenter.Popup {
    private static final Icon SELECT_IN_PROJECTS_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectTab.png"));
    private static final Icon SELECT_IN_FILES_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/project/ui/resources/filesTab.png"));
    private static final String SELECT_IN_PROJECTS_NAME = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInProjectsAction_Name");
    private static final String SELECT_IN_FILES_NAME = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInFilesAction_Name");
    private static final String SELECT_IN_PROJECTS_NAME_MENU = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInProjectsAction_MenuName");
    private static final String SELECT_IN_FILES_NAME_MENU = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInFilesAction_MenuName");
    private static final String SELECT_IN_PROJECTS_NAME_MAIN_MENU = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInProjectsAction_MainMenuName");
    private static final String SELECT_IN_FILES_NAME_MAIN_MENU = NbBundle.getMessage(CloseProject.class, (String)"LBL_SelectInFilesAction_MainMenuName");
    private String command;
    private ProjectActionPerformer performer;
    private String namePattern;
    private String findIn;

    public static Action inProjects() {
        SelectNodeAction a = new SelectNodeAction(SELECT_IN_PROJECTS_ICON, SELECT_IN_PROJECTS_NAME);
        a.findIn = "projectTabLogical_tc";
        return a;
    }

    public static Action inFiles() {
        SelectNodeAction a = new SelectNodeAction(SELECT_IN_FILES_ICON, SELECT_IN_FILES_NAME);
        a.findIn = "projectTab_tc";
        return a;
    }

    public SelectNodeAction(Icon icon, String name) {
        super(icon, null, new Class[]{DataObject.class, FileObject.class});
        this.setDisplayName(name);
    }

    private SelectNodeAction(String command, ProjectActionPerformer performer, String namePattern, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class, FileObject.class});
        this.command = command;
        this.performer = performer;
        this.namePattern = namePattern;
        this.refresh(this.getLookup());
    }

    protected void actionPerformed(Lookup context) {
        FileObject fo = this.getFileFromLookup(context);
        if (fo != null) {
            ProjectTab pt = ProjectTab.findDefault(this.findIn);
            pt.selectNodeAsync(fo);
        }
    }

    protected void refresh(Lookup context) {
        FileObject fo = this.getFileFromLookup(context);
        this.setEnabled(fo != null);
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    public JMenuItem getMenuPresenter() {
        if ("projectTabLogical_tc".equals(this.findIn)) {
            return this.buildPresenter(SELECT_IN_PROJECTS_NAME_MAIN_MENU);
        }
        return this.buildPresenter(SELECT_IN_FILES_NAME_MAIN_MENU);
    }

    public JMenuItem getPopupPresenter() {
        if ("projectTabLogical_tc".equals(this.findIn)) {
            return this.buildPresenter(SELECT_IN_PROJECTS_NAME_MENU);
        }
        return this.buildPresenter(SELECT_IN_FILES_NAME_MENU);
    }

    private FileObject getFileFromLookup(Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo != null) {
            return fo;
        }
        DataObject dobj = (DataObject)context.lookup(DataObject.class);
        return dobj == null ? null : dobj.getPrimaryFile();
    }

    private JMenuItem buildPresenter(String title) {
        JMenuItem menuPresenter = new JMenuItem(this);
        menuPresenter.setText(title);
        menuPresenter.setIcon(null);
        return menuPresenter;
    }
}

