/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.groups.DirectoryGroupEditPanel;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryGroup
extends Group {
    private static final Logger LOG = Logger.getLogger(DirectoryGroup.class.getName());
    static final String KIND = "directory";

    public static DirectoryGroup create(String name, FileObject dir) throws FileStateInvalidException {
        String path = dir.getURL().toExternalForm();
        String id = DirectoryGroup.sanitizeNameAndUniquifyForId(name);
        LOG.log(Level.FINE, "Creating: {0}", id);
        Preferences p = NODE.node(id);
        p.put("name", name);
        p.put("kind", KIND);
        p.put("path", path);
        return new DirectoryGroup(id);
    }

    DirectoryGroup(String id) {
        super(id);
    }

    @Override
    protected void findProjects(Set<Project> projects, ProgressHandle h, int start, int end) {
        String dir = this.prefs().get("path", null);
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)new URL(dir));
        }
        catch (MalformedURLException x) {
            LOG.log(Level.WARNING, null, x);
        }
        if (fo != null && fo.isFolder()) {
            try {
                Project p = ProjectManager.getDefault().findProject(fo);
                if (p != null) {
                    projects.add(p);
                    if (h != null) {
                        h.progress(DirectoryGroup.progressMessage(p), Math.min(++start, end));
                    }
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
            Enumeration e = fo.getFolders(true);
            while (e.hasMoreElements()) {
                try {
                    Project p = ProjectManager.getDefault().findProject((FileObject)e.nextElement());
                    if (p == null) continue;
                    projects.add(p);
                    if (h == null) continue;
                    h.progress(DirectoryGroup.progressMessage(p), Math.min(++start, end));
                }
                catch (IOException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
        }
    }

    public FileObject getDirectory() {
        String p = this.prefs().get("path", null);
        if (p != null && p.length() > 0) {
            try {
                return URLMapper.findFileObject((URL)new URL(p));
            }
            catch (MalformedURLException x) {
                LOG.log(Level.WARNING, null, x);
            }
        }
        return null;
    }

    @Override
    public GroupEditPanel createPropertiesPanel() {
        return new DirectoryGroupEditPanel(this);
    }
}

