/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.groups.AbstractNewGroupPanel;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.NewGroupPanel;
import org.netbeans.modules.project.ui.groups.NewGroupPanelBasic;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class GroupsMenu
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static final RequestProcessor RP = new RequestProcessor(GroupsMenu.class.getName());

    public GroupsMenu() {
        super(NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.label"));
    }

    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public JMenuItem getMenuPresenter() {
        return new Menu();
    }

    public JMenuItem getPopupPresenter() {
        return new Menu();
    }

    private static void newGroup() {
        final AbstractNewGroupPanel panel = Group.isAdvancedMode() ? new NewGroupPanel() : new NewGroupPanelBasic();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.new_title"));
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(GroupsMenu.class));
        final JButton create = new JButton(NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.new_create"));
        create.setDefaultCapable(true);
        create.setEnabled(panel.isReady());
        panel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("ready".equals(evt.getPropertyName())) {
                    create.setEnabled(panel.isReady());
                }
            }
        });
        JButton cancel = new JButton(NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.new_cancel"));
        dd.setOptions(new Object[]{create, cancel});
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(create)) {
            final Group g = panel.create();
            RP.post(new Runnable(){

                public void run() {
                    Group.setActiveGroup(g);
                }
            });
        }
    }

    private static void openProperties(Group g) {
        GroupEditPanel panel = g.createPropertiesPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.properties_title"));
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(GroupsMenu.class));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(NotifyDescriptor.OK_OPTION)) {
            panel.applyChanges();
        }
    }

    private static class Menu
    extends JMenu
    implements DynamicMenuContent {
        Menu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.label"));
        }

        public JComponent[] getMenuPresenters() {
            this.removeAll();
            final Group active = Group.getActiveGroup();
            for (final Group g : Group.allGroups()) {
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(g.getName());
                if (g.equals(active)) {
                    mi.setSelected(true);
                    if (g.isPristine() && Group.isAdvancedMode()) {
                        mi.setEnabled(false);
                    }
                }
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        RP.post(new Runnable(){

                            public void run() {
                                Group.setActiveGroup(g);
                            }
                        });
                    }
                });
                this.add(mi);
            }
            JMenuItem mi = new JRadioButtonMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)mi, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.no_group"));
            if (active == null) {
                mi.setSelected(true);
                if (OpenProjects.getDefault().getOpenProjects().length == 0 && Group.isAdvancedMode()) {
                    mi.setEnabled(false);
                }
            }
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RP.post(new Runnable(){

                        public void run() {
                            Group.setActiveGroup(null);
                        }
                    });
                }
            });
            this.add(mi);
            this.addSeparator();
            mi = new JMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)mi, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.new_group"));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GroupsMenu.newGroup();
                }
            });
            this.add(mi);
            if (active != null) {
                mi = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)mi, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.properties", (Object)active.getName()));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        GroupsMenu.openProperties(active);
                    }
                });
                this.add(mi);
                mi = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)mi, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.remove", (Object)active.getName()));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        active.destroy();
                    }
                });
                this.add(mi);
            }
            mi = new JCheckBoxMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)mi, (String)NbBundle.getMessage(GroupsMenu.class, (String)"GroupsMenu.advanced"));
            mi.setSelected(Group.isAdvancedMode());
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Group.setAdvancedMode(!Group.isAdvancedMode());
                }
            });
            this.add(mi);
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }
}

