/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.groups.AbstractNewGroupPanel;
import org.netbeans.modules.project.ui.groups.AdHocGroup;
import org.netbeans.modules.project.ui.groups.DirectoryGroup;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.SubprojectsGroup;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewGroupPanel
extends AbstractNewGroupPanel {
    private JLabel adHocKindLabel;
    private JRadioButton adHocKindRadio;
    private JCheckBox autoSynchCheckbox;
    private JButton directoryButton;
    private JTextField directoryField;
    private JLabel directoryKindLabel;
    private JRadioButton directoryKindRadio;
    private JLabel directoryLabel;
    private ButtonGroup kindButtonGroup;
    private JButton masterProjectButton;
    private JTextField masterProjectField;
    private JLabel masterProjectLabel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JLabel subprojectsKindLabel;
    private JRadioButton subprojectsKindRadio;
    private JCheckBox useOpenCheckbox;

    public NewGroupPanel() {
        this.initComponents();
        DocumentListener l = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                NewGroupPanel.this.firePropertyChange("ready", null, null);
            }

            public void removeUpdate(DocumentEvent e) {
                NewGroupPanel.this.firePropertyChange("ready", null, null);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.directoryField.getDocument().addDocumentListener(l);
        this.nameField.getDocument().addDocumentListener(l);
        this.updateNameField();
    }

    public boolean isReady() {
        if (this.adHocKindRadio.isSelected()) {
            return this.nameField.getText() != null && this.nameField.getText().trim().length() > 0;
        }
        if (this.subprojectsKindRadio.isSelected()) {
            File f;
            FileObject fo;
            String s = this.masterProjectField.getText();
            if (s != null && s.length() > 0 && (fo = FileUtil.toFileObject((File)(f = new File(s)))) != null && fo.isFolder()) {
                try {
                    return ProjectManager.getDefault().findProject(fo) != null;
                }
                catch (IOException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
            return false;
        }
        assert (this.directoryKindRadio.isSelected());
        if (this.nameField.getText() == null || this.nameField.getText().trim().length() == 0) {
            return false;
        }
        String s = this.directoryField.getText();
        if (s != null) {
            return new File(s.trim()).isDirectory();
        }
        return false;
    }

    private void updateNameField() {
        String s;
        if (this.adHocKindRadio.isSelected() && this.useOpenCheckbox.isSelected()) {
            Project p = OpenProjects.getDefault().getMainProject();
            if (p != null) {
                this.nameField.setText(ProjectUtils.getInformation((Project)p).getDisplayName());
            }
        } else if (this.subprojectsKindRadio.isSelected()) {
            File f;
            FileObject fo;
            String s2 = this.masterProjectField.getText();
            if (s2 != null && s2.length() > 0 && (fo = FileUtil.toFileObject((File)(f = new File(s2)))) != null && fo.isFolder()) {
                try {
                    Project p = ProjectManager.getDefault().findProject(fo);
                    if (p != null) {
                        this.nameField.setText(ProjectUtils.getInformation((Project)p).getDisplayName());
                    }
                }
                catch (IOException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
        } else if (this.directoryKindRadio.isSelected() && (s = this.directoryField.getText()) != null && s.length() > 0) {
            File f = new File(s);
            this.nameField.setText(f.getName());
        }
    }

    public Group create() {
        assert (this.isReady());
        if (this.adHocKindRadio.isSelected()) {
            AdHocGroup g = AdHocGroup.create(this.nameField.getText().trim(), this.autoSynchCheckbox.isSelected());
            if (this.useOpenCheckbox.isSelected()) {
                g.setProjects(new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects())));
                g.setMainProject(OpenProjects.getDefault().getMainProject());
            }
            return g;
        }
        if (this.subprojectsKindRadio.isSelected()) {
            FileObject fo = FileUtil.toFileObject((File)new File(this.masterProjectField.getText()));
            try {
                return SubprojectsGroup.create(ProjectManager.getDefault().findProject(fo));
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
        }
        assert (this.directoryKindRadio.isSelected());
        FileObject f = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.directoryField.getText().trim())));
        try {
            return DirectoryGroup.create(this.nameField.getText().trim(), f);
        }
        catch (FileStateInvalidException x) {
            throw new AssertionError((Object)x);
        }
    }

    private void initComponents() {
        this.kindButtonGroup = new ButtonGroup();
        this.adHocKindRadio = new JRadioButton();
        this.adHocKindLabel = new JLabel();
        this.useOpenCheckbox = new JCheckBox();
        this.autoSynchCheckbox = new JCheckBox();
        this.subprojectsKindRadio = new JRadioButton();
        this.subprojectsKindLabel = new JLabel();
        this.masterProjectLabel = new JLabel();
        this.masterProjectField = new JTextField();
        this.masterProjectButton = new JButton();
        this.directoryKindRadio = new JRadioButton();
        this.directoryKindLabel = new JLabel();
        this.directoryLabel = new JLabel();
        this.directoryField = new JTextField();
        this.directoryButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.kindButtonGroup.add(this.adHocKindRadio);
        this.adHocKindRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.adHocKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.adHocKindRadio.text"));
        this.adHocKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.adHocKindRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.adHocKindRadioActionPerformed(evt);
            }
        });
        this.adHocKindLabel.setLabelFor(this.adHocKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.adHocKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.adHocKindLabel.text"));
        this.useOpenCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.useOpenCheckbox, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.useOpenCheckbox.text"));
        this.autoSynchCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoSynchCheckbox, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.autoSynchCheckbox.text"));
        this.kindButtonGroup.add(this.subprojectsKindRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.subprojectsKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.subprojectsKindRadio.text"));
        this.subprojectsKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.subprojectsKindRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.subprojectsKindRadioActionPerformed(evt);
            }
        });
        this.subprojectsKindLabel.setLabelFor(this.subprojectsKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.subprojectsKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.subprojectsKindLabel.text"));
        this.masterProjectLabel.setLabelFor(this.masterProjectField);
        Mnemonics.setLocalizedText((JLabel)this.masterProjectLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectLabel.text"));
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEditable(false);
        this.masterProjectField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.masterProjectButton, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectButton.text"));
        this.masterProjectButton.setEnabled(false);
        this.masterProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.masterProjectButtonActionPerformed(evt);
            }
        });
        this.kindButtonGroup.add(this.directoryKindRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.directoryKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryKindRadio.text"));
        this.directoryKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.directoryKindRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.directoryKindRadioActionPerformed(evt);
            }
        });
        this.directoryKindLabel.setLabelFor(this.directoryKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.directoryKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryKindLabel.text"));
        this.directoryLabel.setLabelFor(this.directoryField);
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryLabel.text"));
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.directoryButton, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryButton.text"));
        this.directoryButton.setEnabled(false);
        this.directoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.directoryButtonActionPerformed(evt);
            }
        });
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.nameLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.directoryKindRadio)).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.nameLabel).addPreferredGap(0).add((Component)this.nameField, -1, 546, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.adHocKindRadio)).add((GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.directoryLabel).addPreferredGap(0).add((Component)this.directoryField, -1, 430, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(103, 103, 103).add((Component)this.masterProjectField, -1, 381, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.masterProjectButton).add(2, (Component)this.directoryButton))).add((Component)this.directoryKindLabel))).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.subprojectsKindRadio).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.masterProjectLabel).addPreferredGap(0, 315, Short.MAX_VALUE)).add((Component)this.subprojectsKindLabel))).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((Component)this.adHocKindLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.autoSynchCheckbox).add((Component)this.useOpenCheckbox)))).add(115, 115, 115))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.adHocKindRadio).addPreferredGap(0).add((Component)this.adHocKindLabel).addPreferredGap(0).add((Component)this.useOpenCheckbox, -2, 23, -2).addPreferredGap(0).add((Component)this.autoSynchCheckbox).addPreferredGap(0).add((Component)this.subprojectsKindRadio).addPreferredGap(0).add((Component)this.subprojectsKindLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.masterProjectButton).add((Component)this.masterProjectLabel).add((Component)this.masterProjectField, -2, -1, -2)).addPreferredGap(0).add((Component)this.directoryKindRadio).addPreferredGap(0).add((Component)this.directoryKindLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.directoryButton).add((Component)this.directoryLabel).add((Component)this.directoryField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameField, -2, -1, -2)).addContainerGap()));
    }

    private void directoryButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        File start = ProjectChooser.getProjectsFolder();
        if (this.directoryField.getText() != null && this.directoryField.getText().trim().length() > 0) {
            start = new File(this.directoryField.getText().trim());
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)start);
        if (chooser.showOpenDialog(this) == 0 && (f = chooser.getSelectedFile()) != null) {
            this.directoryField.setText(f.getAbsolutePath());
            this.updateNameField();
        }
    }

    private void masterProjectButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = ProjectChooser.projectChooser();
        if (chooser.showOpenDialog(this) == 0 && (f = chooser.getSelectedFile()) != null) {
            this.masterProjectField.setText(f.getAbsolutePath());
            this.updateNameField();
            this.firePropertyChange("ready", null, null);
        }
    }

    private void directoryKindRadioActionPerformed(ActionEvent evt) {
        this.useOpenCheckbox.setEnabled(false);
        this.autoSynchCheckbox.setEnabled(false);
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEnabled(false);
        this.masterProjectButton.setEnabled(false);
        this.directoryLabel.setEnabled(true);
        this.directoryField.setEnabled(true);
        this.directoryButton.setEnabled(true);
        this.updateNameField();
        this.firePropertyChange("ready", null, null);
    }

    private void subprojectsKindRadioActionPerformed(ActionEvent evt) {
        this.useOpenCheckbox.setEnabled(false);
        this.autoSynchCheckbox.setEnabled(false);
        this.masterProjectLabel.setEnabled(true);
        this.masterProjectField.setEnabled(true);
        this.masterProjectButton.setEnabled(true);
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        this.directoryButton.setEnabled(false);
        this.updateNameField();
        this.firePropertyChange("ready", null, null);
    }

    private void adHocKindRadioActionPerformed(ActionEvent evt) {
        this.useOpenCheckbox.setEnabled(true);
        this.autoSynchCheckbox.setEnabled(true);
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEnabled(false);
        this.masterProjectButton.setEnabled(false);
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        this.directoryButton.setEnabled(false);
        this.updateNameField();
        this.firePropertyChange("ready", null, null);
    }
}

