/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.SubprojectsGroupEditPanel;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubprojectsGroup
extends Group {
    private static final Logger LOG = Logger.getLogger(SubprojectsGroup.class.getName());
    static final String KIND = "subprojects";

    public static SubprojectsGroup create(Project project) throws FileStateInvalidException {
        String path = project.getProjectDirectory().getURL().toExternalForm();
        String id = SubprojectsGroup.sanitizeNameAndUniquifyForId(ProjectUtils.getInformation((Project)project).getName());
        LOG.log(Level.FINE, "Creating: {0}", id);
        Preferences p = NODE.node(id);
        p.put("kind", KIND);
        p.put("path", path);
        p.put("main", path);
        return new SubprojectsGroup(id);
    }

    SubprojectsGroup(String id) {
        super(id);
    }

    @Override
    protected String getNameOrNull() {
        Project p;
        String n = super.getNameOrNull();
        if (n == null && (p = SubprojectsGroup.projectForPath(this.prefs().get("path", null))) != null) {
            return ProjectUtils.getInformation((Project)p).getDisplayName();
        }
        return n;
    }

    @Override
    protected void findProjects(Set<Project> projects, ProgressHandle h, int start, int end) {
        Project p = SubprojectsGroup.projectForPath(this.prefs().get("path", null));
        if (p != null) {
            SubprojectsGroup.visitSubprojects(p, projects, h, new int[]{start, end});
        }
    }

    private static void visitSubprojects(Project p, Set<Project> projects, ProgressHandle h, int[] startEnd) {
        if (projects.add(p)) {
            SubprojectProvider spp;
            if (h != null) {
                startEnd[0] = startEnd[0] + 1;
                h.progress(SubprojectsGroup.progressMessage(p), Math.min(startEnd[0], startEnd[1]));
            }
            if ((spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class)) != null) {
                for (Project p2 : spp.getSubprojects()) {
                    SubprojectsGroup.visitSubprojects(p2, projects, h, startEnd);
                }
            }
        }
    }

    public FileObject getMasterProjectDirectory() {
        String p = this.prefs().get("path", null);
        if (p != null && p.length() > 0) {
            try {
                return URLMapper.findFileObject((URL)new URL(p));
            }
            catch (MalformedURLException x) {
                LOG.log(Level.WARNING, null, x);
            }
        }
        return null;
    }

    @Override
    public GroupEditPanel createPropertiesPanel() {
        return new SubprojectsGroupEditPanel(this);
    }
}

