/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.PropertyEditorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EnumPropertyEditor
extends PropertyEditorSupport {
    private final Class<? extends Enum> c;

    public EnumPropertyEditor(Class<? extends Enum> c) {
        this.c = c;
    }

    @Override
    public String[] getTags() {
        try {
            Object[] values = (Object[])this.c.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            String[] tags = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                tags[i] = values[i].toString();
            }
            return tags;
        }
        catch (Exception x) {
            throw new AssertionError((Object)x);
        }
    }

    @Override
    public String getAsText() {
        Object o = this.getValue();
        return o != null ? o.toString() : "";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text.length() > 0) {
            this.setValue(Enum.valueOf(this.c, text));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getJavaInitializationString() {
        Enum e = (Enum)this.getValue();
        return e != null ? this.c.getName().replace('$', '.') + '.' + e.name() : "null";
    }
}

