/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProxyNode
extends AbstractNode {
    private static final int MAX_NAMES = 2;
    private Node[] original;
    private ArrayList<Node.PropertySet[]> originalPropertySets;
    private NodeListener pcl;
    String displayName = null;
    private String shortDescription = null;

    ProxyNode(Node[] original) {
        super(Children.LEAF);
        this.original = original;
        this.pcl = new NodeAdapter(){

            public void propertyChange(PropertyChangeEvent pce) {
                String nm = pce.getPropertyName();
                if ("cookie".equals(nm)) {
                    ProxyNode.this.fireCookieChange();
                } else if ("displayName".equals(nm)) {
                    ProxyNode.this.displayName = null;
                    ProxyNode.this.fireDisplayNameChange((String)pce.getOldValue(), ProxyNode.this.getDisplayName());
                } else if ("icon".equals(nm)) {
                    ProxyNode.this.fireIconChange();
                } else if ("openedIcon".equals(nm)) {
                    ProxyNode.this.fireOpenedIconChange();
                } else if ("name".equals(nm)) {
                    ProxyNode.this.fireNameChange((String)pce.getOldValue(), ProxyNode.this.getName());
                } else if ("propertySets".equals(nm)) {
                    Node.PropertySet[] old = ProxyNode.this.getPropertySets();
                    ProxyNode.this.setSheet(ProxyNode.this.createSheet());
                    ProxyNode.this.firePropertySetsChange(old, ProxyNode.this.getPropertySets());
                } else if ("shortDescription".equals(nm)) {
                    ProxyNode.this.fireShortDescriptionChange((String)pce.getOldValue(), ProxyNode.this.getShortDescription());
                } else if (!"leaf".equals(nm) && !"parentNode".equals(nm)) {
                    Node.PropertySet[] pss = ProxyNode.this.getPropertySets();
                    boolean exists = false;
                    for (int i = 0; i < pss.length && !exists; ++i) {
                        Node.Property[] ps = pss[i].getProperties();
                        for (int j = 0; j < ps.length && !exists; ++j) {
                            if (!ps[j].getName().equals(nm)) continue;
                            exists = true;
                        }
                    }
                    if (exists) {
                        ProxyNode.this.firePropertyChange(pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
                    }
                }
            }

            public void nodeDestroyed(NodeEvent ev) {
                int idx = Arrays.asList(ProxyNode.this.original).indexOf((Node)ev.getSource());
                if (idx != -1) {
                    HashSet<Node> set = new HashSet<Node>(Arrays.asList(ProxyNode.this.original));
                    set.remove(ev.getSource());
                    ProxyNode.access$902(ProxyNode.this, set.toArray(new Node[0]));
                    if (set.size() == 0) {
                        ProxyNode.this.fireNodeDestroyed();
                    }
                }
            }
        };
        for (int i = 0; i < original.length; ++i) {
            original[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)original[i]));
            original[i].addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)this.pcl, (Object)original[i]));
        }
    }

    public HelpCtx getHelpCtx() {
        for (int i = 0; i < this.original.length; ++i) {
            if (this.original[i].getHelpCtx() == HelpCtx.DEFAULT_HELP) continue;
            return this.original[i].getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public Node cloneNode() {
        return new ProxyNode(this.original);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set[] computedSet = this.computePropertySets();
        for (int i = 0; i < computedSet.length; ++i) {
            sheet.put(computedSet[i]);
        }
        return sheet;
    }

    Node[] getOriginalNodes() {
        return this.original;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.getConcatenatedName(2);
        }
        return this.displayName;
    }

    private String getConcatenatedName(int limit) {
        Node[] n = this.getOriginalNodes();
        StringBuffer name = new StringBuffer();
        String delim = NbBundle.getMessage(ProxyNode.class, (String)"CTL_List_Delimiter");
        for (int i = 0; i < n.length; ++i) {
            name.append(n[i].getDisplayName());
            if (i != n.length - 1) {
                name.append(delim);
            }
            if (i < limit || i == n.length - 1) continue;
            name.append(NbBundle.getMessage(ProxyNode.class, (String)"MSG_ELLIPSIS"));
            break;
        }
        return name.toString();
    }

    public String getShortDescription() {
        if (this.getOriginalNodes().length < 2) {
            return NbBundle.getMessage(ProxyNode.class, (String)"CTL_Multiple_Selection");
        }
        if (this.shortDescription == null) {
            this.shortDescription = this.getConcatenatedName(Integer.MAX_VALUE);
        }
        return this.shortDescription;
    }

    private ArrayList<Node.PropertySet[]> getOriginalPropertySets() {
        if (null == this.originalPropertySets) {
            this.originalPropertySets = new ArrayList(this.original.length);
            for (int i = 0; i < this.original.length; ++i) {
                Node.PropertySet[] p = this.original[i].getPropertySets();
                this.originalPropertySets.add(p);
            }
        }
        return this.originalPropertySets;
    }

    private Sheet.Set[] computePropertySets() {
        if (this.original.length > 0) {
            Node.PropertySet[] firstSet = this.getOriginalPropertySets().get(0);
            HashSet<Node.PropertySet> sheets = new HashSet<Node.PropertySet>(Arrays.asList(firstSet));
            for (int i = 1; i < this.original.length; ++i) {
                sheets.retainAll(new HashSet<Object>(Arrays.asList((Object[])this.getOriginalPropertySets().get(i))));
            }
            ArrayList<Sheet.Set> resultSheets = new ArrayList<Sheet.Set>(sheets.size());
            for (int i = 0; i < firstSet.length; ++i) {
                if (!sheets.contains(firstSet[i]) || firstSet[i].isHidden()) continue;
                Node.PropertySet current = firstSet[i];
                Sheet.Set res = new Sheet.Set();
                res.setName(current.getName());
                res.setDisplayName(current.getDisplayName());
                res.setShortDescription(current.getShortDescription());
                String tabName = (String)current.getValue("tabName");
                if (tabName != null) {
                    res.setValue("tabName", (Object)tabName);
                }
                HashSet<Node.Property> props = new HashSet<Node.Property>(Arrays.asList(current.getProperties()));
                Object propsHelpID = null;
                for (int j = 0; j < this.original.length; ++j) {
                    Node.PropertySet[] p = this.getOriginalPropertySets().get(j);
                    for (int k = 0; k < p.length; ++k) {
                        if (!current.getName().equals(p[k].getName())) continue;
                        props.retainAll(new HashSet<Node.Property>(Arrays.asList(p[k].getProperties())));
                    }
                }
                Node.Property[] p = current.getProperties();
                for (int j = 0; j < p.length; ++j) {
                    if (!props.contains(p[j]) || p[j].isHidden()) continue;
                    ProxyProperty pp = this.createProxyProperty(p[j].getName(), res.getName());
                    res.put((Node.Property)pp);
                }
                resultSheets.add(res);
            }
            return resultSheets.toArray(new Sheet.Set[resultSheets.size()]);
        }
        return new Sheet.Set[0];
    }

    private ProxyProperty createProxyProperty(String propName, String setName) {
        Node.Property[] arr = new Node.Property[this.original.length];
        for (int i = 0; i < this.original.length; ++i) {
            Node.PropertySet[] p = this.getOriginalPropertySets().get(i);
            for (int j = 0; j < p.length; ++j) {
                if (!p[j].getName().equals(setName)) continue;
                Node.Property[] np = p[j].getProperties();
                for (int k = 0; k < np.length; ++k) {
                    if (!np[k].getName().equals(propName)) continue;
                    arr[i] = np[k];
                }
            }
        }
        return new ProxyProperty(arr);
    }

    static /* synthetic */ Node[] access$902(ProxyNode x0, Node[] x1) {
        x0.original = x1;
        return x1;
    }

    static class DifferentValuesException
    extends RuntimeException {
        public DifferentValuesException() {
        }

        public DifferentValuesException(String message) {
            super(message);
        }
    }

    private static class ProxyProperty
    extends Node.Property {
        private Node.Property[] original;

        public ProxyProperty(Node.Property[] original) {
            super(original[0].getValueType());
            this.original = original;
            this.setName(original[0].getName());
            this.setDisplayName(original[0].getDisplayName());
            this.setShortDescription(original[0].getShortDescription());
        }

        public boolean canWrite() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].canWrite()) continue;
                return false;
            }
            return true;
        }

        public boolean canRead() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].canRead()) continue;
                return false;
            }
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Object o = this.original[0].getValue();
            if (o == null) {
                return null;
            }
            for (int i = 0; i < this.original.length; ++i) {
                if (o.equals(this.original[i].getValue())) continue;
                throw new DifferentValuesException();
            }
            return o;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].setValue(val);
            }
        }

        public Object getValue(String attributeName) {
            Object o = this.original[0].getValue(attributeName);
            if (Boolean.FALSE.equals(o)) {
                return o;
            }
            if (o == null) {
                return null;
            }
            for (int i = 1; i < this.original.length; ++i) {
                if (Boolean.FALSE.equals(this.original[i])) {
                    return this.original[i];
                }
                if (o.equals(this.original[i].getValue(attributeName))) continue;
                if (Boolean.getBoolean("netbeans.ps.logDifferentValues")) {
                    Logger.getLogger(ProxyNode.class.getName()).log(Level.WARNING, null, new DifferentValuesException("Different values in attribute " + attributeName + " for proxy property " + this.getDisplayName() + "(" + (Object)((Object)this) + ") first value=" + o + " property " + i + "(" + this.original[i].getClass().getName() + " returns " + this.original[i].getValue(attributeName)));
                }
                return null;
            }
            return o;
        }

        public void setValue(String attributeName, Object value) {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].setValue(attributeName, value);
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.original[0].getPropertyEditor();
        }

        public boolean supportsDefaultValue() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].supportsDefaultValue()) continue;
                return false;
            }
            return true;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].restoreDefaultValue();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Proxy property for: ");
            sb.append(this.getDisplayName());
            sb.append('[');
            for (int i = 0; i < this.original.length; ++i) {
                sb.append(this.original[i].getClass().getName());
                if (i >= this.original.length - 1) continue;
                sb.append(',');
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

