/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VisualizerChildren {
    public final VisualizerNode parent;
    public final List<VisualizerNode> list = new ArrayList<VisualizerNode>();

    public VisualizerChildren(VisualizerNode parent, Node[] nodes) {
        this.parent = parent;
        int s = nodes.length;
        for (int i = 0; i < s; ++i) {
            VisualizerNode v = VisualizerNode.getVisualizer(this, nodes[i]);
            this.list.add(v);
        }
    }

    public void added(VisualizerEvent.Added ev) {
        ListIterator<VisualizerNode> it = this.list.listIterator();
        boolean empty = !it.hasNext();
        int[] indxs = ev.getArray();
        Node[] nodes = ev.getAdded();
        int current = 0;
        for (int inIndxs = 0; inIndxs < indxs.length; ++inIndxs) {
            while (current++ < indxs[inIndxs]) {
                it.next();
            }
            it.add(VisualizerNode.getVisualizer(this, nodes[inIndxs]));
        }
        for (VisualizerNode parent = this.parent; parent != null; parent = (VisualizerNode)parent.getParent()) {
            Object[] listeners = parent.getListenerList();
            for (int i = listeners.length - 1; i >= 0; i -= 2) {
                ((NodeModel)listeners[i]).added(ev);
            }
        }
        if (empty) {
            this.parent.notifyVisualizerChildrenChange(this.list.size(), this);
        }
    }

    private static boolean sameContains(List l, Object elem) {
        Iterator it = l.iterator();
        while (it.hasNext()) {
            if (it.next() != elem) continue;
            return true;
        }
        return false;
    }

    public void removed(VisualizerEvent.Removed ev) {
        List<Node> remList = Arrays.asList(ev.getRemovedNodes());
        Iterator<VisualizerNode> it = this.list.iterator();
        int[] indx = new int[remList.size()];
        int count = 0;
        int remSize = 0;
        while (it.hasNext()) {
            VisualizerNode vis = it.next();
            if (VisualizerChildren.sameContains(remList, vis.node)) {
                indx[remSize++] = count;
                it.remove();
                ev.removed.add(vis);
            }
            ++count;
        }
        ev.setRemovedIndicies(indx);
        for (VisualizerNode parent = this.parent; parent != null; parent = (VisualizerNode)parent.getParent()) {
            Object[] listeners = parent.getListenerList();
            for (int i = listeners.length - 1; i >= 0; i -= 2) {
                ((NodeModel)listeners[i]).removed(ev);
            }
        }
        if (this.list.isEmpty()) {
            this.parent.notifyVisualizerChildrenChange(0, this);
        }
    }

    private int[] reorderByComparator(Comparator<VisualizerNode> c) {
        VisualizerNode[] old = this.list.toArray(new VisualizerNode[this.list.size()]);
        Arrays.sort(old, c);
        int[] idxs = new int[old.length];
        for (int i = 0; i < idxs.length; ++i) {
            idxs[i] = this.list.indexOf(old[i]);
        }
        this.list.clear();
        this.list.addAll(Arrays.asList(old));
        return idxs;
    }

    public void reordered(VisualizerEvent.Reordered ev) {
        if (ev.getComparator() != null) {
            ev.array = this.reorderByComparator(ev.getComparator());
        } else {
            int[] indxs = ev.getArray();
            VisualizerNode[] old = this.list.toArray(new VisualizerNode[this.list.size()]);
            VisualizerNode[] arr = new VisualizerNode[old.length];
            int s = indxs.length;
            try {
                for (int i = 0; i < s; ++i) {
                    VisualizerNode old_i = old[i];
                    int indxs_i = indxs[i];
                    if (arr[indxs_i] != null) {
                        System.err.println("Writing to this index for the second time: " + indxs_i);
                        System.err.println("Length of indxs array: " + indxs.length);
                        System.err.println("Length of actual array: " + old.length);
                        System.err.println("Indices of reorder event:");
                        int j = 0;
                        while (i < indxs.length) {
                            System.err.println("\t" + indxs[j]);
                            ++j;
                        }
                        Thread.dumpStack();
                        return;
                    }
                    arr[indxs_i] = old_i;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                System.err.println("Length of actual array: " + old.length);
                System.err.println("Indices of reorder event:");
                for (int i = 0; i < indxs.length; ++i) {
                    System.err.println("\t" + indxs[i]);
                }
                return;
            }
            assert (!Arrays.asList(arr).contains(null)) : "Null element in reorderer list " + Arrays.asList(arr) + "; list=" + this.list + " indxs=" + Arrays.asList(Utilities.toObjectArray((Object)indxs));
            this.list.clear();
            this.list.addAll(Arrays.asList(arr));
            assert (!this.list.contains(null));
        }
        for (VisualizerNode parent = this.parent; parent != null; parent = (VisualizerNode)parent.getParent()) {
            Object[] listeners = parent.getListenerList();
            for (int i = listeners.length - 1; i >= 0; i -= 2) {
                ((NodeModel)listeners[i]).reordered(ev);
            }
        }
    }
}

