/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerChildren;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VisualizerNode
extends EventListenerList
implements NodeListener,
TreeNode,
Runnable {
    private static final VisualizerNode TEMPLATE = new VisualizerNode(0);
    static final Logger LOG = Logger.getLogger(VisualizerNode.class.getName());
    private static final Reference<VisualizerChildren> NO_REF = new WeakReference<Object>(null);
    private static WeakHashMap<VisualizerNode, Reference<VisualizerNode>> cache = new WeakHashMap();
    public static final VisualizerNode EMPTY = VisualizerNode.getVisualizer(null, Node.EMPTY);
    private static final QP QUEUE = new QP();
    private static final String UNKNOWN = new String();
    static final long serialVersionUID = 3726728244698316872L;
    private static final String NO_HTML_DISPLAYNAME = "noHtmlDisplayName";
    private static Icon defaultIcon;
    private static final String DEFAULT_ICON = "org/openide/nodes/defaultNode.png";
    private Icon icon = null;
    Node node;
    private int hashCode;
    private Reference<VisualizerChildren> children = NO_REF;
    private VisualizerChildren parent;
    private String name;
    private String displayName;
    private String shortDescription;
    private transient boolean inRead;
    private String htmlDisplayName = null;
    private int cachedIconType = -1;

    private VisualizerNode(int hashCode) {
        this.hashCode = hashCode;
        this.node = null;
    }

    private VisualizerNode(Node n) {
        this.node = n;
        this.hashCode = System.identityHashCode(this.node);
        this.node.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)this.node));
        this.name = UNKNOWN;
        this.displayName = UNKNOWN;
        this.shortDescription = UNKNOWN;
    }

    public static VisualizerNode getVisualizer(VisualizerChildren ch, Node n) {
        return VisualizerNode.getVisualizer(ch, n, true);
    }

    public static synchronized VisualizerNode getVisualizer(VisualizerChildren ch, Node n, boolean create) {
        VisualizerNode v;
        VisualizerNode.TEMPLATE.hashCode = System.identityHashCode(n);
        VisualizerNode.TEMPLATE.node = n;
        Reference<VisualizerNode> r = cache.get(TEMPLATE);
        VisualizerNode.TEMPLATE.hashCode = 0;
        VisualizerNode.TEMPLATE.node = null;
        VisualizerNode visualizerNode = v = r == null ? null : r.get();
        if (v == null) {
            if (!create) {
                return null;
            }
            v = new VisualizerNode(n);
            cache.put(v, new WeakReference<VisualizerNode>(v));
        }
        if (ch != null) {
            v.parent = ch;
        }
        return v;
    }

    public String getShortDescription() {
        String desc = this.shortDescription;
        if (desc == UNKNOWN) {
            this.shortDescription = desc = this.node.getShortDescription();
        }
        return desc;
    }

    public String getDisplayName() {
        if (this.displayName == UNKNOWN) {
            this.displayName = this.node == null ? null : this.node.getDisplayName();
        }
        return this.displayName;
    }

    public String getName() {
        if (this.name == UNKNOWN) {
            this.name = this.node == null ? null : this.node.getName();
        }
        return this.name;
    }

    public List<VisualizerNode> getChildren() {
        VisualizerChildren ch = this.children.get();
        if (ch == null && !this.node.isLeaf()) {
            Node[] tmpInit = this.node.getChildren().getNodes();
            ch = (VisualizerChildren)Children.MUTEX.readAccess((Mutex.Action)new Mutex.Action<VisualizerChildren>(){

                public VisualizerChildren run() {
                    Node[] nodes = VisualizerNode.this.node.getChildren().getNodes();
                    VisualizerChildren vc = new VisualizerChildren(VisualizerNode.this, nodes);
                    VisualizerNode.this.notifyVisualizerChildrenChange(nodes.length, vc);
                    return vc;
                }
            });
        }
        if (LOG.isLoggable(Level.FINER)) assert (ch == null || !ch.list.contains(null)) : ch.list + " from " + this.node;
        return ch == null ? Collections.emptyList() : ch.list;
    }

    @Override
    public int getIndex(TreeNode p1) {
        return this.getChildren().indexOf(p1);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public TreeNode getChildAt(int p1) {
        List<VisualizerNode> ch = this.getChildren();
        VisualizerNode vn = ch.get(p1);
        assert (vn != null) : "Null child in " + ch + " from " + this.node;
        return vn;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    public Enumeration<VisualizerNode> children() {
        List<VisualizerNode> l = this.getChildren();
        assert (!l.contains(null)) : "Null child in " + l + " from " + this.node;
        return Collections.enumeration(l);
    }

    @Override
    public boolean isLeaf() {
        return this.node.isLeaf();
    }

    @Override
    public TreeNode getParent() {
        Node parent = this.node.getParentNode();
        return parent == null ? null : VisualizerNode.getVisualizer(null, parent);
    }

    public void childrenAdded(NodeMemberEvent ev) {
        VisualizerChildren ch = this.children.get();
        LOG.log(Level.FINER, "childrenAdded {0}", ev);
        if (ch == null) {
            LOG.log(Level.FINER, "childrenAdded - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Added(ch, ev.getDelta(), ev.getDeltaIndices()));
        LOG.log(Level.FINER, "childrenAdded - end");
    }

    public void childrenRemoved(NodeMemberEvent ev) {
        VisualizerChildren ch = this.children.get();
        LOG.log(Level.FINER, "childrenRemoved {0}", ev);
        if (ch == null) {
            LOG.log(Level.FINER, "childrenRemoved - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Removed(ch, ev.getDelta()));
        LOG.log(Level.FINER, "childrenRemoved - end");
    }

    public void childrenReordered(NodeReorderEvent ev) {
        this.doChildrenReordered(ev.getPermutation());
    }

    void doChildrenReordered(int[] perm) {
        VisualizerChildren ch = this.children.get();
        LOG.log(Level.FINER, "childrenReordered {0}", (Object)perm);
        if (ch == null) {
            LOG.log(Level.FINER, "childrenReordered - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Reordered(ch, perm));
        LOG.log(Level.FINER, "childrenReordered - end");
    }

    void reorderChildren(Comparator<VisualizerNode> c) {
        assert (SwingUtilities.isEventDispatchThread());
        VisualizerChildren ch = this.children.get();
        if (ch == null) {
            return;
        }
        new VisualizerEvent.Reordered(ch, c).run();
    }

    void naturalOrder() {
        this.children.clear();
        this.getChildren();
        this.reorderChildren(new Comparator<VisualizerNode>(){

            @Override
            public int compare(VisualizerNode o1, VisualizerNode o2) {
                return 0;
            }
        });
    }

    public void nodeDestroyed(NodeEvent ev) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        boolean isIconChange;
        String name = evt.getPropertyName();
        boolean bl = isIconChange = "icon".equals(name) || "openedIcon".equals(name);
        if ("name".equals(name) || "displayName".equals(name) || isIconChange) {
            if (isIconChange) {
                this.cachedIconType = -1;
            }
            if ("displayName".equals(name)) {
                this.htmlDisplayName = null;
            }
            SwingUtilities.invokeLater(this);
            return;
        }
        if ("shortDescription".equals(name) && this.shortDescription != UNKNOWN) {
            SwingUtilities.invokeLater(this);
            return;
        }
        if ("leaf".equals(name)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VisualizerNode.this.children = NO_REF;
                    for (VisualizerNode parent = VisualizerNode.this; parent != null; parent = (VisualizerNode)parent.getParent()) {
                        Object[] listeners = parent.getListenerList();
                        for (int i = listeners.length - 1; i >= 0; i -= 2) {
                            ((NodeModel)listeners[i]).structuralChange(VisualizerNode.this);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.inRead) {
            try {
                this.inRead = true;
                Children.MUTEX.readAccess((Runnable)this);
            }
            finally {
                this.inRead = false;
            }
            return;
        }
        this.name = this.node.getName();
        this.displayName = this.node.getDisplayName();
        this.shortDescription = UNKNOWN;
        for (VisualizerNode parent = this; parent != null; parent = (VisualizerNode)parent.getParent()) {
            Object[] listeners = parent.getListenerList();
            for (int i = listeners.length - 1; i >= 0; i -= 2) {
                ((NodeModel)listeners[i]).update(this);
            }
        }
    }

    void notifyVisualizerChildrenChange(int size, VisualizerChildren ch) {
        this.children = size == 0 ? new StrongReference<VisualizerChildren>(ch) : new WeakReference<VisualizerChildren>(ch);
    }

    public synchronized void addNodeModel(NodeModel l) {
        this.add(NodeModel.class, l);
    }

    public synchronized void removeNodeModel(NodeModel l) {
        this.remove(NodeModel.class, l);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VisualizerNode)) {
            return false;
        }
        VisualizerNode v = (VisualizerNode)o;
        return v.node == this.node;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (this.htmlDisplayName == null) {
            this.htmlDisplayName = this.node.getHtmlDisplayName();
            if (this.htmlDisplayName == null) {
                this.htmlDisplayName = NO_HTML_DISPLAYNAME;
            }
        }
        return this.htmlDisplayName == NO_HTML_DISPLAYNAME ? null : this.htmlDisplayName;
    }

    Icon getIcon(boolean opened, boolean large) {
        int newCacheType = VisualizerNode.getCacheType(opened, large);
        if (this.cachedIconType != newCacheType) {
            Image image;
            int iconType = large ? 2 : 1;
            Image image2 = image = opened ? this.node.getOpenedIcon(iconType) : this.node.getIcon(iconType);
            if (image == null) {
                String method = opened ? "getOpenedIcon" : "getIcon";
                LOG.warning("Node \"" + this.node.getName() + "\" [" + this.node.getClass().getName() + "] cannot return null from " + method + "(). See Node." + method + " contract.");
                this.icon = VisualizerNode.getDefaultIcon();
            } else {
                this.icon = new ImageIcon(image);
            }
        }
        this.cachedIconType = newCacheType;
        return this.icon;
    }

    private static final int getCacheType(boolean opened, boolean large) {
        return (opened ? 2 : 0) | (large ? 1 : 0);
    }

    private static Icon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = new ImageIcon(Utilities.loadImage((String)DEFAULT_ICON));
        }
        return defaultIcon;
    }

    static void runQueue() {
        QUEUE.run();
    }

    private static final class QP
    implements Runnable {
        private LinkedList<Runnable> queue = null;

        QP() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSafe(Runnable run) {
            boolean isNew = false;
            QP qP = this;
            synchronized (qP) {
                if (this.queue == null) {
                    this.queue = new LinkedList();
                    isNew = true;
                }
                this.queue.add(run);
            }
            if (isNew) {
                Mutex.EVENT.writeAccess((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Enumeration<Runnable> en;
            QP qP = this;
            synchronized (qP) {
                if (this.queue == null) {
                    LOG.log(Level.FINER, "Queue empty");
                    return;
                }
                en = Collections.enumeration(this.queue);
                this.queue = null;
                LOG.log(Level.FINER, "Queue emptied");
            }
            while (en.hasMoreElements()) {
                Runnable r = en.nextElement();
                LOG.log(Level.FINER, "Running {0}", r);
                Children.MUTEX.readAccess(r);
                LOG.log(Level.FINER, "Finished {0}", r);
            }
            LOG.log(Level.FINER, "Queue processing over");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StrongReference<T>
    extends WeakReference<T> {
        private T o;

        public StrongReference(T o) {
            super(null);
            this.o = o;
        }

        @Override
        public T get() {
            return this.o;
        }
    }
}

