/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.options;

import java.util.Arrays;
import java.util.logging.Logger;
import org.netbeans.modules.options.CategoryModel;
import org.netbeans.modules.options.OptionsDisplayerImpl;
import org.openide.util.Mutex;

public final class OptionsDisplayer {
    private static final OptionsDisplayer INSTANCE = new OptionsDisplayer();
    private final OptionsDisplayerImpl impl = new OptionsDisplayerImpl(false);
    private static Logger log = Logger.getLogger(OptionsDisplayer.class.getName());

    private OptionsDisplayer() {
    }

    public static OptionsDisplayer getDefault() {
        return INSTANCE;
    }

    public boolean open() {
        return this.open(CategoryModel.getInstance().getCurrentCategoryID());
    }

    public boolean open(String categoryId) {
        log.fine("Open Options Dialog: " + categoryId);
        return this.openImpl(categoryId);
    }

    private boolean openImpl(final String categoryId) {
        Boolean retval = (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                boolean retvalForRun;
                Boolean r = OptionsDisplayer.this.impl.isOpen();
                boolean bl = retvalForRun = r == false;
                if (retvalForRun) {
                    retvalForRun = Arrays.asList(CategoryModel.getInstance().getCategoryIDs()).contains(categoryId);
                    if (!retvalForRun) {
                        log.warning("Unknown categoryId: " + categoryId);
                    }
                } else {
                    log.warning("Options Dialog is opened");
                }
                if (retvalForRun) {
                    OptionsDisplayer.this.impl.showOptionsDialog(categoryId);
                }
                return retvalForRun;
            }
        });
        return retval;
    }
}

