/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASTNode
extends ASTItem {
    private String nt;
    private Map<String, ASTItem> nameToChild = null;

    public static ASTNode create(String mimeType, String nt, List<ASTItem> children, int offset) {
        return new ASTNode(mimeType, nt, offset, children);
    }

    public static ASTNode create(String mimeType, String nt, int offset) {
        return new ASTNode(mimeType, nt, offset, Collections.<ASTItem>emptyList());
    }

    private ASTNode(String mimeType, String nt, int offset, List<ASTItem> children) {
        super(mimeType, offset, -1, children);
        this.nt = nt;
    }

    public String getNT() {
        return this.nt;
    }

    public ASTPath findToken(String type, String identifier) {
        ArrayList<ASTItem> path = new ArrayList<ASTItem>();
        this.findToken(type, identifier, path);
        if (path.isEmpty()) {
            return null;
        }
        return ASTPath.create(path);
    }

    private boolean findToken(String type, String identifier, List<ASTItem> path) {
        path.add(this);
        for (ASTItem e : this.getChildren()) {
            if (e instanceof ASTToken) {
                ASTToken t = (ASTToken)e;
                if (type != null && !type.equals(t.getType()) || identifier != null && !identifier.equals(t.getIdentifier())) continue;
                return true;
            }
            if (!((ASTNode)e).findToken(type, identifier, path)) continue;
            return true;
        }
        path.remove(path.size() - 1);
        return false;
    }

    public ASTNode findNode(String nt, int offset) {
        if (nt.equals(this.getNT())) {
            return this;
        }
        for (ASTItem e : this.getChildren()) {
            ASTNode node;
            if (!(e instanceof ASTNode) || (node = (ASTNode)e).getOffset() > offset || offset >= node.getEndOffset()) continue;
            return node.findNode(nt, offset);
        }
        return null;
    }

    public String getTokenTypeIdentifier(String type) {
        ASTToken token = this.getTokenType(type);
        if (token == null) {
            return null;
        }
        return token.getIdentifier();
    }

    public ASTToken getTokenType(String type) {
        ASTNode node = this;
        int i = type.lastIndexOf(46);
        if (i >= 0) {
            node = this.getNode(type.substring(0, i));
        }
        if (node == null) {
            return null;
        }
        Object o = node.getChild("token-type-" + type.substring(i + 1));
        if (o == null) {
            return null;
        }
        if (!(o instanceof ASTToken)) {
            return null;
        }
        return (ASTToken)o;
    }

    public ASTNode getNode(String path) {
        ASTNode node = this;
        int s = 0;
        int e = path.indexOf(46);
        while (e >= 0) {
            if ((node = (ASTNode)node.getChild("node-" + path.substring(s, e))) == null) {
                return null;
            }
            s = e + 1;
            e = path.indexOf(46, s);
        }
        return (ASTNode)node.getChild("node-" + path.substring(s));
    }

    private Object getChild(String name) {
        if (this.nameToChild == null) {
            this.nameToChild = new HashMap<String, ASTItem>();
            for (ASTItem item : this.getChildren()) {
                if (item instanceof ASTToken) {
                    ASTToken t = (ASTToken)item;
                    this.nameToChild.put("token-type-" + t.getType(), t);
                    continue;
                }
                this.nameToChild.put("node-" + ((ASTNode)item).getNT(), item);
            }
        }
        return this.nameToChild.get(name);
    }

    public String print() {
        return this.print("");
    }

    private String print(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("ASTNode ").append(this.getNT()).append(' ').append(this.getOffset()).append('-').append(this.getEndOffset());
        indent = "  " + indent;
        for (ASTItem elem : this.getChildren()) {
            if (elem instanceof ASTNode) {
                sb.append('\n').append(((ASTNode)elem).print(indent));
                continue;
            }
            sb.append('\n').append(indent).append(elem);
        }
        return sb.toString();
    }

    public String getAsText() {
        StringBuilder sb = new StringBuilder();
        for (ASTItem elem : this.getChildren()) {
            if (elem instanceof ASTNode) {
                sb.append(((ASTNode)elem).getAsText());
                continue;
            }
            sb.append(((ASTToken)elem).getIdentifier());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ASTNode ").append(this.getNT()).append(' ').append(this.getOffset()).append('-').append(this.getEndOffset());
        for (ASTItem elem : this.getChildren()) {
            if (elem instanceof ASTNode) {
                sb.append("\n    ").append(((ASTNode)elem).getNT() + "...");
                continue;
            }
            sb.append("\n    ").append(elem);
        }
        return sb.toString();
    }
}

