/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public abstract class Context {
    public abstract JTextComponent getJTextComponent();

    public abstract Document getDocument();

    public abstract TokenSequence getTokenSequence();

    public static Context create(Document doc, TokenSequence tokenSequence) {
        return new CookieImpl(doc, tokenSequence);
    }

    private static class CookieImpl
    extends Context {
        private Document doc;
        private JTextComponent component;
        private TokenSequence tokenSequence;

        CookieImpl(Document doc, TokenSequence tokenSequence) {
            this.doc = doc;
            this.tokenSequence = tokenSequence;
        }

        public JTextComponent getJTextComponent() {
            DataObject dob;
            EditorCookie ec;
            if (this.component == null && (ec = (EditorCookie)(dob = NbEditorUtilities.getDataObject((Document)this.doc)).getLookup().lookup(EditorCookie.class)).getOpenedPanes().length > 0) {
                this.component = ec.getOpenedPanes()[0];
            }
            return this.component;
        }

        public Document getDocument() {
            return this.doc;
        }

        public TokenSequence getTokenSequence() {
            return this.tokenSequence;
        }
    }
}

