/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTToken;

public class Highlighting {
    private static Map<Document, WeakReference<Highlighting>> highlightings = new WeakHashMap<Document, WeakReference<Highlighting>>();
    private Map<ASTNode, AttributeSet> highlights = new HashMap<ASTNode, AttributeSet>();
    private Map<Integer, Map<String, AttributeSet>> tokens = new HashMap<Integer, Map<String, AttributeSet>>();

    public static Highlighting getHighlighting(Document document) {
        Highlighting highlighting;
        WeakReference<Highlighting> wr = highlightings.get(document);
        Highlighting highlighting2 = highlighting = wr == null ? null : (Highlighting)wr.get();
        if (highlighting == null) {
            highlighting = new Highlighting();
            highlightings.put(document, new WeakReference<Highlighting>(highlighting));
        }
        return highlighting;
    }

    private Highlighting() {
    }

    public void highlight(ASTItem item, AttributeSet as) {
        if (item instanceof ASTNode) {
            this.highlights.put((ASTNode)item, as);
            return;
        }
        ASTToken token = (ASTToken)item;
        Integer id = new Integer(token.getOffset());
        Map<String, AttributeSet> m = this.tokens.get(id);
        if (m == null) {
            m = new HashMap<String, AttributeSet>();
            this.tokens.put(id, m);
        }
        m.put(token.getIdentifier(), as);
    }

    public void removeHighlight(ASTItem item) {
        if (item instanceof ASTNode) {
            this.highlights.remove((ASTNode)item);
            return;
        }
        ASTToken token = (ASTToken)item;
        Integer id = new Integer(token.getOffset());
        Map<String, AttributeSet> m = this.tokens.get(id);
        if (m == null) {
            return;
        }
        m.remove(token.getIdentifier());
        if (m.isEmpty()) {
            this.tokens.remove(id);
        }
    }

    public AttributeSet get(ASTItem item) {
        if (item instanceof ASTNode) {
            return this.highlights.get((ASTNode)item);
        }
        ASTToken token = (ASTToken)item;
        Integer id = new Integer(token.getOffset());
        Map<String, AttributeSet> m = this.tokens.get(id);
        if (m == null) {
            return null;
        }
        return m.get(token.getIdentifier());
    }
}

