/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.NBSLanguageReader;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.features.ActionCreator;
import org.netbeans.modules.languages.features.ColorsManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

public class LanguagesManager
extends org.netbeans.api.languages.LanguagesManager {
    private static LanguagesManager languagesManager;
    private Language parsingLanguage = new Language("parsing...");
    private Map<String, Language> mimeTypeToLanguage = new HashMap<String, Language>();
    private Vector<LanguagesManagerListener> listeners = new Vector();
    private Set<FileObject> listeningOn = new HashSet<FileObject>();
    private Listener listener;

    public static LanguagesManager getDefault() {
        if (languagesManager == null) {
            languagesManager = new LanguagesManager();
        }
        return languagesManager;
    }

    public boolean isSupported(String mimeType) {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        return fs.findResource("Editors/" + mimeType + "/language.nbs") != null;
    }

    public boolean createDataObjectFor(String mimeType) {
        if (!this.isSupported(mimeType)) {
            return false;
        }
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("Editors/" + mimeType);
        if (fo == null) {
            return false;
        }
        Boolean b = (Boolean)fo.getAttribute("createDataObject");
        if (b == null) {
            return true;
        }
        return b;
    }

    public synchronized Language getLanguage(String mimeType) throws LanguageDefinitionNotFoundException {
        if (!this.mimeTypeToLanguage.containsKey(mimeType)) {
            this.mimeTypeToLanguage.put(mimeType, this.parsingLanguage);
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource("Editors/" + mimeType + "/language.nbs");
            if (fo == null) {
                this.mimeTypeToLanguage.remove(mimeType);
                throw new LanguageDefinitionNotFoundException("Language definition for " + mimeType + " not found.");
            }
            this.addListener(fo);
            Language l = null;
            try {
                l = NBSLanguageReader.readLanguage(fo, mimeType);
                l.getAnalyser();
                this.initLanguage(l);
            }
            catch (ParseException ex) {
                l = new Language(mimeType);
                Utils.message(ex.getMessage());
            }
            catch (IOException ex) {
                l = new Language(mimeType);
                Utils.message("Editors/" + mimeType + "/language.nbs: " + ex.getMessage());
            }
            this.mimeTypeToLanguage.put(mimeType, l);
        }
        if (this.parsingLanguage == this.mimeTypeToLanguage.get(mimeType)) {
            throw new IllegalArgumentException();
        }
        return this.mimeTypeToLanguage.get(mimeType);
    }

    public void addLanguage(Language l) {
        this.mimeTypeToLanguage.put(l.getMimeType(), l);
    }

    public void addLanguagesManagerListener(LanguagesManagerListener l) {
        this.listeners.add(l);
    }

    public void removeLanguagesManagerListener(LanguagesManagerListener l) {
        this.listeners.remove(l);
    }

    private void languageChanged(String mimeType) {
        this.mimeTypeToLanguage.remove(mimeType);
        Vector v = (Vector)this.listeners.clone();
        for (LanguagesManagerListener l : v) {
            l.languageChanged(mimeType);
        }
    }

    private void addListener(FileObject fo) {
        if (!this.listeningOn.contains(fo)) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            fo.addFileChangeListener((FileChangeListener)this.listener);
            this.listeningOn.add(fo);
        }
    }

    private void initLanguage(Language l) {
        try {
            String foldFileName;
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            final FileObject root = fs.findResource("Editors/" + l.getMimeType());
            if (root.getFileObject("Settings.settings") == null) {
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/languages/resources/LanguagesOptions.settings");
                            try {
                                FileObject fo = root.createData("Settings.settings");
                                OutputStream os = fo.getOutputStream();
                                try {
                                    FileUtil.copy((InputStream)is, (OutputStream)os);
                                }
                                finally {
                                    os.close();
                                }
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (IOException ex) {
                            Utils.notify(ex);
                        }
                    }
                });
            }
            if (root.getFileObject("SideBar/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance") == null && l.getFeatures("FOLD").size() > 0) {
                FileUtil.createData((FileObject)root, (String)"FoldManager/org-netbeans-modules-languages-features-LanguagesFoldManager$Factory.instance");
                FileUtil.createData((FileObject)root, (String)"SideBar/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance");
                FileObject fo = root.getFileObject("SideBar");
                fo.setAttribute("org-netbeans-editor-GlyphGutter.instance/org-netbeans-modules-languages-features-CodeFoldingSideBarFactory.instance", (Object)Boolean.TRUE);
            }
            if (root.getFileObject("UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance") == null) {
                FileUtil.createData((FileObject)root, (String)"UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance");
            }
            LanguagesManager.initPopupMenu(root, l);
            if (l.getFeatures("NAVIGATOR").size() > 0 && fs.findResource(foldFileName = "Navigator/Panels/" + l.getMimeType() + "/org-netbeans-modules-languages-features-LanguagesNavigator.instance") == null) {
                FileUtil.createData((FileObject)fs.getRoot(), (String)foldFileName);
            }
            if (l.getFeatures("TOOLTIP").size() > 0) {
                FileUtil.createData((FileObject)root, (String)"ToolTips/org-netbeans-modules-languages-features-ToolTipAnnotation.instance");
            }
        }
        catch (IOException ex) {
            Utils.notify(ex);
        }
        ColorsManager.initColorings(l);
    }

    private static void initPopupMenu(FileObject root, Language l) throws IOException {
        FileObject popup = FileUtil.createFolder((FileObject)root, (String)"Popup");
        LanguagesManager.createSeparator(popup, "SeparatorAfterSelectInPopupAction", "org-netbeans-modules-editor-NbSelectInPopupAction.instance", null);
        List<Feature> actions = l.getFeatures("ACTION");
        String lastAction = "SeparatorAfterSelectInPopupAction.instance";
        boolean actionAdded = false;
        for (Feature action : actions) {
            if (action.getBoolean("explorer", false)) continue;
            actionAdded = true;
            String name = action.getSelector().getAsString();
            String displayName = l.localize((String)action.getValue("name"));
            String performer = action.getMethodName("performer");
            String enabler = action.getMethodName("enabled");
            String installAfter = (String)action.getValue("install_after");
            String installBefore = (String)action.getValue("install_before");
            boolean separatorBefore = action.getBoolean("separator_before", false);
            boolean separatorAfter = action.getBoolean("separator_after", false);
            FileObject fobj = FileUtil.createData((FileObject)popup, (String)(name + ".instance"));
            fobj.setAttribute("instanceCreate", (Object)new ActionCreator(new Object[]{displayName, performer, enabler}));
            fobj.setAttribute("instanceClass", (Object)"org.netbeans.modules.languages.features.GenericAction");
            if (separatorBefore) {
                LanguagesManager.createSeparator(popup, name + "_separator_before", installBefore, name + ".instance");
                popup.setAttribute(name + "_separator_before/" + name + ".instance", (Object)Boolean.TRUE);
            } else if (installBefore != null) {
                popup.setAttribute(installBefore + "/" + name + ".instance", (Object)Boolean.TRUE);
            } else {
                popup.setAttribute(lastAction + "/" + name + ".instance", (Object)Boolean.TRUE);
            }
            if (separatorAfter) {
                LanguagesManager.createSeparator(popup, name + "_separator_after", installAfter, name + ".instance");
                popup.setAttribute(name + "_separator_after/" + name + ".instance", (Object)Boolean.TRUE);
            } else if (installAfter != null) {
                popup.setAttribute(installAfter + "/" + name + ".instance", (Object)Boolean.TRUE);
            }
            if (installAfter != null || installBefore != null) continue;
            lastAction = name + ".instance";
        }
        if (actionAdded) {
            LanguagesManager.createSeparator(popup, "SeparatorBeforeCut", lastAction, "org-openide-actions-CutAction.instance");
        }
        LanguagesManager.createSeparator(popup, "SeparatorAfterPaste", "org-openide-actions-PasteAction.instance", "generate-fold-popup");
        FileUtil.createData((FileObject)popup, (String)"generate-fold-popup");
    }

    private String spacesToDashes(String text) {
        StringBuffer buf = new StringBuffer();
        int length = text.length();
        for (int x = 0; x < length; ++x) {
            char c = text.charAt(x);
            buf.append(Character.isWhitespace(c) ? (char)'_' : (char)c);
        }
        return buf.toString();
    }

    private static void createSeparator(FileObject folder, String name, String after, String before) throws IOException {
        name = name + ".instance";
        FileObject separator = FileUtil.createData((FileObject)folder, (String)name);
        separator.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
        if (after != null) {
            folder.setAttribute(after + "/" + name, (Object)Boolean.TRUE);
        }
        if (before != null) {
            folder.setAttribute(name + "/" + before, (Object)Boolean.TRUE);
        }
    }

    public static interface LanguagesManagerListener {
        public void languageChanged(String var1);
    }

    private class Listener
    implements FileChangeListener {
        private Listener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            FileObject fo = fe.getFile();
            String mimeType = fo.getParent().getParent().getName() + '/' + fo.getParent().getName();
            LanguagesManager.this.languageChanged(mimeType);
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            FileObject fo = fe.getFile();
            String mimeType = fo.getParent().getName();
            LanguagesManager.this.languageChanged(mimeType);
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }
    }
}

