/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.NBSLanguage;
import org.netbeans.modules.languages.Selector;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.Pattern;
import org.netbeans.modules.languages.parser.StringInput;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.filesystems.FileObject;

public class NBSLanguageReader {
    private static Language nbsLanguage;

    public static Language readLanguage(FileObject fo, String mimeType) throws ParseException, IOException {
        return NBSLanguageReader.readLanguage(fo.getInputStream(), fo.getPath(), mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language readLanguage(InputStream is, String sourceName, String mimeType) throws ParseException, IOException {
        BufferedReader reader = null;
        try {
            InputStreamReader r = new InputStreamReader(is);
            reader = new BufferedReader(r);
            StringBuilder sb = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = reader.readLine();
            }
            Language language = NBSLanguageReader.readLanguage(sb.toString(), sourceName, mimeType);
            return language;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static Language readLanguage(String source, String sourceName, String mimeType) throws ParseException {
        StringInput input = new StringInput(source);
        Language language = new Language(mimeType);
        ASTNode node = null;
        TokenInput tokenInput = null;
        try {
            Language nbsLanguage = NBSLanguageReader.getNBSLanguage();
            tokenInput = TokenInputUtils.create(mimeType, nbsLanguage.getParser(), input, Collections.EMPTY_SET);
            node = nbsLanguage.getAnalyser().read(tokenInput, false);
            if (node == null) {
                System.out.println("Can not parse " + sourceName);
            } else if (node.getChildren().isEmpty()) {
                System.out.println("Can not parse " + sourceName + " " + node.getNT());
            }
        }
        catch (ParseException ex) {
            Point p = Utils.findPosition(source, tokenInput.getOffset());
            throw new ParseException(sourceName + " " + p.x + "," + p.y + ": " + ex.getMessage());
        }
        NBSLanguageReader.readBody(source, sourceName, node, language);
        return language;
    }

    private static Language getNBSLanguage() throws ParseException {
        if (nbsLanguage == null) {
            nbsLanguage = NBSLanguage.getNBSLanguage();
        }
        return nbsLanguage;
    }

    private static void readBody(String source, String sourceName, ASTNode root, Language language) throws ParseException {
        for (ASTItem o : root.getChildren()) {
            if (o instanceof ASTToken) continue;
            ASTNode node = (ASTNode)o;
            if (node.getNT().equals("token")) {
                NBSLanguageReader.readToken(source, sourceName, node, language, null);
                continue;
            }
            if (node.getNT().equals("tokenState")) {
                NBSLanguageReader.readTokenState(source, sourceName, node, language);
                continue;
            }
            if (node.getNT().equals("grammarRule")) {
                NBSLanguageReader.readGrammarRule(node, language);
                continue;
            }
            if (node.getNT().equals("command")) {
                NBSLanguageReader.readCommand(source, sourceName, node, language);
                continue;
            }
            throw new ParseException("Unknown grammar rule (" + node.getNT() + ").");
        }
    }

    private static void readToken(String source, String sourceName, ASTNode node, Language language, String state) throws ParseException {
        String startState = null;
        String endState = null;
        Pattern pattern = null;
        Feature properties = null;
        String name = node.getTokenType("identifier").getIdentifier();
        ASTNode pnode = node.getNode("token2.properties");
        if (pnode != null) {
            properties = NBSLanguageReader.readProperties(source, sourceName, null, null, pnode);
            startState = (String)properties.getValue("start_state");
            endState = (String)properties.getValue("end_state");
            pattern = properties.getPattern("pattern");
            if (pattern == null && properties.getType("call") == Feature.Type.METHOD_CALL) {
                pattern = Pattern.create(".");
            }
        } else {
            ASTNode regularExpressionNode = node.getNode("token2.regularExpression");
            String patternString = regularExpressionNode.getAsText().trim();
            endState = node.getTokenTypeIdentifier("token2.token3.state.identifier");
            pattern = NBSLanguageReader.readPattern(source, sourceName, patternString, regularExpressionNode.getOffset());
        }
        if (startState != null && state != null) {
            throw new ParseException("Start state should not be specified inside token group block!");
        }
        if (startState == null) {
            startState = state;
        }
        if (endState == null) {
            endState = state;
        }
        language.addToken(startState, name, pattern, endState, properties);
    }

    private static void readGrammarRule(ASTNode node, Language language) {
        language.addRule(node);
    }

    private static void readTokenState(String source, String sourceName, ASTNode node, Language language) throws ParseException {
        String startState = node.getTokenTypeIdentifier("state.identifier");
        ASTNode n = node.getNode("tokenState1.token");
        if (n != null) {
            NBSLanguageReader.readToken(source, sourceName, n, language, startState);
        } else {
            NBSLanguageReader.readTokenGroup(source, sourceName, node.getNode("tokenState1.tokenGroup"), language, startState);
        }
    }

    private static void readTokenGroup(String source, String sourceName, ASTNode node, Language language, String startState) throws ParseException {
        for (ASTItem o : node.getNode("tokensInGroup").getChildren()) {
            if (o instanceof ASTToken) continue;
            ASTNode n = (ASTNode)o;
            NBSLanguageReader.readToken(source, sourceName, n, language, startState);
        }
    }

    private static void readCommand(String source, String sourceName, ASTNode commandNode, Language language) throws ParseException {
        String keyword = commandNode.getTokenTypeIdentifier("keyword");
        ASTNode command0Node = commandNode.getNode("command0");
        ASTNode selectorNode = command0Node.getNode("selector");
        Selector selector = null;
        Feature feature = null;
        if (selectorNode != null) {
            ASTNode classNode = selectorNode.getNode("class");
            selector = Selector.create(NBSLanguageReader.readClass(classNode));
            ASTNode command1Node = command0Node.getNode("command1");
            ASTNode valueNode = command1Node.getNode("value");
            feature = valueNode != null ? NBSLanguageReader.readValue(source, sourceName, keyword, selector, valueNode) : Feature.create(keyword, selector);
        } else {
            ASTNode valueNode = command0Node.getNode("value");
            feature = NBSLanguageReader.readValue(source, sourceName, keyword, selector, valueNode);
        }
        language.addFeature(feature);
    }

    private static Feature readValue(String source, String sourceName, String keyword, Selector selector, ASTNode valueNode) throws ParseException {
        ASTNode propertiesNode = valueNode.getNode("properties");
        if (propertiesNode != null) {
            return NBSLanguageReader.readProperties(source, sourceName, keyword, selector, propertiesNode);
        }
        ASTNode classNode = valueNode.getNode("class");
        if (classNode != null) {
            return Feature.createMethodCallFeature(keyword, selector, NBSLanguageReader.readClass(classNode));
        }
        String s = valueNode.getTokenTypeIdentifier("string");
        s = s.substring(1, s.length() - 1);
        return Feature.createExpressionFeature(keyword, selector, NBSLanguageReader.c(s));
    }

    private static Feature readProperties(String source, String sourceName, String keyword, Selector selector, ASTNode node) throws ParseException {
        HashMap<String, String> methods = new HashMap<String, String>();
        HashMap<String, String> expressions = new HashMap<String, String>();
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        for (ASTItem o : node.getChildren()) {
            if (o instanceof ASTToken) continue;
            ASTNode n = (ASTNode)o;
            String key = n.getTokenTypeIdentifier("identifier");
            String value = n.getTokenTypeIdentifier("propertyValue.string");
            if (value != null) {
                value = value.substring(1, value.length() - 1);
                expressions.put(key, NBSLanguageReader.c(value));
                continue;
            }
            if (n.getNode("propertyValue.class") != null) {
                value = NBSLanguageReader.readClass(n.getNode("propertyValue.class"));
                methods.put(key, value);
                continue;
            }
            value = n.getNode("propertyValue.regularExpression").getAsText().trim();
            Pattern pattern = NBSLanguageReader.readPattern(source, sourceName, value, n.getOffset());
            patterns.put(key, pattern);
        }
        return Feature.create(keyword, selector, expressions, methods, patterns);
    }

    private static String readClass(ASTNode cls) {
        StringBuilder sb = new StringBuilder();
        sb.append(cls.getTokenTypeIdentifier("identifier"));
        for (ASTToken aSTToken : cls.getNode("class1").getChildren()) {
            if (aSTToken.getIdentifier().equals(".")) {
                sb.append('.');
                continue;
            }
            if (!aSTToken.getType().equals("identifier")) continue;
            sb.append(aSTToken.getIdentifier());
        }
        return sb.toString();
    }

    private static Pattern readPattern(String source, String sourceName, String pattern, int offset) throws ParseException {
        StringInput input = new StringInput(pattern);
        try {
            return Pattern.create(input);
        }
        catch (ParseException e) {
            Point p = Utils.findPosition(source, offset + input.getIndex());
            throw new ParseException(sourceName + " " + p.x + "," + p.y + ": " + e.getMessage());
        }
    }

    private static String c(String s) {
        s = s.replace("\\n", "\n");
        s = s.replace("\\r", "\r");
        s = s.replace("\\t", "\t");
        s = s.replace("\\\"", "\"");
        s = s.replace("\\'", "'");
        s = s.replace("\\\\", "\\");
        return s;
    }
}

