/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.util.MissingResourceException;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.languages.dataobject.LanguagesEditorKit;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LanguagesOptions
extends BaseOptions {
    public static String LANGUAGES = "Languages";
    public static final String CODE_FOLDING_ENABLE_PROP = "codeFoldingEnable";
    private static LanguagesOptions defaultInstance;
    static final String[] LANGUAGES_PROP_NAMES;
    private static final String HELP_ID = "editing.editor.php";
    private String mimeType;

    public static final LanguagesOptions create(FileObject fo) {
        if (defaultInstance == null) {
            String mimeType = fo.getParent().getPath().substring(8);
            defaultInstance = new LanguagesOptions(mimeType);
        }
        return defaultInstance;
    }

    public LanguagesOptions(String mimeType) {
        super(LanguagesEditorKit.class, LANGUAGES);
        this.mimeType = mimeType;
    }

    protected String getContentType() {
        return this.mimeType;
    }

    public boolean getCodeFoldingEnable() {
        return this.getSettingBoolean("code-folding-enable");
    }

    public void setCodeFoldingEnable(boolean state) {
        this.setSettingBoolean("code-folding-enable", state, CODE_FOLDING_ENABLE_PROP);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    protected String getString(String key) {
        try {
            return NbBundle.getMessage(LanguagesOptions.class, (String)key);
        }
        catch (MissingResourceException e) {
            return super.getString(key);
        }
    }

    static {
        LANGUAGES_PROP_NAMES = OptionSupport.mergeStringArrays((String[])BaseOptions.BASE_PROP_NAMES, (String[])new String[]{CODE_FOLDING_ENABLE_PROP});
    }
}

