/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

public class IndentAction
extends BaseKit.InsertBreakAction {
    private static Map indentProperties = new WeakHashMap();

    protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object cookie) {
        block15: {
            try {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = th.tokenSequence();
                ts.move(caret.getDot());
                if (ts.moveNext()) {
                    while (ts.embedded() != null) {
                        ts = ts.embedded();
                        ts.move(caret.getDot());
                        if (ts.moveNext()) continue;
                    }
                }
                Language l = LanguagesManager.getDefault().getLanguage(ts.language().mimeType());
                Token token = ts.token();
                Object indentValue = IndentAction.getIndentProperties(l);
                if (indentValue == null) {
                    return;
                }
                if (indentValue instanceof Object[]) {
                    Object[] params = (Object[])indentValue;
                    int length = doc.getLength();
                    int ln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)(caret.getDot() - 1));
                    int endLine = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)(length - 1));
                    int start = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)ln);
                    int end = ln < endLine ? NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)(ln + 1)) : length;
                    String line = doc.getText(start, end - start);
                    int indent = IndentAction.getIndent(line);
                    ts.move(start);
                    ts.moveNext();
                    int ni = IndentAction.getIndent(line, ts, end, params);
                    if (ni > 0) {
                        indent += 4;
                    } else if (ni == 0 && ln > 0) {
                        int start1 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)(ln - 1));
                        line = doc.getText(start1, start - start1);
                        ts.move(start1);
                        ts.moveNext();
                        ni = IndentAction.getIndent(line, ts, start, params);
                        if (ni == 2) {
                            indent -= 4;
                        }
                    }
                    try {
                        start = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)(ln + 1));
                        end = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)(ln + 2));
                        line = doc.getText(start, end - start);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        line = null;
                    }
                    IndentAction.indent((Document)doc, caret.getDot(), indent);
                    if (line != null && ((Set)params[2]).contains(line.trim())) {
                        int offset = caret.getDot();
                        doc.insertString(offset, "\n", null);
                        IndentAction.indent((Document)doc, caret.getDot(), indent -= 4);
                        caret.setDot(offset);
                    }
                    break block15;
                }
                if (indentValue instanceof Feature) {
                    Feature m = (Feature)indentValue;
                    m.getValue(Context.create((Document)doc, ts));
                }
            }
            catch (LanguageDefinitionNotFoundException ldnfe) {
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private static int getIndent(String line) {
        int indent = 0;
        int k = line.length() - 1;
        for (int i = 0; i < k && Character.isWhitespace(line.charAt(i)); ++i) {
            if (line.charAt(i) == '\t') {
                indent += 8 - indent % 8;
                continue;
            }
            ++indent;
        }
        return indent;
    }

    private static int getIndent(String line, TokenSequence ts, int end, Object[] params) {
        HashMap<String, Integer> p = new HashMap<String, Integer>();
        do {
            Integer i;
            Token t;
            String id;
            if (((Set)params[1]).contains(id = ((Object)(t = ts.token()).text()).toString())) {
                i = (Integer)p.get(id);
                i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
                p.put(id, i);
            }
            if (!((Set)params[2]).contains(((Object)t.text()).toString())) continue;
            i = (Integer)p.get(id = (String)((Map)params[3]).get(id));
            i = i == null ? Integer.valueOf(-1) : Integer.valueOf(i - 1);
            p.put(id, i);
        } while (ts.moveNext() && ts.offset() < end);
        Iterator<Object> it = p.values().iterator();
        while (it.hasNext()) {
            int i = (Integer)it.next();
            if (i > 0) {
                return 1;
            }
            if (i >= 0) continue;
            return -1;
        }
        for (Pattern pattern : (List)params[0]) {
            if (!pattern.matcher(line).matches()) continue;
            return 2;
        }
        return 0;
    }

    private static void indent(Document doc, int offset, int i) {
        StringBuilder sb = new StringBuilder();
        while (i > 0) {
            sb.append(' ');
            --i;
        }
        try {
            doc.insertString(offset, sb.toString(), null);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static Object getIndentProperties(Language l) {
        if (!indentProperties.containsKey(l)) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            HashSet<String> start = new HashSet<String>();
            HashSet<String> end = new HashSet<String>();
            HashMap<String, String> endToStart = new HashMap<String, String>();
            List<Feature> indents = l.getFeatures("INDENT");
            for (Feature indent : indents) {
                if (indent.getType() == Feature.Type.METHOD_CALL) {
                    return indent;
                }
                String s = (String)indent.getValue();
                int i = s.indexOf(58);
                if (i < 1) {
                    patterns.add(Pattern.compile(IndentAction.c(s)));
                    continue;
                }
                start.add(s.substring(0, i));
                end.add(s.substring(i + 1));
                endToStart.put(s.substring(i + 1), s.substring(0, i));
            }
            indentProperties.put(l, new Object[]{patterns, start, end, endToStart});
        }
        return indentProperties.get(l);
    }

    private static String c(String s) {
        s = s.replace("\\n", "\n");
        s = s.replace("\\r", "\r");
        s = s.replace("\\t", "\t");
        s = s.replace("\\\"", "\"");
        s = s.replace("\\'", "'");
        s = s.replace("\\\\", "\\");
        return s;
    }
}

