/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.EditorParser;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.Folds;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguagesFoldManager
extends ASTEvaluator
implements FoldManager {
    private static final int EVALUATING = 0;
    private static final int STOPPED = 1;
    private FoldOperation operation;
    private Document doc;
    private EditorParser editorParser;
    private int evalState = 1;
    private static FoldType defaultFoldType = new FoldType("default");
    private List<FoldItem> folds;

    public void init(FoldOperation operation) {
        Document d = operation.getHierarchy().getComponent().getDocument();
        if (d instanceof NbEditorDocument) {
            this.doc = d;
            this.operation = operation;
            this.editorParser = EditorParser.get(this.doc);
            this.editorParser.addASTEvaluator(this);
        }
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void release() {
        if (this.doc != null) {
            this.editorParser.removeASTEvaluator(this);
        }
        this.editorParser = null;
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode root) {
        this.evalState = 0;
        this.folds = new CopyOnWriteArrayList<FoldItem>();
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode root) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (LanguagesFoldManager.this.operation == null) {
                    LanguagesFoldManager.this.evalState = 1;
                    return;
                }
                FoldHierarchy hierarchy = LanguagesFoldManager.this.operation.getHierarchy();
                FoldHierarchyTransaction transaction = LanguagesFoldManager.this.operation.openTransaction();
                try {
                    int i;
                    Fold fold = LanguagesFoldManager.this.operation.getHierarchy().getRootFold();
                    ArrayList<Fold> l = new ArrayList<Fold>(fold.getFoldCount());
                    int k = fold.getFoldCount();
                    for (i = 0; i < k; ++i) {
                        l.add(fold.getFold(i));
                    }
                    for (i = 0; i < k; ++i) {
                        LanguagesFoldManager.this.operation.removeFromHierarchy((Fold)l.get(i), transaction);
                    }
                    for (FoldItem f : LanguagesFoldManager.this.folds) {
                        LanguagesFoldManager.this.operation.addToHierarchy(f.type, f.foldName, false, f.start, f.end, 0, 0, (Object)hierarchy, transaction);
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
                finally {
                    transaction.commit();
                    LanguagesFoldManager.this.evalState = 1;
                }
            }
        });
    }

    @Override
    public void evaluate(ParserManager.State state, ASTPath path) {
        try {
            String foldName;
            boolean isTokenFold;
            ASTItem item = path.getLeaf();
            int s = item.getOffset();
            int e = item.getEndOffset();
            int sln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)s);
            int eln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)e);
            if (sln == eln) {
                return;
            }
            String mimeType = item.getMimeType();
            Language language = LanguagesManager.getDefault().getLanguage(mimeType);
            List<Feature> fls = language.getFeatures("FOLD", path);
            if (fls == null || fls.isEmpty()) {
                return;
            }
            Feature fold = fls.get(0);
            boolean bl = isTokenFold = fls.size() == 1 && item instanceof ASTToken && fold == language.getFeature("FOLD", ((ASTToken)item).getType());
            if (!isTokenFold) {
                TokenHierarchy th = TokenHierarchy.get((Document)this.doc);
                TokenSequence ts = th.tokenSequence();
                ts.move(e - 1);
                if (!ts.moveNext()) {
                    return;
                }
                while (!ts.language().mimeType().equals(mimeType)) {
                    if ((ts = ts.embedded()) == null) {
                        return;
                    }
                    ts.move(e - 1);
                    if (ts.moveNext()) continue;
                    return;
                }
                Token t = ts.token();
                Set<String> skip = language.getSkipTokenTypes();
                while (skip.contains(t.id().name()) && ts.movePrevious()) {
                    t = ts.token();
                }
                ts.moveNext();
                e = ts.offset();
                sln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)s);
                eln = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)e);
                if (eln - sln < 1) {
                    return;
                }
            }
            if (fold.hasSingleValue()) {
                foldName = language.localize((String)fold.getValue(SyntaxContext.create(this.doc, path)));
                if (foldName == null) {
                    return;
                }
                this.folds.add(new FoldItem(foldName, s, e, defaultFoldType));
                return;
            }
            foldName = language.localize((String)fold.getValue("fold_display_name", SyntaxContext.create(this.doc, path)));
            if (foldName == null) {
                foldName = "...";
            }
            String foldType = language.localize((String)fold.getValue("collapse_type_action_name"));
            this.folds.add(new FoldItem(foldName, s, e, Folds.getFoldType(foldType)));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    void init(Document doc) {
        this.doc = doc;
        this.operation = null;
        this.editorParser = EditorParser.get(doc);
        this.editorParser.addASTEvaluator(this);
    }

    List<FoldItem> getFolds() {
        return this.folds;
    }

    boolean isEvaluating() {
        return this.evalState == 0;
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new LanguagesFoldManager();
        }
    }

    static final class FoldItem {
        String foldName;
        int start;
        int end;
        FoldType type;

        FoldItem(String foldName, int start, int end, FoldType type) {
            this.foldName = foldName;
            this.start = start;
            this.end = end;
            this.type = type;
        }
    }
}

