/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeModelListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguagesNavigator
implements NavigatorPanel {
    private JComponent panelUI;
    private JTree tree;
    private NbEditorDocument lastDocument;
    private JEditorPane lastEditor;
    private DocumentListener parserListener;
    private DataObject dataObject;
    private MyLookupListener lookupListener;
    private static Map icons = new HashMap();
    private Document highlightedDocument = null;
    private Object highlighted = null;
    private JEditorPane highlightedEditor = null;
    private static AttributeSet highlightAS = null;

    public String getDisplayHint() {
        return "This is Navigator";
    }

    public String getDisplayName() {
        return "Navigator";
    }

    public JComponent getComponent() {
        if (this.panelUI == null) {
            this.tree = new JTree(){

                public String getToolTipText(MouseEvent ev) {
                    TreePath selPath = LanguagesNavigator.this.tree.getPathForLocation(ev.getX(), ev.getY());
                    if (selPath == null) {
                        return null;
                    }
                    Object selObj = selPath.getLastPathComponent();
                    if (selObj == null || !(selObj instanceof NavigatorNode)) {
                        return null;
                    }
                    NavigatorNode node = (NavigatorNode)selObj;
                    return node.tooltip;
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.addMouseListener(new Listener());
            this.tree.setToggleClickCount(Integer.MAX_VALUE);
            this.panelUI = new JScrollPane(this.tree);
        }
        return this.panelUI;
    }

    public void panelActivated(Lookup context) {
        Lookup.Result result = context.lookupResult(DataObject.class);
        if (this.lookupListener != null) {
            this.lookupListener.remove();
        }
        this.lookupListener = new MyLookupListener((Lookup.Result<DataObject>)result);
        this.dataObject = (DataObject)result.allInstances().iterator().next();
        this.refresh();
    }

    public void panelDeactivated() {
        if (this.lastEditor != null) {
            this.lastEditor.removeCaretListener(this.parserListener);
        }
        this.lastEditor = null;
        if (this.lastDocument != null) {
            ParserManager lastPM = ParserManagerImpl.get((Document)this.lastDocument);
            lastPM.removeListener(this.parserListener);
            this.lastDocument = null;
        }
        this.dataObject = null;
        if (this.lookupListener != null) {
            this.lookupListener.remove();
        }
    }

    public Lookup getLookup() {
        return null;
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorCookie ec = null;
                LineCookie lc = null;
                try {
                    ec = (EditorCookie)LanguagesNavigator.this.dataObject.getCookie(EditorCookie.class);
                    if (ec == null) {
                        return;
                    }
                    lc = (LineCookie)LanguagesNavigator.this.dataObject.getCookie(LineCookie.class);
                }
                catch (NullPointerException e) {
                    return;
                }
                try {
                    NbEditorDocument document = (NbEditorDocument)ec.openDocument();
                    ASTNode ast = null;
                    ParserManager parserManager = ParserManagerImpl.get((Document)document);
                    if (parserManager != null) {
                        try {
                            ast = parserManager.getAST();
                        }
                        catch (ParseException ex) {
                            ast = ex.getASTNode();
                        }
                    }
                    if (LanguagesNavigator.this.parserListener == null) {
                        LanguagesNavigator.this.parserListener = new DocumentListener();
                    }
                    if (LanguagesNavigator.this.lastEditor != null) {
                        LanguagesNavigator.this.lastEditor.removeCaretListener(LanguagesNavigator.this.parserListener);
                    }
                    if (ec.getOpenedPanes() != null && ec.getOpenedPanes().length > 0) {
                        LanguagesNavigator.this.lastEditor = ec.getOpenedPanes()[0];
                        LanguagesNavigator.this.lastEditor.addCaretListener(LanguagesNavigator.this.parserListener);
                    } else {
                        LanguagesNavigator.this.lastEditor = null;
                    }
                    if (LanguagesNavigator.this.lastDocument != document) {
                        ParserManager lastPM;
                        if (LanguagesNavigator.this.lastDocument != null && (lastPM = ParserManagerImpl.get((Document)LanguagesNavigator.this.lastDocument)) != null) {
                            lastPM.removeListener(LanguagesNavigator.this.parserListener);
                        }
                        if (parserManager != null) {
                            parserManager.addListener(LanguagesNavigator.this.parserListener);
                        }
                        LanguagesNavigator.this.lastDocument = document;
                    }
                    ArrayList data = new ArrayList();
                    LanguagesNavigator.this.getComponent();
                    if (ast != null) {
                        Model model = new Model();
                        model.setContext(ast, lc.getLineSet(), document);
                        LanguagesNavigator.this.tree.setModel(model);
                    } else if (parserManager == null) {
                        LanguagesNavigator.this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
                    } else {
                        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
                        ParserManager.State state = parserManager.getState();
                        if (state == ParserManager.State.PARSING) {
                            root.add(new DefaultMutableTreeNode("Parsing ..."));
                        } else if (state != ParserManager.State.NOT_PARSED) {
                            root.add(new DefaultMutableTreeNode("?!?!"));
                        }
                        LanguagesNavigator.this.tree.setModel(new DefaultTreeModel(root));
                    }
                    LanguagesNavigator.this.tree.setCellRenderer(new Renderer());
                    while (LanguagesNavigator.this.tree.getRowCount() < 50) {
                        int c = LanguagesNavigator.this.tree.getRowCount();
                        int k = LanguagesNavigator.this.tree.getRowCount();
                        for (int i = 0; i < k; ++i) {
                            LanguagesNavigator.this.tree.expandRow(i);
                        }
                        if (LanguagesNavigator.this.tree.getRowCount() != c) continue;
                        break;
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        });
    }

    private static NavigatorNode createNavigatorNode(ASTItem item, List<ASTItem> path, Line.Set lineSet, NbEditorDocument doc) {
        ASTPath path2 = ASTPath.create(path);
        Feature navigator = null;
        try {
            Language language = LanguagesManager.getDefault().getLanguage(item.getMimeType());
            navigator = language.getFeature("NAVIGATOR", path2);
        }
        catch (ParseException ex) {
            return null;
        }
        if (navigator == null) {
            return null;
        }
        Line line = lineSet != null ? lineSet.getCurrent(NbDocument.findLineNumber((StyledDocument)doc, (int)item.getOffset())) : null;
        int column = NbDocument.findLineColumn((StyledDocument)doc, (int)item.getOffset());
        int start = item.getOffset();
        int end = item.getEndOffset();
        SyntaxContext context = SyntaxContext.create((Document)doc, path2);
        String displayName = (String)navigator.getValue("display_name", context);
        if (displayName == null || displayName.trim().length() == 0) {
            return null;
        }
        String tooltip = (String)navigator.getValue("tooltip", context);
        String icon = (String)navigator.getValue("icon", context);
        if (icon == null) {
            icon = "org/netbeans/modules/languages/resources/node.gif";
        }
        boolean isLeaf = navigator.getBoolean("tooltip", context, false);
        return new NavigatorNode(item, path, line, column, displayName, tooltip, icon, isLeaf);
    }

    private static Icon getCIcon(String resourceName) {
        if (!icons.containsKey(resourceName)) {
            Image image = Utilities.loadImage((String)resourceName);
            if (image == null) {
                image = Utilities.loadImage((String)"org/netbeans/modules/languages/resources/node.gif");
            }
            icons.put(resourceName, new ImageIcon(image));
        }
        return (Icon)icons.get(resourceName);
    }

    private void markSelected(int position) {
        if (!(this.tree.getModel() instanceof Model)) {
            return;
        }
        Model model = (Model)this.tree.getModel();
        ASTPath astPath = model.root.findPath(position);
        if (astPath == null) {
            return;
        }
        ArrayList<NavigatorNode> nodePath = new ArrayList<NavigatorNode>();
        NavigatorNode node = (NavigatorNode)model.astToNode.get(model.root);
        ListIterator<ASTItem> it = astPath.listIterator();
        while (it.hasNext()) {
            Object o = it.next();
            NavigatorNode nn = (NavigatorNode)model.astToNode.get(o);
            if (nn == null) continue;
            nodePath.add(nn);
            node = nn;
        }
        if (nodePath.isEmpty()) {
            return;
        }
        TreePath treePath = new TreePath(nodePath.toArray());
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    private void selectionChanged() {
        this.removeHighlight();
        if (!this.tree.hasFocus()) {
            return;
        }
        TreePath selPath = this.tree.getSelectionPath();
        if (selPath == null) {
            return;
        }
        Object selObj = selPath.getLastPathComponent();
        if (selObj == null || !(selObj instanceof NavigatorNode)) {
            return;
        }
        NavigatorNode node = (NavigatorNode)selObj;
        if (node.line == null) {
            return;
        }
        node.line.show(1, node.column);
        this.highlighted = node.item;
        this.highlightedDocument = this.lastDocument;
        Highlighting.getHighlighting(this.highlightedDocument).highlight(node.item, LanguagesNavigator.getHighlightAS());
        DataObject dataObject = (DataObject)node.line.getLookup().lookup(DataObject.class);
        EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        this.highlightedEditor = ec.getOpenedPanes()[0];
        this.highlightedEditor.repaint();
    }

    private void removeHighlight() {
        if (this.highlighted == null) {
            return;
        }
        if (this.highlighted instanceof ASTToken) {
            Highlighting.getHighlighting(this.highlightedDocument).removeHighlight((ASTToken)this.highlighted);
        } else {
            Highlighting.getHighlighting(this.highlightedDocument).removeHighlight((ASTNode)this.highlighted);
        }
        this.highlightedEditor.repaint();
        this.highlighted = null;
        this.highlightedDocument = null;
        this.highlightedEditor = null;
    }

    private static AttributeSet getHighlightAS() {
        if (highlightAS == null) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            as.addAttribute(StyleConstants.Background, Color.yellow);
            highlightAS = as;
        }
        return highlightAS;
    }

    class DocumentListener
    implements CaretListener,
    ParserManagerListener {
        DocumentListener() {
        }

        public void parsed(ParserManager.State state, ASTNode ast) {
            if (state == ParserManager.State.PARSING) {
                return;
            }
            LanguagesNavigator.this.refresh();
        }

        public void caretUpdate(CaretEvent e) {
            LanguagesNavigator.this.markSelected(e.getDot());
        }
    }

    class Listener
    implements MouseListener {
        Listener() {
        }

        public void mouseClicked(MouseEvent ev) {
            if (ev.getClickCount() != 2) {
                return;
            }
            TreePath selPath = LanguagesNavigator.this.tree.getPathForLocation(ev.getX(), ev.getY());
            if (selPath == null) {
                return;
            }
            Object selObj = selPath.getLastPathComponent();
            if (selObj == null || !(selObj instanceof NavigatorNode)) {
                return;
            }
            NavigatorNode node = (NavigatorNode)selObj;
            node.line.show(2, node.column);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Model
    implements TreeModel {
        private NbEditorDocument doc;
        private ASTNode root;
        private Language language;
        private Line.Set lineSet;
        private WeakHashMap nodeToNodes = new WeakHashMap();
        private WeakHashMap astToNode = new WeakHashMap();
        private NavigatorComparator navigatorComparator;

        Model() {
        }

        @Override
        public Object getRoot() {
            if (this.astToNode.get(this.root) == null) {
                ArrayList<ASTItem> path = new ArrayList<ASTItem>();
                path.add(this.root);
                NavigatorNode navigatorNode = new NavigatorNode(this.root, path, null, 0, "root", null, "org/netbeans/modules/languages/resources/node.gif", false);
                this.astToNode.put(this.root, navigatorNode);
            }
            return (NavigatorNode)this.astToNode.get(this.root);
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.getNavigatorNodes((NavigatorNode)parent).get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.getNavigatorNodes((NavigatorNode)parent).size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getNavigatorNodes((NavigatorNode)node).isEmpty();
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return this.getNavigatorNodes((NavigatorNode)parent).indexOf(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        void setContext(ASTNode root, Line.Set lineSet, NbEditorDocument doc) {
            this.root = root;
            this.lineSet = lineSet;
            this.doc = doc;
        }

        private List getNavigatorNodes(NavigatorNode n) {
            List nodes = (List)this.nodeToNodes.get(n);
            if (nodes == null) {
                if (n.isLeaf) {
                    nodes = Collections.emptyList();
                } else {
                    nodes = this.getNavigatorNodes(n.item, n.path, new ArrayList());
                    try {
                        Language language = LanguagesManager.getDefault().getLanguage(n.item.getMimeType());
                        Feature properties = language.getFeature("PROPERTIES");
                        if (properties != null && properties.getBoolean("navigator-sort", false)) {
                            if (this.navigatorComparator == null) {
                                this.navigatorComparator = new NavigatorComparator();
                            }
                            Collections.sort(nodes, this.navigatorComparator);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                this.nodeToNodes.put(n, nodes);
            }
            return nodes;
        }

        private NavigatorNode getNavigatorNode(ASTItem item, List<ASTItem> path) {
            if (this.astToNode.get(item) == null) {
                NavigatorNode navigatorNode = LanguagesNavigator.createNavigatorNode(item, path, this.lineSet, this.doc);
                this.astToNode.put(item, navigatorNode);
            }
            return (NavigatorNode)this.astToNode.get(item);
        }

        private List getNavigatorNodes(ASTItem item, List<ASTItem> path, List nodes) {
            for (ASTItem item2 : item.getChildren()) {
                path.add(item2);
                NavigatorNode navigatorNode = this.getNavigatorNode(item2, path);
                if (navigatorNode != null) {
                    nodes.add(navigatorNode);
                } else {
                    this.getNavigatorNodes(item2, path, nodes);
                }
                path.remove(path.size() - 1);
            }
            return nodes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyLookupListener
    implements LookupListener {
        private Lookup.Result<DataObject> result;

        MyLookupListener(Lookup.Result<DataObject> result) {
            this.result = result;
            result.addLookupListener((LookupListener)this);
        }

        void remove() {
            this.result.removeLookupListener((LookupListener)this);
        }

        public void resultChanged(LookupEvent ev) {
            Iterator it = this.result.allInstances().iterator();
            if (!it.hasNext()) {
                return;
            }
            LanguagesNavigator.this.dataObject = (DataObject)it.next();
            LanguagesNavigator.this.refresh();
        }
    }

    static class NavigatorComparator
    implements Comparator {
        NavigatorComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((NavigatorNode)o1).displayName.compareToIgnoreCase(((NavigatorNode)o2).displayName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NavigatorNode {
        Line line;
        int column;
        String displayName;
        String tooltip;
        String icon;
        ASTItem item;
        List<ASTItem> path;
        boolean isLeaf;

        NavigatorNode(ASTItem item, List<ASTItem> path, Line line, int column, String displayName, String tooltip, String icon, boolean isLeaf) {
            this.item = item;
            this.path = path;
            this.line = line;
            this.column = column;
            this.displayName = displayName;
            this.tooltip = tooltip;
            this.icon = icon;
            this.isLeaf = isLeaf;
        }
    }

    static class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel l = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                l.setIcon(null);
                l.setText((String)((DefaultMutableTreeNode)value).getUserObject());
                return l;
            }
            NavigatorNode node = (NavigatorNode)value;
            l.setIcon(LanguagesNavigator.getCIcon(node.icon));
            l.setText(node.displayName);
            return l;
        }
    }
}

