/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.ColorsManager;

public class MyFirstDrawLayer
implements DrawLayer {
    private String mimeType;
    private Highlighting highlighting;
    private int nextActivityChangeOffset = Integer.MAX_VALUE;

    public MyFirstDrawLayer(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean extendsEOL() {
        return false;
    }

    public boolean extendsEmptyLine() {
        return false;
    }

    public int getNextActivityChangeOffset(DrawContext ctx) {
        return this.nextActivityChangeOffset;
    }

    public void init(DrawContext ctx) {
        this.highlighting = Highlighting.getHighlighting((Document)ctx.getEditorUI().getDocument());
    }

    public int updateLineNumberContext(int lineNumber, DrawContext ctx) {
        return lineNumber;
    }

    public String toString() {
        return "Layer " + this.getClass();
    }

    public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
        this.setNextActivityChangeOffset(ctx.getTokenOffset() + ctx.getTokenLength());
        return true;
    }

    public void updateContext(DrawContext ctx) {
        NbEditorDocument doc = (NbEditorDocument)ctx.getEditorUI().getDocument();
        ASTNode ast = null;
        try {
            ast = ParserManagerImpl.get((Document)doc).getAST();
        }
        catch (ParseException ex) {
            ast = ex.getASTNode();
        }
        if (ast == null) {
            this.markToken(ctx, (Document)doc);
            return;
        }
        ASTPath path = ast.findPath(ctx.getFragmentOffset());
        if (path == null) {
            this.markToken(ctx, (Document)doc);
            return;
        }
        boolean isTrailing = MyFirstDrawLayer.isTrailing(path, ctx.getFragmentOffset());
        ASTNode splitNode = isTrailing ? MyFirstDrawLayer.splitNode(path) : null;
        int k = path.size();
        for (int i = 0; i < k; ++i) {
            ASTItem item = path.get(i);
            if (isTrailing && splitNode == item) break;
            try {
                Language language = LanguagesManager.getDefault().getLanguage(item.getMimeType());
                AttributeSet as2 = null;
                List<AttributeSet> colors = ColorsManager.getColors(language, path.subPath(i), (Document)doc);
                if (colors != null) {
                    for (AttributeSet as2 : colors) {
                        MyFirstDrawLayer.apply(as2, ctx);
                    }
                }
                if ((as2 = this.highlighting.get(item)) == null) continue;
                MyFirstDrawLayer.apply(as2, ctx);
                continue;
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
    }

    private static boolean isTrailing(ASTPath path, int offset) {
        try {
            if (path.size() < 2 || !(path.get(path.size() - 2) instanceof ASTNode)) {
                return false;
            }
            ASTNode lastNode = (ASTNode)path.get(path.size() - 2);
            Language language = LanguagesManager.getDefault().getLanguage(lastNode.getMimeType());
            Set<String> skipTokens = language.getSkipTokenTypes();
            if (!(path.getLeaf() instanceof ASTToken)) {
                return false;
            }
            ASTToken leaf = (ASTToken)path.getLeaf();
            ASTNode split = null;
            if (!skipTokens.contains(leaf.getType())) {
                return false;
            }
            split = (ASTNode)path.getRoot();
            int size = path.size();
            List<ASTItem> list = lastNode.getChildren();
            ListIterator<ASTItem> iter = list.listIterator(list.size());
            while (iter.hasPrevious()) {
                ASTItem item = iter.previous();
                if (item == leaf) {
                    return true;
                }
                if (item instanceof ASTToken && skipTokens.contains(((ASTToken)item).getType())) continue;
                break;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    private static ASTNode splitNode(ASTPath path) {
        ListIterator<ASTItem> iter = path.listIterator();
        Object o = iter.next();
        while (o instanceof ASTNode) {
            List<ASTItem> children = ((ASTNode)o).getChildren();
            o = iter.next();
            if (!(o instanceof ASTNode)) break;
            if (children.get(children.size() - 1) == o) continue;
            return (ASTNode)o;
        }
        return null;
    }

    private void markToken(DrawContext ctx, Document doc) {
        TokenHierarchy hierarchy = TokenHierarchy.get((Document)doc);
        if (hierarchy == null) {
            return;
        }
        TokenSequence ts = hierarchy.tokenSequence();
        AttributeSet as = null;
        do {
            ts.move(ctx.getFragmentOffset());
            ts.moveNext();
            Token t = ts.token();
            if (t == null) {
                return;
            }
            ASTToken stoken = ASTToken.create(ts.language().mimeType(), t.id().name(), ((Object)t.text()).toString(), ts.offset());
            as = this.highlighting.get(stoken);
            ts = ts.embedded();
        } while (as == null && ts != null);
        if (as != null) {
            MyFirstDrawLayer.apply(as, ctx);
        }
    }

    private void setNextActivityChangeOffset(int nextActivityChangeOffset) {
        this.nextActivityChangeOffset = nextActivityChangeOffset;
    }

    private static void apply(AttributeSet as, DrawContext ctx) {
        Color c = (Color)as.getAttribute(StyleConstants.Background);
        if (c != null) {
            ctx.setBackColor(c);
        }
        if ((c = (Color)as.getAttribute(StyleConstants.Foreground)) != null) {
            ctx.setForeColor(c);
        }
        if ((c = (Color)as.getAttribute(StyleConstants.StrikeThrough)) != null) {
            ctx.setStrikeThroughColor(c);
        }
        if ((c = (Color)as.getAttribute(StyleConstants.Underline)) != null) {
            ctx.setUnderlineColor(c);
        }
        if ((c = (Color)as.getAttribute(EditorStyleConstants.WaveUnderlineColor)) != null) {
            ctx.setWaveUnderlineColor(c);
        }
        String fontName = (String)as.getAttribute(StyleConstants.FontFamily);
        Boolean bold = (Boolean)as.getAttribute(StyleConstants.Bold);
        Boolean italic = (Boolean)as.getAttribute(StyleConstants.Italic);
        if (fontName != null || bold != null || italic != null) {
            Font f = ctx.getFont();
            if (fontName == null) {
                fontName = f.getFamily();
            }
            if (bold == null) {
                Boolean bl = bold = f.isBold() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (italic == null) {
                italic = f.isItalic() ? Boolean.TRUE : Boolean.FALSE;
            }
            f = new Font(fontName, (bold != false ? 1 : 0) + (italic != false ? 2 : 0), f.getSize());
            ctx.setFont(f);
        }
    }
}

