/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.ColorsManager;

public class MySecondDrawLayer
implements DrawLayer {
    private String mimeType;
    private TokenSequence tokenSequence;
    private int nextActivityChangeOffset = Integer.MAX_VALUE;
    private Map<String, Map<String, Color>> tokenImportColors = new HashMap<String, Map<String, Color>>();
    private Map<String, Color> preprocessorImportColors;

    public MySecondDrawLayer(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean extendsEOL() {
        return true;
    }

    public boolean extendsEmptyLine() {
        return false;
    }

    public int getNextActivityChangeOffset(DrawContext ctx) {
        return this.nextActivityChangeOffset;
    }

    public void init(DrawContext ctx) {
        TokenHierarchy th = TokenHierarchy.get((Document)ctx.getEditorUI().getDocument());
        if (th == null) {
            return;
        }
        this.tokenSequence = th.tokenSequence();
    }

    public int updateLineNumberContext(int lineNumber, DrawContext ctx) {
        return lineNumber;
    }

    public String toString() {
        return "Layer " + this.getClass();
    }

    public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
        this.setNextActivityChangeOffset(ctx.getTokenOffset() + ctx.getTokenLength());
        return true;
    }

    public void updateContext(DrawContext ctx) {
        NbEditorDocument doc = (NbEditorDocument)ctx.getEditorUI().getDocument();
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        if (tokenHierarchy == null) {
            return;
        }
        TokenSequence ts = tokenHierarchy.tokenSequence();
        this.mark(ts, ctx.getFragmentOffset(), ctx);
    }

    private void setNextActivityChangeOffset(int nextActivityChangeOffset) {
        this.nextActivityChangeOffset = nextActivityChangeOffset;
    }

    private void mark(TokenSequence ts, int offset, DrawContext ctx) {
        Color c;
        ts.move(offset);
        if (!ts.moveNext()) {
            return;
        }
        Token token = ts.token();
        TokenSequence ts2 = ts.embedded();
        if (ts2 == null) {
            return;
        }
        String mimeTypeOut = ts.language().mimeType();
        String mimeTypeIn = ts2.language().mimeType();
        if (token.id().name().equals("PE")) {
            Color c2 = this.getPreprocessorImportsColor(mimeTypeIn);
            if (c2 != null) {
                ctx.setBackColor(c2);
            }
        } else if (!mimeTypeOut.equals(mimeTypeIn) && (c = this.getTokenImportsColor(mimeTypeOut, mimeTypeIn, token.id().name())) != null) {
            ctx.setBackColor(c);
        }
        this.mark(ts2, offset, ctx);
    }

    private Color getPreprocessorImportsColor(String mimeTypeIn) {
        if (this.preprocessorImportColors == null) {
            this.preprocessorImportColors = new HashMap<String, Color>();
            try {
                Language l = LanguagesManager.getDefault().getLanguage(this.mimeType);
                Feature properties = l.getPreprocessorImport();
                if (properties != null) {
                    String mimeType = (String)properties.getValue("mimeType");
                    Color color = ColorsManager.readColor((String)properties.getValue("background_color"));
                    if (color != null) {
                        this.preprocessorImportColors.put(mimeType, color);
                    }
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this.preprocessorImportColors.get(mimeTypeIn);
    }

    private Color getTokenImportsColor(String mimeTypeOut, String mimeTypeIn, String tokenTypeIn) {
        Map<String, Color> m = this.tokenImportColors.get(mimeTypeOut);
        if (m == null) {
            m = new HashMap<String, Color>();
            this.tokenImportColors.put(mimeTypeOut, m);
            try {
                Language l = LanguagesManager.getDefault().getLanguage(mimeTypeOut);
                Map<String, Feature> m2 = l.getTokenImports();
                for (String tokenType : m2.keySet()) {
                    Feature properties = m2.get(tokenType);
                    Color color = ColorsManager.readColor((String)properties.getValue("background_color"));
                    if (color == null) continue;
                    m.put(tokenType, color);
                }
            }
            catch (LanguageDefinitionNotFoundException ex) {
                // empty catch block
            }
        }
        if (m.containsKey(tokenTypeIn)) {
            return m.get(tokenTypeIn);
        }
        return m.get(mimeTypeIn);
    }
}

