/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.lexer;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.lexer.DelegatingInputBridge;
import org.netbeans.modules.languages.lexer.InputBridge;
import org.netbeans.modules.languages.lexer.STokenId;
import org.netbeans.modules.languages.parser.Parser;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLexer
implements Lexer<STokenId>,
Parser.Cookie {
    private Language language;
    private CharInput input;
    private TokenFactory<STokenId> tokenFactory;
    private Map<String, STokenId> tokensMap;
    private Parser parser;
    private Object state;
    private Feature tokenProperties;

    SLexer(Language language, Map<String, STokenId> tokensMap, LexerRestartInfo<STokenId> info) {
        this.language = language;
        this.tokenFactory = info.tokenFactory();
        this.tokensMap = tokensMap;
        this.state = info.state();
        this.parser = language.getParser();
        String outerMimeType = info.languagePath().language(0).mimeType();
        try {
            Language outerLanguage = LanguagesManager.getDefault().getLanguage(outerMimeType);
            this.input = SLexer.createInputBridge(info.input(), outerLanguage);
        }
        catch (ParseException ex) {
            this.input = SLexer.createInputBridge(info.input(), new Language(outerMimeType));
        }
    }

    public Token<STokenId> nextToken() {
        Token<STokenId> t = this.nextTokenIn();
        return t;
    }

    private Token<STokenId> nextTokenIn() {
        if (this.state instanceof Marenka) {
            return this.createToken((Marenka)this.state);
        }
        int index = this.input.getIndex();
        Object sstate = this.state;
        if (this.input.eof()) {
            return this.createToken(index);
        }
        ASTToken token = null;
        token = this.parser.read(this, this.input, this.language.getMimeType());
        if (this.language != null && this.tokenProperties != null && this.tokenProperties.getType("call") != Feature.Type.NOT_SET) {
            this.input.setIndex(index);
            Object[] r = (Object[])this.tokenProperties.getValue("call", new Object[]{this.input});
            token = (ASTToken)r[0];
            if (r[1] != null) {
                this.setState(this.parser.getState((String)r[1]));
            }
        }
        if (token == null) {
            if (this.input.getIndex() > index + 1) {
                this.input.setIndex(index + 1);
            } else if (this.input.getIndex() == index) {
                this.input.read();
            }
            return this.createToken("error", index);
        }
        if (this.state != sstate && index == this.input.getIndex()) {
            return this.nextTokenIn();
        }
        return this.createToken(token.getType(), index);
    }

    public Object state() {
        return this.state;
    }

    public void release() {
    }

    @Override
    public int getState() {
        if (this.state == null) {
            return -1;
        }
        return (Integer)this.state;
    }

    @Override
    public void setState(int state) {
        this.state = new Integer(state);
    }

    @Override
    public void setProperties(Feature tokenProperties) {
        this.tokenProperties = tokenProperties;
    }

    private static CharInput createInputBridge(LexerInput input, Language language) {
        Feature properties = language.getPreprocessorImport();
        if (properties != null) {
            return new DelegatingInputBridge(new InputBridge(input), properties.getPattern("start"), properties.getPattern("end"), "PE");
        }
        return new InputBridge(input);
    }

    private Token<STokenId> createToken(String type, int start) {
        STokenId tokenId = this.tokensMap.get(type);
        assert (tokenId != null) : "Unknown token type \"" + type + "\"";
        if (!(this.input instanceof DelegatingInputBridge)) {
            return this.tokenFactory.createToken((TokenId)tokenId);
        }
        List<Vojta> embeddings = ((DelegatingInputBridge)this.input).getEmbeddings();
        if (embeddings.isEmpty()) {
            return this.tokenFactory.createToken((TokenId)tokenId);
        }
        Map<String, Feature> imports = this.language.getTokenImports();
        if (imports.containsKey(type)) {
            return this.tokenFactory.createToken((TokenId)tokenId);
        }
        Marenka marenka = new Marenka((Integer)this.state);
        String property = "S";
        for (Vojta v : embeddings) {
            if (start < v.startOffset) {
                marenka.add(new Vojta(type, start, v.startOffset, property));
                property = "C";
            }
            marenka.add(v);
            start = v.endOffset;
        }
        if (start < this.input.getIndex()) {
            marenka.add(new Vojta(type, start, this.input.getIndex(), property));
        }
        return this.createToken(marenka);
    }

    private Token<STokenId> createToken(int start) {
        if (!(this.input instanceof DelegatingInputBridge)) {
            return null;
        }
        List<Vojta> embeddings = ((DelegatingInputBridge)this.input).getEmbeddings();
        if (embeddings.isEmpty()) {
            return null;
        }
        Marenka marenka = new Marenka((Integer)this.state);
        String property = "S";
        for (Vojta v : embeddings) {
            assert (start == v.startOffset);
            marenka.add(v);
            start = v.endOffset;
        }
        assert (start == this.input.getIndex());
        return this.createToken(marenka);
    }

    private Token<STokenId> createToken(Marenka marenka) {
        Vojta v = marenka.removeFirst();
        STokenId tokenId = this.tokensMap.get(v.type);
        assert (tokenId != null) : "Unknown type " + v.type;
        this.input.setIndex(v.endOffset);
        this.state = marenka.isEmpty() ? marenka.getState() : marenka;
        if (v.property instanceof TokenProperties) {
            return this.tokenFactory.createPropertyToken((TokenId)tokenId, v.endOffset - v.startOffset, (TokenPropertyProvider)((TokenProperties)v.property), PartType.COMPLETE);
        }
        return this.tokenFactory.createPropertyToken((TokenId)tokenId, v.endOffset - v.startOffset, (TokenPropertyProvider)new TokenPropProvider(v.property), PartType.COMPLETE);
    }

    private static String e(CharSequence t) {
        StringBuilder sb = new StringBuilder();
        int k = t.length();
        for (int i = 0; i < k; ++i) {
            if (t.charAt(i) == '\t') {
                sb.append("\\t");
                continue;
            }
            if (t.charAt(i) == '\r') {
                sb.append("\\r");
                continue;
            }
            if (t.charAt(i) == '\n') {
                sb.append("\\n");
                continue;
            }
            sb.append(t.charAt(i));
        }
        return sb.toString();
    }

    static class Marenka {
        Integer state;
        LinkedList<Vojta> vojta = new LinkedList();

        Marenka(Integer state) {
            this.state = state;
        }

        void add(Vojta vojta) {
            this.vojta.add(vojta);
        }

        Vojta removeFirst() {
            return this.vojta.removeFirst();
        }

        boolean isEmpty() {
            return this.vojta.isEmpty();
        }

        Integer getState() {
            return this.state;
        }
    }

    private static final class TokenPropProvider
    implements TokenPropertyProvider {
        private final Object value;

        TokenPropProvider(Object value) {
            this.value = value;
        }

        public Object getValue(Token token, Object key) {
            if ("type".equals(key)) {
                return this.value;
            }
            return null;
        }
    }

    static class TokenProperties
    implements TokenPropertyProvider {
        private String type;
        private int startSkipLength;
        private int endSkipLength;

        TokenProperties(String type, int startSkipLength, int endSkipLength) {
            this.type = type;
            this.startSkipLength = startSkipLength;
            this.endSkipLength = endSkipLength;
        }

        public Object getValue(Token token, Object key) {
            if ("type".equals(key)) {
                return this.type;
            }
            if ("startSkipLength".equals(key)) {
                return new Integer(this.startSkipLength);
            }
            if ("endSkipLength".equals(key)) {
                return new Integer(this.endSkipLength);
            }
            return null;
        }
    }

    static class Vojta {
        String type;
        int startOffset;
        int endOffset;
        Object property;

        Vojta(String type, int startOffset, int endOffset, Object property) {
            this.type = type;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.property = property;
        }

        int size() {
            return this.endOffset - this.startOffset;
        }
    }
}

