/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import org.netbeans.api.languages.CharInput;

public class StringInput
extends CharInput {
    private String expression;
    private int index = 0;
    private int length;

    public StringInput(String expression) {
        this.expression = expression;
        this.length = expression.length();
    }

    public char read() {
        if (this.index < this.length) {
            return this.expression.charAt(this.index++);
        }
        return '\u0000';
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean eof() {
        return this.index >= this.length;
    }

    public char next() {
        if (this.index < this.length) {
            return this.expression.charAt(this.index);
        }
        return '\u0000';
    }

    public String getString(int from, int to) {
        return this.expression.substring(from, to);
    }

    public String getAsText() {
        return this.expression.substring(this.index, this.expression.length());
    }
}

