/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColoringStorage {
    private static final Logger LOG = Logger.getLogger(ColoringStorage.class.getName());
    private static final String HIGHLIGHTING_FILE_NAME = "editorColoring.xml";
    private static final String E_ROOT = "fontscolors";
    private static final String E_FONTCOLOR = "fontcolor";
    private static final String E_FONT = "font";
    private static final String A_NAME = "name";
    private static final String A_FOREGROUND = "foreColor";
    private static final String A_BACKGROUND = "bgColor";
    private static final String A_STRIKETHROUGH = "strikeThrough";
    private static final String A_WAVEUNDERLINE = "waveUnderlined";
    private static final String A_UNDERLINE = "underline";
    private static final String A_DEFAULT = "default";
    private static final String A_SIZE = "size";
    private static final String A_STYLE = "style";
    private static final String V_BOLD_ITALIC = "bold+italic";
    private static final String V_BOLD = "bold";
    private static final String V_ITALIC = "italic";
    private static final String V_PLAIN = "plain";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Fonts and Colors settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorFontsColors-1_1.dtd";
    private static final String FA_TYPE = "nbeditor-settings-ColoringType";
    private static final String FAV_TOKEN = "token";
    private static final String FAV_HIGHLIGHT = "highlight";

    private ColoringStorage() {
    }

    public static Map<String, AttributeSet> loadColorings(MimePath mimePath, String profile, boolean colorings, boolean defaults) {
        List<Object[]> filesForLocalization;
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        FileObject baseFolder = Repository.getDefault().getDefaultFileSystem().findResource("Editors");
        HashMap<String, List<Object[]>> files = new HashMap<String, List<Object[]>>();
        SettingsType.FONTSCOLORS.getLocator().scan(baseFolder, mimePath.getPath(), profile, true, true, !defaults, files);
        assert (files.size() <= 1) : "Too many results in the scan";
        List<Object[]> profileInfos = (List<Object[]>)files.get(profile);
        if (profileInfos == null) {
            return Collections.emptyMap();
        }
        if (!profile.equals("NetBeans")) {
            HashMap<String, List<Object[]>> defaultProfileModulesFiles = new HashMap<String, List<Object[]>>();
            SettingsType.FONTSCOLORS.getLocator().scan(baseFolder, mimePath.getPath(), "NetBeans", true, true, false, defaultProfileModulesFiles);
            filesForLocalization = (List)defaultProfileModulesFiles.get("NetBeans");
            if (filesForLocalization == null) {
                filesForLocalization = Collections.emptyList();
            }
        } else {
            filesForLocalization = profileInfos;
        }
        HashMap<String, SimpleAttributeSet> fontsColorsMap = new HashMap<String, SimpleAttributeSet>();
        for (Object[] info : profileInfos) {
            FileObject profileHome = (FileObject)info[0];
            FileObject settingFile = (FileObject)info[1];
            boolean modulesFile = (Boolean)info[2];
            boolean isTokenColoringFile = ColoringStorage.isTokenColoringFile(settingFile);
            if (isTokenColoringFile != colorings) continue;
            List sets = (List)XMLStorage.load(settingFile, new ColoringsReader());
            for (SimpleAttributeSet as : sets) {
                String name = (String)as.getAttribute(StyleConstants.NameAttribute);
                SimpleAttributeSet previous = (SimpleAttributeSet)fontsColorsMap.get(name);
                if (previous == null) {
                    String displayName = Utils.getLocalizedName(settingFile, name, null, true);
                    if (displayName == null) {
                        Object[] locFileInfo;
                        FileObject locFile;
                        Iterator<Object[]> i$ = filesForLocalization.iterator();
                        while (i$.hasNext() && (displayName = Utils.getLocalizedName(locFile = (FileObject)(locFileInfo = i$.next())[1], name, null, true)) == null) {
                        }
                    }
                    if (displayName == null) {
                        displayName = name;
                    }
                    as.addAttribute(EditorStyleConstants.DisplayName, displayName);
                    fontsColorsMap.put(name, as);
                    continue;
                }
                ColoringStorage.mergeAttributeSets(previous, as);
            }
        }
        return Utils.immutize(fontsColorsMap);
    }

    private static void mergeAttributeSets(SimpleAttributeSet original, AttributeSet toMerge) {
        Enumeration<?> names = toMerge.getAttributeNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            Object value = toMerge.getAttribute(key);
            original.addAttribute(key, value);
        }
    }

    public static void deleteColorings(MimePath mimePath, String profile, final boolean colorings, boolean defaults) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        FileObject baseFolder = sfs.findResource("Editors");
        HashMap<String, List<Object[]>> files = new HashMap<String, List<Object[]>>();
        SettingsType.FONTSCOLORS.getLocator().scan(baseFolder, mimePath.getPath(), profile, true, defaults, !defaults, files);
        assert (files.size() <= 1) : "Too many results in the scan";
        final List profileInfos = (List)files.get(profile);
        if (profileInfos != null) {
            try {
                sfs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() {
                        for (Object[] info : profileInfos) {
                            FileObject settingFile = (FileObject)info[1];
                            boolean isTokenColoringFile = ColoringStorage.isTokenColoringFile(settingFile);
                            if (isTokenColoringFile != colorings) continue;
                            try {
                                settingFile.delete();
                            }
                            catch (IOException ioe) {
                                LOG.log(Level.WARNING, "Can't delete editor settings file " + settingFile.getPath(), ioe);
                            }
                        }
                    }
                });
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Can't delete editor colorings for " + mimePath.getPath() + ", " + profile, ioe);
            }
        }
    }

    public static void saveColorings(MimePath mimePath, String profile, final boolean colorings, boolean defaults, final Collection<AttributeSet> fontColors) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        final FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        final String settingFileName = SettingsType.FONTSCOLORS.getLocator().getWritableFileName(mimePath.getPath(), profile, defaults);
        try {
            sfs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject baseFolder = sfs.findResource("Editors");
                    FileObject f = FileUtil.createData((FileObject)baseFolder, (String)settingFileName);
                    f.setAttribute(ColoringStorage.FA_TYPE, (Object)(colorings ? ColoringStorage.FAV_TOKEN : ColoringStorage.FAV_HIGHLIGHT));
                    ColoringStorage.saveColorings(f, fontColors);
                }
            });
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Can't save editor colorings for " + mimePath.getPath() + ", " + profile, ioe);
        }
    }

    private static void saveColorings(FileObject fo, Collection<AttributeSet> colorings) {
        Document doc = XMLUtil.createDocument((String)E_ROOT, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
        Node root = doc.getElementsByTagName(E_ROOT).item(0);
        for (AttributeSet category : colorings) {
            Element fontColor = doc.createElement(E_FONTCOLOR);
            root.appendChild(fontColor);
            fontColor.setAttribute(A_NAME, (String)category.getAttribute(StyleConstants.NameAttribute));
            if (category.isDefined(StyleConstants.Foreground)) {
                fontColor.setAttribute(A_FOREGROUND, Utils.colorToString((Color)category.getAttribute(StyleConstants.Foreground)));
            }
            if (category.isDefined(StyleConstants.Background)) {
                fontColor.setAttribute(A_BACKGROUND, Utils.colorToString((Color)category.getAttribute(StyleConstants.Background)));
            }
            if (category.isDefined(StyleConstants.StrikeThrough)) {
                fontColor.setAttribute(A_STRIKETHROUGH, Utils.colorToString((Color)category.getAttribute(StyleConstants.StrikeThrough)));
            }
            if (category.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                fontColor.setAttribute(A_WAVEUNDERLINE, Utils.colorToString((Color)category.getAttribute(EditorStyleConstants.WaveUnderlineColor)));
            }
            if (category.isDefined(StyleConstants.Underline)) {
                fontColor.setAttribute(A_UNDERLINE, Utils.colorToString((Color)category.getAttribute(StyleConstants.Underline)));
            }
            if (category.isDefined(EditorStyleConstants.Default)) {
                fontColor.setAttribute(A_DEFAULT, (String)category.getAttribute(EditorStyleConstants.Default));
            }
            if (!category.isDefined(StyleConstants.FontFamily) && !category.isDefined(StyleConstants.FontSize) && !category.isDefined(StyleConstants.Bold) && !category.isDefined(StyleConstants.Italic)) continue;
            Element font = doc.createElement(E_FONT);
            fontColor.appendChild(font);
            if (category.isDefined(StyleConstants.FontFamily)) {
                font.setAttribute(A_NAME, (String)category.getAttribute(StyleConstants.FontFamily));
            }
            if (category.isDefined(StyleConstants.FontSize)) {
                font.setAttribute(A_SIZE, ((Integer)category.getAttribute(StyleConstants.FontSize)).toString());
            }
            if (!category.isDefined(StyleConstants.Bold) && !category.isDefined(StyleConstants.Italic)) continue;
            Boolean bold = Boolean.FALSE;
            Boolean italic = Boolean.FALSE;
            if (category.isDefined(StyleConstants.Bold)) {
                bold = (Boolean)category.getAttribute(StyleConstants.Bold);
            }
            if (category.isDefined(StyleConstants.Italic)) {
                italic = (Boolean)category.getAttribute(StyleConstants.Italic);
            }
            font.setAttribute(A_STYLE, bold.booleanValue() ? (italic.booleanValue() ? V_BOLD_ITALIC : V_BOLD) : (italic != false ? V_ITALIC : V_PLAIN));
        }
        XMLStorage.save(fo, doc);
    }

    private static boolean isTokenColoringFile(FileObject f) {
        Object typeValue = f.getAttribute(FA_TYPE);
        if (typeValue instanceof String) {
            return typeValue.equals(FAV_TOKEN);
        }
        return !f.getNameExt().equals(HIGHLIGHTING_FILE_NAME);
    }

    private static class ColoringsReader
    extends XMLStorage.Handler {
        private List<AttributeSet> colorings = new ArrayList<AttributeSet>();

        public Object getResult() {
            return this.colorings;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            block14: {
                try {
                    if (name.equals(ColoringStorage.E_ROOT)) break block14;
                    if (name.equals(ColoringStorage.E_FONTCOLOR)) {
                        SimpleAttributeSet a = new SimpleAttributeSet();
                        a.addAttribute(StyleConstants.NameAttribute, attributes.getValue(ColoringStorage.A_NAME));
                        String value = attributes.getValue(ColoringStorage.A_BACKGROUND);
                        if (value != null) {
                            a.addAttribute(StyleConstants.Background, Utils.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_FOREGROUND)) != null) {
                            a.addAttribute(StyleConstants.Foreground, Utils.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_UNDERLINE)) != null) {
                            a.addAttribute(StyleConstants.Underline, Utils.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_STRIKETHROUGH)) != null) {
                            a.addAttribute(StyleConstants.StrikeThrough, Utils.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_WAVEUNDERLINE)) != null) {
                            a.addAttribute(EditorStyleConstants.WaveUnderlineColor, Utils.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_DEFAULT)) != null) {
                            a.addAttribute(EditorStyleConstants.Default, value);
                        }
                        this.colorings.add(a);
                        break block14;
                    }
                    if (!name.equals(ColoringStorage.E_FONT)) break block14;
                    SimpleAttributeSet a = (SimpleAttributeSet)this.colorings.get(this.colorings.size() - 1);
                    String value = attributes.getValue(ColoringStorage.A_NAME);
                    if (value != null) {
                        a.addAttribute(StyleConstants.FontFamily, value);
                    }
                    if ((value = attributes.getValue(ColoringStorage.A_SIZE)) != null) {
                        try {
                            a.addAttribute(StyleConstants.FontSize, Integer.decode(value));
                        }
                        catch (NumberFormatException ex) {
                            LOG.log(Level.WARNING, value + " is not a valid Integer; parsing " + this.getProcessedFile().getPath(), ex);
                        }
                    }
                    if ((value = attributes.getValue(ColoringStorage.A_STYLE)) != null) {
                        a.addAttribute(StyleConstants.Bold, value.indexOf(ColoringStorage.V_BOLD) >= 0);
                        a.addAttribute(StyleConstants.Italic, value.indexOf(ColoringStorage.V_ITALIC) >= 0);
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Can't parse colorings file " + this.getProcessedFile().getPath(), ex);
                }
            }
        }

        public InputSource resolveEntity(String pubid, String sysid) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

