/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.settings.storage.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeFCS
extends FontColorSettings {
    private static final String DEFAULT = "default";
    private static final int DEFAULT_FONT_SIZE = UIManager.get("customFontSize") != null ? ((Integer)UIManager.get("customFontSize")).intValue() : UIManager.getFont("TextField.font").getSize();
    private static final AttributeSet HARDCODED_DEFAULT_COLORING = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.NameAttribute, "default", StyleConstants.Foreground, Color.black, StyleConstants.Background, Color.white, StyleConstants.FontFamily, "Monospaced", StyleConstants.FontSize, DEFAULT_FONT_SIZE < 12 ? 12 : DEFAULT_FONT_SIZE});
    private static final AttributeSet NULL = new SimpleAttributeSet();
    private final FontColorSettingsImpl[] allFcsi;
    final String profile;
    private final Map<String, AttributeSet> tokensCache = new HashMap<String, AttributeSet>();

    public CompositeFCS(MimePath[] allPaths, String profile) {
        assert (allPaths != null) : "The parameter allPaths should not be null";
        assert (allPaths.length > 0) : "The parameter allPaths should always contain at least MimePath.EMPTY";
        assert (profile != null) : "The parameter profile should not be null";
        this.allFcsi = new FontColorSettingsImpl[allPaths.length];
        for (int i = 0; i < allPaths.length; ++i) {
            this.allFcsi[i] = FontColorSettingsImpl.get(allPaths[i]);
        }
        this.profile = profile;
    }

    public AttributeSet getFontColors(String highlightName) {
        assert (highlightName != null) : "The parameter highlightName must not be null.";
        if (highlightName.equals(DEFAULT)) {
            return this.getTokenFontColors(DEFAULT);
        }
        AttributeSet attribs = null;
        Map<String, AttributeSet> coloringsMap = EditorSettings.getDefault().getHighlightings(this.profile);
        if (coloringsMap != null && (attribs = coloringsMap.get(highlightName)) == null) {
            attribs = NULL;
        }
        return attribs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeSet getTokenFontColors(String tokenName) {
        assert (tokenName != null) : "The parameter tokenName must not be null.";
        Map<String, AttributeSet> map = this.tokensCache;
        synchronized (map) {
            AttributeSet attribs = this.tokensCache.get(tokenName);
            if (attribs == null) {
                attribs = this.findColoringForToken(tokenName);
                this.tokensCache.put(tokenName, attribs);
            }
            return attribs == NULL ? null : attribs;
        }
    }

    private AttributeSet findColoringForToken(String tokenName) {
        ArrayList<AttributeSet> colorings = new ArrayList<AttributeSet>();
        String name = tokenName;
        for (FontColorSettingsImpl fcsi : this.allFcsi) {
            name = this.processLayer(fcsi, name, colorings);
        }
        if (tokenName.equals(DEFAULT)) {
            colorings.add(HARDCODED_DEFAULT_COLORING);
        }
        if (colorings.size() > 0) {
            return AttributesUtilities.createImmutable((AttributeSet[])colorings.toArray(new AttributeSet[colorings.size()]));
        }
        return NULL;
    }

    private String processLayer(FontColorSettingsImpl fcsi, String name, ArrayList<AttributeSet> colorings) {
        AttributeSet as = fcsi.getColorings(this.profile).get(name);
        if (as == null) {
            as = fcsi.getDefaultColorings(this.profile).get(name);
        }
        if (as != null) {
            colorings.add(as);
            String nameOfColoring = (String)as.getAttribute(StyleConstants.NameAttribute);
            String nameOfDelegate = (String)as.getAttribute(EditorStyleConstants.Default);
            if (nameOfDelegate != null && !nameOfDelegate.equals(DEFAULT)) {
                if (!nameOfDelegate.equals(nameOfColoring)) {
                    nameOfDelegate = this.processLayer(fcsi, nameOfDelegate, colorings);
                }
            } else {
                nameOfDelegate = nameOfColoring;
            }
            name = nameOfDelegate;
        }
        return name;
    }

    private void dumpAttribs(AttributeSet attribs, String name, boolean tokenColoring) {
        StringBuilder sb = new StringBuilder();
        sb.append("Attribs for base mime path '");
        sb.append(this.allFcsi[0].getMimePath().getPath());
        sb.append("' and ");
        if (tokenColoring) {
            sb.append("token '");
        } else {
            sb.append("highlight '");
        }
        sb.append(name);
        sb.append("' = {");
        Enumeration<?> keys = attribs.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = attribs.getAttribute(key);
            sb.append("'" + key + "' = '" + value + "'");
            if (!keys.hasMoreElements()) continue;
            sb.append(", ");
        }
        sb.append("} CompoundFCS.this = ");
        sb.append(((Object)((Object)this)).toString());
        System.out.println(sb.toString());
    }
}

