/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyMapsStorage {
    private static final Logger LOG = Logger.getLogger(KeyMapsStorage.class.getName());
    private static final String ROOT = "bindings";
    private static final String E_BIND = "bind";
    private static final String A_ACTION_NAME = "actionName";
    private static final String A_KEY = "key";
    private static final String A_REMOVE = "remove";
    private static final String V_TRUE = "true";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor KeyBindings settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorKeyBindings-1_1.dtd";

    private KeyMapsStorage() {
    }

    public static Map<Collection<KeyStroke>, MultiKeyBinding> loadKeyMaps(MimePath mimePath, String profile, boolean defaults) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        FileObject baseFolder = Repository.getDefault().getDefaultFileSystem().findResource("Editors");
        HashMap<String, List<Object[]>> files = new HashMap<String, List<Object[]>>();
        SettingsType.KEYBINDINGS.getLocator().scan(baseFolder, mimePath.getPath(), profile, true, true, !defaults, files);
        assert (files.size() <= 1) : "Too many results in the scan";
        List profileInfos = (List)files.get(profile);
        if (profileInfos == null) {
            return Collections.emptyMap();
        }
        HashMap keybindingsMap = new HashMap();
        for (Object[] info : profileInfos) {
            FileObject profileHome = (FileObject)info[0];
            FileObject settingFile = (FileObject)info[1];
            boolean modulesFile = (Boolean)info[2];
            Object[] loadedData = (Object[])XMLStorage.load(settingFile, new KeyMapsReader());
            Map addedBindings = (Map)loadedData[0];
            Collection removedBindings = (Collection)loadedData[1];
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Loading keybindings from: '" + settingFile.getPath() + "'");
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("--- Removing keybindings: " + removedBindings);
            }
            for (Collection binding : removedBindings) {
                keybindingsMap.remove(binding);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("--- Adding keybindings: " + addedBindings);
            }
            keybindingsMap.putAll(addedBindings);
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.finest("-------------------------------------");
        }
        return Collections.unmodifiableMap(keybindingsMap);
    }

    public static void deleteProfile(MimePath mimePath, String profile, boolean defaults) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        FileObject baseFolder = sfs.findResource("Editors");
        HashMap<String, List<Object[]>> files = new HashMap<String, List<Object[]>>();
        SettingsType.KEYBINDINGS.getLocator().scan(baseFolder, mimePath.getPath(), profile, true, defaults, !defaults, files);
        assert (files.size() <= 1) : "Too many results in the scan";
        final List profileInfos = (List)files.get(profile);
        if (profileInfos != null) {
            try {
                sfs.runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() {
                        for (Object[] info : profileInfos) {
                            FileObject settingFile = (FileObject)info[1];
                            try {
                                settingFile.delete();
                            }
                            catch (IOException ioe) {
                                LOG.log(Level.WARNING, "Can't delete editor settings file " + settingFile.getPath(), ioe);
                            }
                        }
                    }
                });
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Can't delete editor keybindings for " + mimePath.getPath() + ", " + profile, ioe);
            }
        }
    }

    public static void saveKeyMaps(MimePath mimePath, String profile, boolean defaults, final Collection<MultiKeyBinding> keybindings, final Set<Collection<KeyStroke>> removedKeybindings) {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        final FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        final String settingFileName = SettingsType.KEYBINDINGS.getLocator().getWritableFileName(mimePath.getPath(), profile, defaults);
        try {
            sfs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject baseFolder = sfs.findResource("Editors");
                    FileObject f = FileUtil.createData((FileObject)baseFolder, (String)settingFileName);
                    KeyMapsStorage.saveKeybindings(f, keybindings, removedKeybindings);
                }
            });
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Can't save editor keybindings for " + mimePath.getPath() + ", " + profile, ioe);
        }
    }

    private static void saveKeybindings(FileObject fo, Collection<MultiKeyBinding> keyMap, Set<Collection<KeyStroke>> removed) {
        Document doc = XMLUtil.createDocument((String)ROOT, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
        Node root = doc.getElementsByTagName(ROOT).item(0);
        for (MultiKeyBinding multiKeyBinding : keyMap) {
            Element bind = doc.createElement(E_BIND);
            root.appendChild(bind);
            bind.setAttribute(A_ACTION_NAME, multiKeyBinding.getActionName());
            bind.setAttribute(A_KEY, Utils.keyStrokesToString(multiKeyBinding.getKeyStrokeList()));
        }
        for (Collection collection : removed) {
            String shortcut = Utils.keyStrokesToString(collection);
            Element bind = doc.createElement(E_BIND);
            root.appendChild(bind);
            bind.setAttribute(A_KEY, shortcut);
            bind.setAttribute(A_REMOVE, V_TRUE);
        }
        XMLStorage.save(fo, doc);
    }

    private static class KeyMapsReader
    extends XMLStorage.Handler {
        private Map<Collection<KeyStroke>, MultiKeyBinding> keyMap = new HashMap<Collection<KeyStroke>, MultiKeyBinding>();
        private Collection<Collection<KeyStroke>> removedShortcuts = new HashSet<Collection<KeyStroke>>();

        private KeyMapsReader() {
        }

        public Object getResult() {
            return new Object[]{this.keyMap, this.removedShortcuts};
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            try {
                if (!name.equals(KeyMapsStorage.ROOT) && name.equals(KeyMapsStorage.E_BIND)) {
                    int idx;
                    String key = attributes.getValue(KeyMapsStorage.A_KEY);
                    if (!Utilities.isMac() && this.isModuleFile() && key != null && key.length() > 0 && (idx = key.indexOf(45)) != -1 && (key.charAt(0) == 'A' || key.charAt(0) == 'C')) {
                        LOG.warning("The keybinding '" + key + "' in " + this.getProcessedFile().getPath() + " may not work correctly on Mac. " + "Keybindings starting with Alt or Ctrl should " + "be coded with latin capital letters 'O' " + "or 'D' respectively. For details see org.openide.util.Utilities.stringToKey().");
                    }
                    KeyStroke[] shortcut = Utils.stringToKeyStrokes(key);
                    String remove = attributes.getValue(KeyMapsStorage.A_REMOVE);
                    if (Boolean.valueOf(remove).booleanValue()) {
                        this.removedShortcuts.add(Arrays.asList(shortcut));
                    } else {
                        String actionName = attributes.getValue(KeyMapsStorage.A_ACTION_NAME);
                        if (actionName != null) {
                            MultiKeyBinding mkb = new MultiKeyBinding(shortcut, actionName);
                            this.keyMap.put(Arrays.asList(shortcut), mkb);
                        } else {
                            LOG.warning("Ignoring keybinding '" + key + "' with no action name.");
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Can't parse keybindings file " + this.getProcessedFile().getPath(), ex);
            }
        }

        public InputSource resolveEntity(String pubid, String sysid) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

