/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.editor.settings.storage.MimeTypesTracker;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfilesTracker {
    public static final String PROP_PROFILES = "profiles";
    private static final Logger LOG = Logger.getLogger(ProfilesTracker.class.getName());
    private final SettingsType.Locator locator;
    private final MimeTypesTracker mimeTypes;
    private final FileSystem sfs;
    private final Listener listener;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final String LOCK = new String("ProfilesTracker.LOCK");
    private Map<String, ProfileDescription> profiles = Collections.emptyMap();
    private Map<String, ProfileDescription> profilesByDisplayName = Collections.emptyMap();

    public ProfilesTracker(SettingsType type, MimeTypesTracker mimeTypes) {
        assert (type != null) : "The parameter type must not be null";
        assert (type.isUsingProfiles()) : "No need to track profiles for settings that do not use profiles.";
        this.locator = type == null ? null : type.getLocator();
        this.mimeTypes = mimeTypes;
        this.rebuild();
        this.listener = new Listener();
        this.sfs = Repository.getDefault().getDefaultFileSystem();
        this.sfs.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.listener, (Object)this.sfs));
        this.mimeTypes.addPropertyChangeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getProfilesDisplayNames() {
        String string = this.LOCK;
        synchronized (string) {
            return this.profilesByDisplayName.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileDescription getProfileByDisplayName(String displayName) {
        String string = this.LOCK;
        synchronized (string) {
            return this.profilesByDisplayName.get(displayName);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent event = null;
        String string = this.LOCK;
        synchronized (string) {
            FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
            HashMap<String, List<Object[]>> scan = new HashMap<String, List<Object[]>>();
            FileObject baseFolder = sfs.findResource(this.mimeTypes.getBasePath());
            if (baseFolder != null && baseFolder.isFolder()) {
                this.locator.scan(baseFolder, null, null, false, true, true, scan);
                Set<String> mimes = this.mimeTypes.getMimeTypes();
                for (String mime : mimes) {
                    this.locator.scan(baseFolder, mime, null, false, true, true, scan);
                }
            }
            HashMap<String, ProfileDescription> newProfiles = new HashMap<String, ProfileDescription>();
            HashMap<String, ProfileDescription> newProfilesByDisplayName = new HashMap<String, ProfileDescription>();
            for (String id : scan.keySet()) {
                ProfileDescription maybeDupl;
                List profileInfos = (List)scan.get(id);
                String displayName = null;
                boolean canRollback = false;
                for (Object[] info : profileInfos) {
                    FileObject profileHome = (FileObject)info[0];
                    FileObject settingFile = (FileObject)info[1];
                    boolean modulesFile = (Boolean)info[2];
                    if (displayName == null && profileHome != null && (displayName = Utils.getLocalizedName(profileHome, null)) == null) {
                        displayName = Utils.getLocalizedName(profileHome, id, null);
                    }
                    if (!canRollback) {
                        canRollback = modulesFile;
                    }
                    if (displayName == null || !canRollback) continue;
                    break;
                }
                if ((maybeDupl = newProfilesByDisplayName.get(displayName = displayName == null ? id : displayName)) != null) {
                    LOG.warning("Ignoring profile '" + id + "', it's got the same display name as '" + maybeDupl.getId());
                    continue;
                }
                ProfileDescription desc = this.reuseOrCreate(id, displayName, canRollback);
                newProfiles.put(id, desc);
                newProfilesByDisplayName.put(displayName, desc);
            }
            assert (newProfilesByDisplayName.size() == newProfiles.size()) : "Inconsistent profile maps";
            if (!((Object)this.profiles).equals(newProfiles)) {
                event = new PropertyChangeEvent(this, PROP_PROFILES, this.profiles, newProfiles);
                this.profiles = newProfiles;
                this.profilesByDisplayName = newProfilesByDisplayName;
            }
        }
        if (event != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    private ProfileDescription reuseOrCreate(String id, String displayName, boolean rollback) {
        ProfileDescription desc = this.profiles.get(id);
        if (desc != null && desc.getDisplayName().equals(displayName) && desc.isRollbackAllowed() == rollback) {
            return desc;
        }
        return new ProfileDescription(id, displayName, rollback);
    }

    private final class Listener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ProfilesTracker.this.rebuild();
        }

        public void fileDataCreated(FileEvent fe) {
            this.notifyRebuild(fe.getFile());
        }

        public void fileFolderCreated(FileEvent fe) {
            this.notifyRebuild(fe.getFile());
        }

        public void fileDeleted(FileEvent fe) {
            this.notifyRebuild(fe.getFile());
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.notifyRebuild(fe.getFile());
        }

        private void notifyRebuild(FileObject file) {
            String path = file.getPath();
            if (path.startsWith(ProfilesTracker.this.mimeTypes.getBasePath())) {
                ProfilesTracker.this.rebuild();
            }
        }
    }

    public static final class ProfileDescription {
        private final String id;
        private final String displayName;
        private final boolean isRollbackAllowed;

        private ProfileDescription(String id, String displayName, boolean isRollbackAllowed) {
            this.id = id;
            this.displayName = displayName;
            this.isRollbackAllowed = isRollbackAllowed;
        }

        public boolean isRollbackAllowed() {
            return this.isRollbackAllowed;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getId() {
            return this.id;
        }
    }
}

