/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.CompositeFCS;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class SettingsProvider
implements MimeDataProvider {
    private static final Logger LOG = Logger.getLogger(SettingsProvider.class.getName());
    private final Map<MimePath, WeakReference<Lookup>> cache = new WeakHashMap<MimePath, WeakReference<Lookup>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup(MimePath mimePath) {
        if (mimePath.size() > 0 && mimePath.getMimeType(0).contains("text/base")) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Won't provide any settings for text/base It's been deprecated, use MimePath.EMPTY instead.");
            }
            return null;
        }
        Map<MimePath, WeakReference<Lookup>> map = this.cache;
        synchronized (map) {
            Object lookup;
            WeakReference<Lookup> ref = this.cache.get(mimePath);
            Lookup lookup2 = lookup = ref == null ? null : (Lookup)ref.get();
            if (lookup == null) {
                String path = mimePath.getPath();
                if (path.startsWith("test")) {
                    int idx = path.indexOf(95);
                    if (idx == -1) {
                        throw new IllegalStateException("Invalid mimePath: " + path);
                    }
                    String profile = path.substring(0, idx);
                    MimePath realMimePath = MimePath.parse((String)path.substring(idx + 1));
                    lookup = new ProxyLookup(new Lookup[]{new MyLookup(realMimePath, profile), Lookups.exclude((Lookup)MimeLookup.getLookup((MimePath)realMimePath), (Class[])new Class[]{FontColorSettings.class, KeyBindingSettings.class})});
                } else {
                    lookup = new MyLookup(mimePath, null);
                }
                this.cache.put(mimePath, new WeakReference<Lookup>((Lookup)lookup));
            }
            return lookup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyLookup
    extends AbstractLookup
    implements PropertyChangeListener {
        private final MimePath mimePath;
        private final MimePath[] allMimePaths;
        private final boolean specialFcsProfile;
        private String fcsProfile;
        private final InstanceContent ic;
        private Object fontColorSettings = null;
        private Object keyBindingSettings = null;
        private KeyBindingSettingsImpl kbsi;

        public MyLookup(MimePath mimePath, String profile) {
            this(mimePath, profile, new InstanceContent());
        }

        private MyLookup(MimePath mimePath, String profile, InstanceContent ic) {
            super((AbstractLookup.Content)ic);
            this.mimePath = mimePath;
            this.allMimePaths = MyLookup.computeInheritedMimePaths(mimePath);
            if (profile == null) {
                String currentProfile = EditorSettings.getDefault().getCurrentFontColorProfile();
                this.fcsProfile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(currentProfile);
                this.specialFcsProfile = false;
            } else {
                this.fcsProfile = profile;
                this.specialFcsProfile = true;
            }
            this.ic = ic;
            EditorSettings es = EditorSettings.getDefault();
            es.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)es));
            this.kbsi = KeyBindingSettingsImpl.get(mimePath);
            this.kbsi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.kbsi));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initialize() {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                this.fontColorSettings = new CompositeFCS(this.allMimePaths, this.fcsProfile);
                this.keyBindingSettings = this.kbsi.createInstanceForLookup();
                this.ic.set(Arrays.asList(this.fontColorSettings, this.keyBindingSettings), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                String changedProfile;
                boolean fcsChanged = false;
                boolean kbsChanged = false;
                if (this.kbsi == evt.getSource()) {
                    kbsChanged = true;
                } else if (evt.getPropertyName() == null) {
                    if (!this.specialFcsProfile) {
                        String currentProfile = EditorSettings.getDefault().getCurrentFontColorProfile();
                        this.fcsProfile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(currentProfile);
                    }
                    fcsChanged = true;
                } else if (evt.getPropertyName().equals("editorFontColors")) {
                    changedProfile = (String)evt.getNewValue();
                    if (changedProfile.equals(this.fcsProfile)) {
                        fcsChanged = true;
                    }
                } else if (evt.getPropertyName().equals("fontColors")) {
                    MimePath changedMimePath;
                    changedProfile = (String)evt.getNewValue();
                    if (changedProfile.equals(this.fcsProfile) && this.isDerivedFromMimePath(changedMimePath = (MimePath)evt.getOldValue())) {
                        fcsChanged = true;
                    }
                } else if (evt.getPropertyName().equals("currentFontColorProfile") && !this.specialFcsProfile) {
                    String newProfile = (String)evt.getNewValue();
                    this.fcsProfile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(newProfile);
                    fcsChanged = true;
                }
                boolean updateContents = false;
                if (fcsChanged && this.fontColorSettings != null) {
                    this.fontColorSettings = new CompositeFCS(this.allMimePaths, this.fcsProfile);
                    updateContents = true;
                }
                if (kbsChanged && this.keyBindingSettings != null) {
                    this.keyBindingSettings = this.kbsi.createInstanceForLookup();
                    updateContents = true;
                }
                if (updateContents) {
                    this.ic.set(Arrays.asList(this.fontColorSettings, this.keyBindingSettings), null);
                }
            }
        }

        private boolean isDerivedFromMimePath(MimePath mimePath) {
            for (MimePath mp : this.allMimePaths) {
                if (mp != mimePath) continue;
                return true;
            }
            return false;
        }

        private static MimePath[] computeInheritedMimePaths(MimePath mimePath) {
            List<String> paths = MyLookup.callSwitchLookupComputePaths(mimePath);
            if (paths != null) {
                ArrayList<MimePath> mimePaths = new ArrayList<MimePath>(paths.size());
                for (String path : paths) {
                    mimePaths.add(MimePath.parse((String)path));
                }
                return mimePaths.toArray(new MimePath[mimePaths.size()]);
            }
            return new MimePath[]{mimePath, MimePath.EMPTY};
        }

        private static List<String> callSwitchLookupComputePaths(MimePath mimePath) {
            try {
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> clazz = classLoader.loadClass("org.netbeans.modules.editor.mimelookup.impl.SwitchLookup");
                Method method = clazz.getDeclaredMethod("computePaths", MimePath.class, String.class, String.class);
                method.setAccessible(true);
                List paths = (List)method.invoke(null, mimePath, null, null);
                return paths;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Can't call org.netbeans.modules.editor.mimelookup.impl.SwitchLookup.computePath(MimeLookup, String, String).", e);
                return null;
            }
        }
    }
}

