/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.openide.filesystems.FileObject;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettingsType
extends Enum<SettingsType> {
    public static final /* enum */ SettingsType FONTSCOLORS = new SettingsType("FontsColors", true, FontColorSettings.class, "text/x-nbeditor-fontcolorsettings");
    public static final /* enum */ SettingsType KEYBINDINGS = new SettingsType("Keybindings", true, KeyBindingSettings.class, "text/x-nbeditor-keybindingsettings");
    private static final Logger LOG;
    private final String settingsTypeId;
    private final boolean usesProfiles;
    private final Class apiClass;
    private final String mimeType;
    private Locator locator;
    private static final /* synthetic */ SettingsType[] $VALUES;

    public static final SettingsType[] values() {
        return (SettingsType[])$VALUES.clone();
    }

    public static SettingsType valueOf(String name) {
        return Enum.valueOf(SettingsType.class, name);
    }

    public static SettingsType get(Class apiClass) {
        assert (apiClass != null) : "The parameter apiClass can't be null";
        for (SettingsType type : SettingsType.values()) {
            if (!type.apiClass.equals(apiClass)) continue;
            return type;
        }
        return null;
    }

    private SettingsType(String settingsTypeId, boolean usesProfiles, Class apiClass, String mimeType) {
        this.settingsTypeId = settingsTypeId;
        this.usesProfiles = usesProfiles;
        this.apiClass = apiClass;
        this.mimeType = mimeType;
    }

    public String getId() {
        return this.settingsTypeId;
    }

    public boolean isUsingProfiles() {
        return this.usesProfiles;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Locator getLocator() {
        if (this.locator == null) {
            switch (this) {
                case FONTSCOLORS: {
                    this.locator = new FontsColorsLocator();
                    break;
                }
                case KEYBINDINGS: {
                    this.locator = new KeybindingsLocator();
                    break;
                }
                default: {
                    this.locator = new DefaultLocator(this);
                }
            }
        }
        return this.locator;
    }

    static {
        $VALUES = new SettingsType[]{FONTSCOLORS, KEYBINDINGS};
        LOG = Logger.getLogger(SettingsType.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultLocator
    implements Locator {
        protected static final String MODULE_FILES_FOLDER = "Defaults";
        protected static final String DEFAULT_PROFILE_NAME = "NetBeans";
        private static final String WRITABLE_FILE_PREFIX = "org-netbeans-modules-editor-settings-Custom";
        private static final String WRITABLE_FILE_SUFFIX = ".xml";
        private static final String FA_TARGET_OS = "nbeditor-settings-targetOS";
        private final SettingsType settingType;
        private final String settingTypeFolderName;
        private final String writableFileName;
        private final String modulesWritableFileName;
        private final String usersWritableFileName;

        public DefaultLocator(SettingsType settingType) {
            assert (settingType != null) : "The parameter settingType can't be null";
            this.settingType = settingType;
            this.settingTypeFolderName = "/" + settingType.getId() + "/";
            this.writableFileName = WRITABLE_FILE_PREFIX + settingType.getId() + WRITABLE_FILE_SUFFIX;
            this.modulesWritableFileName = "/Defaults/org-netbeans-modules-editor-settings-Custom" + settingType.getId() + WRITABLE_FILE_SUFFIX;
            this.usersWritableFileName = "/" + this.writableFileName;
        }

        @Override
        public final void scan(FileObject baseFolder, String mimeType, String profileId, boolean fullScan, boolean scanModules, boolean scanUsers, Map<String, List<Object[]>> results) {
            assert (results != null) : "The parameter results can't be null";
            FileObject mimeFolder = null;
            FileObject legacyMimeFolder = null;
            if (baseFolder != null) {
                mimeFolder = this.getMimeFolder(baseFolder, mimeType);
                legacyMimeFolder = this.getLegacyMimeFolder(baseFolder, mimeType);
            }
            if (scanModules) {
                if (legacyMimeFolder != null && legacyMimeFolder.isFolder()) {
                    this.addModulesLegacyFiles(legacyMimeFolder, profileId, fullScan, results);
                }
                if (mimeFolder != null && mimeFolder.isFolder()) {
                    this.addModulesFiles(mimeFolder, profileId, fullScan, results);
                }
            }
            if (scanUsers) {
                if (legacyMimeFolder != null && legacyMimeFolder.isFolder()) {
                    this.addUsersLegacyFiles(legacyMimeFolder, profileId, fullScan, results);
                }
                if (mimeFolder != null && mimeFolder.isFolder()) {
                    this.addUsersFiles(mimeFolder, profileId, fullScan, results);
                }
            }
        }

        @Override
        public final String getWritableFileName(String mimeType, String profileId, boolean modulesFile) {
            assert (mimeType != null) : "The mimeType parameter must not be null";
            assert (profileId != null) : "The profileId parameter must not be null";
            String part = mimeType.length() == 0 ? this.settingType.getId() + "/" : mimeType + this.settingTypeFolderName;
            if (modulesFile) {
                return part + profileId + this.modulesWritableFileName;
            }
            return part + profileId + this.usersWritableFileName;
        }

        protected FileObject getLegacyMimeFolder(FileObject baseFolder, String mimeType) {
            return mimeType == null ? baseFolder : baseFolder.getFileObject(mimeType);
        }

        protected void addModulesLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
        }

        protected void addUsersLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
        }

        private FileObject getMimeFolder(FileObject baseFolder, String mimeType) {
            return mimeType == null ? baseFolder : baseFolder.getFileObject(mimeType);
        }

        private void addModulesFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            if (profileId == null) {
                FileObject settingHome = mimeFolder.getFileObject(this.settingType.getId());
                if (settingHome != null && settingHome.isFolder()) {
                    FileObject[] profileHomes;
                    for (FileObject f : profileHomes = settingHome.getChildren()) {
                        if (!f.isFolder()) continue;
                        String id = f.getNameExt();
                        FileObject folder = f.getFileObject(MODULE_FILES_FOLDER);
                        if (folder == null || !folder.isFolder()) continue;
                        this.addFiles(folder, fullScan, files, id, f, true);
                    }
                }
            } else {
                FileObject folder = mimeFolder.getFileObject(this.settingType.getId() + "/" + profileId + "/" + MODULE_FILES_FOLDER);
                if (folder != null && folder.isFolder()) {
                    this.addFiles(folder, fullScan, files, profileId, folder.getParent(), true);
                }
            }
        }

        private void addUsersFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            if (profileId == null) {
                FileObject settingHome = mimeFolder.getFileObject(this.settingType.getId());
                if (settingHome != null && settingHome.isFolder()) {
                    FileObject[] profileHomes;
                    for (FileObject f : profileHomes = settingHome.getChildren()) {
                        if (!f.isFolder()) continue;
                        String id = f.getNameExt();
                        this.addFiles(f, fullScan, files, id, f, false);
                    }
                }
            } else {
                FileObject folder = mimeFolder.getFileObject(this.settingType.getId() + "/" + profileId);
                if (folder != null && folder.isFolder()) {
                    this.addFiles(folder, fullScan, files, profileId, folder, false);
                }
            }
        }

        private final void addFiles(FileObject folder, boolean fullScan, Map<String, List<Object[]>> files, String profileId, FileObject profileHome, boolean moduleFiles) {
            List<Object[]> infos;
            FileObject[] ff;
            Object[] writableFile = null;
            ArrayList<Object[]> osSpecificFiles = new ArrayList<Object[]>();
            for (FileObject f : ff = DefaultLocator.getOrderedChildren(folder)) {
                if (!f.isData()) continue;
                if (f.getMIMEType().equals(this.settingType.getMimeType())) {
                    List<Object[]> infos2;
                    Object targetOs;
                    block14: {
                        targetOs = f.getAttribute(FA_TARGET_OS);
                        if (targetOs != null) {
                            try {
                                if (!this.isApplicableForThisTargetOs(targetOs)) {
                                    LOG.fine("Ignoring OS specific file: '" + f.getPath() + "', it's targetted for '" + targetOs + "'");
                                }
                                break block14;
                            }
                            catch (Exception e) {
                                LOG.log(Level.WARNING, "Ignoring editor settings file with invalid OS type mask '" + targetOs + "' file: '" + f.getPath() + "'");
                            }
                            continue;
                        }
                    }
                    if ((infos2 = files.get(profileId)) == null) {
                        infos2 = new ArrayList<Object[]>();
                        files.put(profileId, infos2);
                    }
                    Object[] oo = new Object[]{profileHome, f, moduleFiles};
                    if (f.getNameExt().equals(this.writableFileName)) {
                        assert (writableFile == null);
                        writableFile = oo;
                    } else if (targetOs != null) {
                        osSpecificFiles.add(oo);
                    } else {
                        infos2.add(oo);
                    }
                    if (fullScan) continue;
                    break;
                }
                LOG.fine("Ignoring file: '" + f.getPath() + "' of type " + f.getMIMEType());
            }
            if (!osSpecificFiles.isEmpty()) {
                infos = files.get(profileId);
                infos.addAll(osSpecificFiles);
            }
            if (writableFile != null) {
                infos = files.get(profileId);
                infos.add(writableFile);
            }
        }

        private boolean isApplicableForThisTargetOs(Object targetOs) throws NoSuchFieldException, IllegalAccessException {
            if (targetOs instanceof Boolean) {
                return (Boolean)targetOs;
            }
            if (targetOs instanceof String) {
                Field field = Utilities.class.getDeclaredField((String)targetOs);
                int targetOsMask = field.getInt(null);
                int currentOsId = Utilities.getOperatingSystem();
                return (currentOsId & targetOsMask) != 0;
            }
            return false;
        }

        protected static FileObject[] getOrderedChildren(FileObject folder) {
            List sorted;
            HashMap<String, FileObject> children = new HashMap<String, FileObject>();
            for (FileObject f : folder.getChildren()) {
                String name = f.getNameExt();
                children.put(name, f);
            }
            HashMap<FileObject, HashSet<FileObject>> edges = new HashMap<FileObject, HashSet<FileObject>>();
            Enumeration attrNames = folder.getAttributes();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                Object attrValue = folder.getAttribute(attrName);
                int slashIdx = attrName.indexOf(47);
                if (slashIdx == -1 || !(attrValue instanceof Boolean)) continue;
                String name1 = attrName.substring(0, slashIdx);
                String name2 = attrName.substring(slashIdx + 1);
                if (!((Boolean)attrValue).booleanValue()) {
                    String s = name1;
                    name1 = name2;
                    name2 = s;
                }
                FileObject from = (FileObject)children.get(name1);
                FileObject to = (FileObject)children.get(name2);
                if (from == null || to == null) continue;
                HashSet<FileObject> vertices = (HashSet<FileObject>)edges.get(from);
                if (vertices == null) {
                    vertices = new HashSet<FileObject>();
                    edges.put(from, vertices);
                }
                vertices.add(to);
            }
            try {
                sorted = Utilities.topologicalSort(children.values(), edges);
            }
            catch (TopologicalSortException e) {
                List whyTheHellDoINeedToDoThis;
                LOG.log(Level.WARNING, "Can't sort folder children.", e);
                sorted = whyTheHellDoINeedToDoThis = e.partialSort();
            }
            return sorted.toArray(new FileObject[sorted.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FontsColorsLocator
    extends DefaultLocator {
        private static final String[] M_LEGACY_FILE_NAMES = new String[]{"Defaults/defaultColoring.xml", "Defaults/coloring.xml", "Defaults/editorColoring.xml"};
        private static final String[] U_LEGACY_FILE_NAMES = new String[]{"defaultColoring.xml", "coloring.xml", "editorColoring.xml"};

        public FontsColorsLocator() {
            super(FONTSCOLORS);
        }

        @Override
        protected void addModulesLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            this.addFiles(mimeFolder, profileId, fullScan, M_LEGACY_FILE_NAMES, files, true);
        }

        @Override
        protected void addUsersLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            this.addFiles(mimeFolder, profileId, fullScan, U_LEGACY_FILE_NAMES, files, false);
        }

        private void addFiles(FileObject mimeFolder, String profileId, boolean fullScan, String[] filePaths, Map<String, List<Object[]>> files, boolean moduleFiles) {
            if (profileId == null) {
                FileObject[] profileHomes;
                for (FileObject f : profileHomes = mimeFolder.getChildren()) {
                    if (!f.isFolder()) continue;
                    String id = f.getNameExt();
                    this.addFiles(f, filePaths, fullScan, files, id, f, moduleFiles);
                }
            } else {
                FileObject profileHome = mimeFolder.getFileObject(profileId);
                if (profileHome != null && profileHome.isFolder()) {
                    this.addFiles(profileHome, filePaths, fullScan, files, profileId, profileHome, moduleFiles);
                }
            }
        }

        private void addFiles(FileObject folder, String[] filePaths, boolean fullScan, Map<String, List<Object[]>> files, String profileId, FileObject profileHome, boolean moduleFiles) {
            for (String filePath : filePaths) {
                FileObject f = folder.getFileObject(filePath);
                if (f == null) continue;
                List<Object[]> pair = files.get(profileId);
                if (pair == null) {
                    pair = new ArrayList<Object[]>();
                    files.put(profileId, pair);
                }
                pair.add(new Object[]{profileHome, f, moduleFiles});
                if (LOG.isLoggable(Level.INFO)) {
                    Utils.logOnce(LOG, Level.INFO, "Fonts & colors profiles should reside in '" + FONTSCOLORS.getId() + "' subfolder, " + "see #90403 for details. Offending file '" + f.getPath() + "'", null);
                }
                if (!fullScan) break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeybindingsLocator
    extends DefaultLocator {
        private static final String M_KEYBINDING_FILE_NAME = "Defaults/keybindings.xml";
        private static final String U_KEYBINDING_FILE_NAME = "keybindings.xml";

        public KeybindingsLocator() {
            super(KEYBINDINGS);
        }

        @Override
        protected FileObject getLegacyMimeFolder(FileObject baseFolder, String mimeType) {
            if (mimeType == null || mimeType.length() == 0) {
                return baseFolder.getFileObject("text/base");
            }
            return ((DefaultLocator)this).getMimeFolder(baseFolder, mimeType);
        }

        @Override
        protected void addModulesLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            this.addFiles(mimeFolder, profileId, fullScan, M_KEYBINDING_FILE_NAME, files, true);
        }

        @Override
        protected void addUsersLegacyFiles(FileObject mimeFolder, String profileId, boolean fullScan, Map<String, List<Object[]>> files) {
            this.addFiles(mimeFolder, profileId, fullScan, U_KEYBINDING_FILE_NAME, files, false);
        }

        private void addFiles(FileObject mimeFolder, String profileId, boolean fullScan, String filePath, Map<String, List<Object[]>> files, boolean moduleFiles) {
            if (profileId == null) {
                FileObject[] profileHomes;
                for (FileObject f : profileHomes = mimeFolder.getChildren()) {
                    if (!f.isFolder() || f.getNameExt().equals("Defaults")) continue;
                    String id = f.getNameExt();
                    FileObject file = f.getFileObject(filePath);
                    if (file == null) continue;
                    this.addFile(file, files, id, f, moduleFiles);
                }
                FileObject file = mimeFolder.getFileObject(filePath);
                if (file != null) {
                    this.addFile(file, files, "NetBeans", null, moduleFiles);
                }
            } else if (profileId.equals("NetBeans")) {
                FileObject file = mimeFolder.getFileObject(filePath);
                if (file != null) {
                    this.addFile(file, files, profileId, null, moduleFiles);
                }
            } else {
                FileObject file;
                FileObject profileHome = mimeFolder.getFileObject(profileId);
                if (profileHome != null && profileHome.isFolder() && (file = profileHome.getFileObject(filePath)) != null) {
                    this.addFile(file, files, profileId, profileHome, moduleFiles);
                }
            }
        }

        private void addFile(FileObject file, Map<String, List<Object[]>> files, String profileId, FileObject profileHome, boolean moduleFiles) {
            List<Object[]> pair = files.get(profileId);
            if (pair == null) {
                pair = new ArrayList<Object[]>();
                files.put(profileId, pair);
            }
            pair.add(new Object[]{profileHome, file, moduleFiles});
            if (LOG.isLoggable(Level.INFO)) {
                Utils.logOnce(LOG, Level.INFO, "Keybinding profiles should reside in '" + KEYBINDINGS.getId() + "' subfolder, " + "see #90403 for details. Offending file '" + file.getPath() + "'", null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Locator {
        public void scan(FileObject var1, String var2, String var3, boolean var4, boolean var5, boolean var6, Map<String, List<Object[]>> var7);

        public String getWritableFileName(String var1, String var2, boolean var3);
    }
}

