/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final Map<Color, String> colorToName = new HashMap<Color, String>();
    private static final Map<String, Color> nameToColor = new HashMap<String, Color>();
    private static final Map<String, Integer> nameToFontStyle = new HashMap<String, Integer>();
    private static final Map<Integer, String> fontStyleToName = new HashMap<Integer, String>();
    private static final WeakHashMap<FileObject, Object[]> bundleInfos;
    private static final FileChangeListener listener;
    private static final FileChangeListener weakListener;
    private static final Set<String> ALREADY_LOGGED;

    static String colorToString(Color color) {
        if (colorToName.containsKey(color)) {
            return colorToName.get(color);
        }
        return Integer.toHexString(color.getRGB());
    }

    static Color stringToColor(String color) throws Exception {
        if (nameToColor.containsKey(color)) {
            return nameToColor.get(color);
        }
        try {
            return new Color((int)Long.parseLong(color, 16));
        }
        catch (NumberFormatException ex) {
            throw new Exception();
        }
    }

    static String keyStrokesToString(Collection<KeyStroke> keys) {
        StringBuffer sb = new StringBuffer();
        Iterator<KeyStroke> it = keys.iterator();
        if (it.hasNext()) {
            sb.append(Utilities.keyToString((KeyStroke)it.next()));
            while (it.hasNext()) {
                sb.append('$').append(Utilities.keyToString((KeyStroke)it.next()));
            }
        }
        return sb.toString();
    }

    static KeyStroke[] stringToKeyStrokes(String key) {
        StringTokenizer st = new StringTokenizer(key, "$");
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        key = null;
        while (st.hasMoreTokens()) {
            String ks = st.nextToken().trim();
            KeyStroke keyStroke = Utilities.stringToKey((String)ks);
            if (keyStroke == null) {
                LOG.fine("no key stroke for:" + key);
                continue;
            }
            result.add(keyStroke);
        }
        return result.toArray(new KeyStroke[result.size()]);
    }

    static String getLocalizedName(FileObject fo, String defaultValue) {
        try {
            return fo.getFileSystem().getStatus().annotateName(defaultValue, Collections.singleton(fo));
        }
        catch (FileStateInvalidException ex) {
            if (LOG.isLoggable(Level.INFO)) {
                Utils.logOnce(LOG, Level.INFO, "Can't find localized name of " + fo, ex);
            }
            return defaultValue;
        }
    }

    static String getLocalizedName(FileObject fo, String key, String defaultValue) {
        return Utils.getLocalizedName(fo, key, defaultValue, false);
    }

    static String getLocalizedName(FileObject fo, String key, String defaultValue, boolean silent) {
        block4: {
            assert (key != null) : "The key can't be null";
            Object[] bundleInfo = Utils.findResourceBundle(fo, silent);
            if (bundleInfo[1] != null) {
                try {
                    return ((ResourceBundle)bundleInfo[1]).getString(key);
                }
                catch (MissingResourceException ex) {
                    if (silent || !LOG.isLoggable(Level.INFO)) break block4;
                    Utils.logOnce(LOG, Level.INFO, "The bundle '" + bundleInfo[0] + "' is missing key '" + key + "'.", ex);
                }
            }
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] findResourceBundle(FileObject fo, boolean silent) {
        assert (fo != null) : "FileObject can't be null";
        WeakHashMap<FileObject, Object[]> weakHashMap = bundleInfos;
        synchronized (weakHashMap) {
            Object[] bundleInfo = bundleInfos.get(fo);
            if (bundleInfo == null) {
                String bundleName = null;
                Object attrValue = fo.getAttribute("SystemFileSystem.localizingBundle");
                if (attrValue instanceof String) {
                    bundleName = (String)attrValue;
                }
                if (bundleName != null) {
                    try {
                        bundleInfo = new Object[]{bundleName, NbBundle.getBundle((String)bundleName)};
                    }
                    catch (MissingResourceException ex) {
                        if (!silent && LOG.isLoggable(Level.INFO)) {
                            Utils.logOnce(LOG, Level.INFO, "Can't find resource bundle for " + fo.getPath(), ex);
                        }
                    }
                } else if (!silent && LOG.isLoggable(Level.FINE)) {
                    Utils.logOnce(LOG, Level.FINE, "The file " + fo.getPath() + " does not specify its resource bundle.", null);
                }
                if (bundleInfo == null) {
                    bundleInfo = new Object[]{bundleName, null};
                }
                bundleInfos.put(fo, bundleInfo);
                fo.removeFileChangeListener(weakListener);
                fo.addFileChangeListener(weakListener);
            }
            return bundleInfo;
        }
    }

    public static void logOnce(Logger logger, Level level, String msg, Throwable t) {
        if (!ALREADY_LOGGED.contains(msg)) {
            ALREADY_LOGGED.add(msg);
            if (t != null) {
                logger.log(level, msg, t);
            } else {
                logger.log(level, msg);
            }
            if (ALREADY_LOGGED.size() > 100) {
                ALREADY_LOGGED.clear();
            }
        }
    }

    public static MimePath mimeTypes2mimePath(String[] mimeTypes) {
        MimePath mimePath = MimePath.EMPTY;
        for (int i = 0; i < mimeTypes.length; ++i) {
            mimePath = MimePath.get((MimePath)mimePath, (String)mimeTypes[i]);
        }
        return mimePath;
    }

    public static Map<String, AttributeSet> immutize(Map<String, ? extends AttributeSet> map) {
        HashMap<String, AttributeSet> immutizedMap = new HashMap<String, AttributeSet>();
        for (String name : map.keySet()) {
            AttributeSet attribs = map.get(name);
            immutizedMap.put(name, AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attribs}));
        }
        return Collections.unmodifiableMap(immutizedMap);
    }

    public static Map<String, AttributeSet> immutize(Collection<AttributeSet> set) {
        HashMap<String, AttributeSet> immutizedMap = new HashMap<String, AttributeSet>();
        for (AttributeSet as : set) {
            Object nameObject = as.getAttribute(StyleConstants.NameAttribute);
            if (nameObject instanceof String) {
                immutizedMap.put((String)nameObject, as);
                continue;
            }
            LOG.warning("Ignoring AttributeSet with invalid StyleConstants.NameAttribute. AttributeSet: " + as);
        }
        return Collections.unmodifiableMap(immutizedMap);
    }

    static {
        colorToName.put(Color.black, "black");
        nameToColor.put("black", Color.black);
        colorToName.put(Color.blue, "blue");
        nameToColor.put("blue", Color.blue);
        colorToName.put(Color.cyan, "cyan");
        nameToColor.put("cyan", Color.cyan);
        colorToName.put(Color.darkGray, "darkGray");
        nameToColor.put("darkGray", Color.darkGray);
        colorToName.put(Color.gray, "gray");
        nameToColor.put("gray", Color.gray);
        colorToName.put(Color.green, "green");
        nameToColor.put("green", Color.green);
        colorToName.put(Color.lightGray, "lightGray");
        nameToColor.put("lightGray", Color.lightGray);
        colorToName.put(Color.magenta, "magenta");
        nameToColor.put("magenta", Color.magenta);
        colorToName.put(Color.orange, "orange");
        nameToColor.put("orange", Color.orange);
        colorToName.put(Color.pink, "pink");
        nameToColor.put("pink", Color.pink);
        colorToName.put(Color.red, "red");
        nameToColor.put("red", Color.red);
        colorToName.put(Color.white, "white");
        nameToColor.put("white", Color.white);
        colorToName.put(Color.yellow, "yellow");
        nameToColor.put("yellow", Color.yellow);
        nameToFontStyle.put("plain", new Integer(0));
        fontStyleToName.put(new Integer(0), "plain");
        nameToFontStyle.put("bold", new Integer(1));
        fontStyleToName.put(new Integer(1), "bold");
        nameToFontStyle.put("italic", new Integer(2));
        fontStyleToName.put(new Integer(2), "italic");
        nameToFontStyle.put("bold+italic", new Integer(3));
        fontStyleToName.put(new Integer(3), "bold+italic");
        bundleInfos = new WeakHashMap();
        listener = new FileChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDeleted(FileEvent fe) {
                WeakHashMap weakHashMap = bundleInfos;
                synchronized (weakHashMap) {
                    bundleInfos.remove(fe.getFile());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileAttributeChanged(FileAttributeEvent fe) {
                if (fe.getName() != null && fe.getName().equals("SystemFileSystem.localizingBundle")) {
                    WeakHashMap weakHashMap = bundleInfos;
                    synchronized (weakHashMap) {
                        bundleInfos.remove(fe.getFile());
                    }
                }
            }
        };
        weakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)listener, null);
        ALREADY_LOGGED = Collections.synchronizedSet(new HashSet());
    }
}

