/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetoucheUtils {
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static String htmlize(String input) {
        String temp = Utilities.replaceString((String)input, (String)"<", (String)"&lt;");
        temp = Utilities.replaceString((String)temp, (String)">", (String)"&gt;");
        return temp;
    }

    public static Collection<ExecutableElement> getOverridenMethods(ExecutableElement e, CompilationInfo info) {
        return RetoucheUtils.getOverridenMethods(e, SourceUtils.getEnclosingTypeElement((Element)e), info);
    }

    private static Collection<ExecutableElement> getOverridenMethods(ExecutableElement e, TypeElement parent, CompilationInfo info) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        TypeMirror sup = parent.getSuperclass();
        if (sup.getKind() == TypeKind.DECLARED) {
            TypeElement next = (TypeElement)((DeclaredType)sup).asElement();
            ExecutableElement executableElement = RetoucheUtils.getMethod(e, next, info);
            result.addAll(RetoucheUtils.getOverridenMethods(e, next, info));
            if (executableElement != null) {
                result.add(executableElement);
            }
        }
        for (TypeMirror typeMirror : parent.getInterfaces()) {
            TypeElement next = (TypeElement)((DeclaredType)typeMirror).asElement();
            ExecutableElement overriden2 = RetoucheUtils.getMethod(e, next, info);
            result.addAll(RetoucheUtils.getOverridenMethods(e, next, info));
            if (overriden2 == null) continue;
            result.add(overriden2);
        }
        return result;
    }

    private static ExecutableElement getMethod(ExecutableElement method, TypeElement type, CompilationInfo info) {
        for (ExecutableElement met : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (!info.getElements().overrides(method, met, type)) continue;
            return met;
        }
        return null;
    }

    public static Collection<ExecutableElement> getOverridingMethods(ExecutableElement e, CompilationInfo info) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        TypeElement parentType = (TypeElement)e.getEnclosingElement();
        Set subTypes = info.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)parentType), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        for (ElementHandle subTypeHandle : subTypes) {
            TypeElement type = (TypeElement)subTypeHandle.resolve(info);
            for (ExecutableElement method : ElementFilter.methodsIn(type.getEnclosedElements())) {
                if (!info.getElements().overrides(method, e, type)) continue;
                result.add(method);
            }
        }
        return result;
    }

    public static boolean isJavaFile(FileObject f) {
        return JAVA_MIME_TYPE.equals(f.getMIMEType());
    }

    public static String getHtml(String text) {
        StringBuffer buf = new StringBuffer();
        TokenHierarchy tokenH = TokenHierarchy.create((CharSequence)text, (Language)JavaTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)JAVA_MIME_TYPE));
        FontColorSettings settings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tok = tokenH.tokenSequence();
        while (tok.moveNext()) {
            Token token = tok.token();
            String category = ((JavaTokenId)token.id()).primaryCategory();
            if (category == null) {
                category = "whitespace";
            }
            AttributeSet set = settings.getTokenFontColors(category);
            buf.append(RetoucheUtils.color(((Object)token.text()).toString(), set));
        }
        return buf.toString();
    }

    private static String color(String string, AttributeSet set) {
        if (set == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return Utilities.replaceString((String)Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuffer buf = new StringBuffer(string);
        if (StyleConstants.isBold(set)) {
            buf.insert(0, "<b>");
            buf.append("</b>");
        }
        if (StyleConstants.isItalic(set)) {
            buf.insert(0, "<i>");
            buf.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(set)) {
            buf.insert(0, "<s>");
            buf.append("</s>");
        }
        buf.insert(0, "<font color=" + RetoucheUtils.getHTMLColor(StyleConstants.getForeground(set)) + ">");
        buf.append("</font>");
        return buf.toString();
    }

    private static String getHTMLColor(Color c) {
        String colorR = "0" + Integer.toHexString(c.getRed());
        colorR = colorR.substring(colorR.length() - 2);
        String colorG = "0" + Integer.toHexString(c.getGreen());
        colorG = colorG.substring(colorG.length() - 2);
        String colorB = "0" + Integer.toHexString(c.getBlue());
        colorB = colorB.substring(colorB.length() - 2);
        String html_color = "#" + colorR + colorG + colorB;
        return html_color;
    }

    public static boolean isElementInOpenProject(FileObject f) {
        Project p = FileOwnerQuery.getOwner((FileObject)f);
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (p != opened[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isFromLibrary(Element element, ClasspathInfo info) {
        SourceUtils.getFile((Element)element, (ClasspathInfo)info);
        return FileUtil.getArchiveFile((FileObject)SourceUtils.getFile((Element)element, (ClasspathInfo)info)) != null;
    }

    public static boolean isValidPackageName(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileInOpenProject(FileObject file) {
        assert (file != null);
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (p != opened[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        Project[] opened = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < opened.length; ++i) {
            if (p != opened[i]) continue;
            SourceGroup[] gr = ProjectUtils.getSources((Project)p).getSourceGroups("java");
            for (int j = 0; j < gr.length; ++j) {
                if (fo == gr[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)gr[j].getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fo) {
        return fo.equals(ClassPath.getClassPath((FileObject)fo, (String)"classpath/source").findOwnerRoot(fo));
    }

    public static boolean isRefactorable(FileObject file) {
        return RetoucheUtils.isJavaFile(file) && RetoucheUtils.isFileInOpenProject(file) && RetoucheUtils.isOnSourceClasspath(file);
    }

    public static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder, '.', false);
    }

    public static String getPackageName(URL url) {
        File f = null;
        try {
            f = FileUtil.normalizeFile((File)new File(url.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + url);
        }
        String suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) != null) {
                if ("".equals(suffix)) {
                    return RetoucheUtils.getPackageName(fo);
                }
                String prefix = RetoucheUtils.getPackageName(fo);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            suffix = URLDecoder.decode(f.getPath().substring(f.getPath().lastIndexOf(File.separatorChar) + 1)) + suffix;
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }

    public static FileObject getOrCreateFolder(URL url) throws IOException {
        try {
            FileObject result = URLMapper.findFileObject((URL)url);
            if (result != null) {
                return result;
            }
            File f = new File(url.toURI());
            result = FileUtil.createFolder((File)f);
            return result;
        }
        catch (URISyntaxException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
    }

    public static FileObject getClassPathRoot(URL url) throws IOException {
        FileObject result = URLMapper.findFileObject((URL)url);
        File f = FileUtil.normalizeFile((File)new File(url.getPath()));
        while (result == null) {
            result = FileUtil.toFileObject((File)f);
            f = f.getParentFile();
        }
        return ClassPath.getClassPath((FileObject)result, (String)"classpath/source").findOwnerRoot(result);
    }

    public static Collection<Element> getSuperTypes(TypeElement type, CompilationInfo info) {
        HashSet<Element> result = new HashSet<Element>();
        LinkedList<TypeElement> l = new LinkedList<TypeElement>();
        l.add(type);
        while (!l.isEmpty()) {
            TypeElement t = (TypeElement)l.removeFirst();
            TypeElement superClass = RetoucheUtils.typeToElement(t.getSuperclass(), info);
            if (superClass != null) {
                result.add(superClass);
                l.addLast(superClass);
            }
            Collection<TypeElement> interfaces = RetoucheUtils.typesToElements(t.getInterfaces(), info);
            result.addAll(interfaces);
            l.addAll(interfaces);
        }
        return result;
    }

    public static Collection<FileObject> getSuperTypesFiles(TreePathHandle handle) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
            SuperTypesTask ff = new SuperTypesTask(handle);
            source.runUserActionTask((CancellableTask)ff, true);
            return ff.getFileObjects();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static Collection<Element> getSuperTypes(TypeElement type, CompilationInfo info, boolean sourceOnly) {
        if (!sourceOnly) {
            return RetoucheUtils.getSuperTypes(type, info);
        }
        HashSet<Element> result = new HashSet<Element>();
        for (Element el : RetoucheUtils.getSuperTypes(type, info)) {
            FileObject file = SourceUtils.getFile((Element)el, (ClasspathInfo)info.getClasspathInfo());
            if (file == null || !RetoucheUtils.isFileInOpenProject(file) || RetoucheUtils.isFromLibrary(el, info.getClasspathInfo())) continue;
            result.add(el);
        }
        return result;
    }

    public static TypeElement typeToElement(TypeMirror type, CompilationInfo info) {
        return (TypeElement)info.getTypes().asElement(type);
    }

    private static Collection<TypeElement> typesToElements(Collection<? extends TypeMirror> types, CompilationInfo info) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (TypeMirror typeMirror : types) {
            result.add(RetoucheUtils.typeToElement(typeMirror, info));
        }
        return result;
    }

    public static Collection<FileObject> elementsToFile(Collection<Element> elements, ClasspathInfo cpInfo) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        for (Element handle : elements) {
            result.add(SourceUtils.getFile((Element)handle, (ClasspathInfo)cpInfo));
        }
        return result;
    }

    public static boolean elementExistsIn(TypeElement target, Element member, CompilationInfo info) {
        for (Element element : target.getEnclosedElements()) {
            if (info.getElements().hides(member, element)) {
                return true;
            }
            if (!(member instanceof ExecutableElement) || !(element instanceof ExecutableElement) || !info.getElements().overrides((ExecutableElement)member, (ExecutableElement)element, target)) continue;
            return true;
        }
        return false;
    }

    public static ElementHandle getElementHandle(TreePathHandle tph) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            CompilerTask ff = new CompilerTask(tph);
            source.runUserActionTask((CancellableTask)ff, true);
            return ff.getElementHandle();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static ElementKind getElementKind(TreePathHandle tph) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            CompilerTask ff = new CompilerTask(tph);
            source.runUserActionTask((CancellableTask)ff, true);
            return ff.getElementKind();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static String getSimpleName(TreePathHandle tph) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            CompilerTask ff = new CompilerTask(tph);
            source.runUserActionTask((CancellableTask)ff, true);
            return ff.getSimpleName();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static FileObject getFileObject(TreePathHandle handle) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
            CompilerTask ff = new CompilerTask(handle);
            source.runUserActionTask((CancellableTask)ff, true);
            return ff.getFileObject();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static String getQualifiedName(TreePathHandle tph) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            CompilerTask ff = new CompilerTask(tph);
            source.runUserActionTask((CancellableTask)ff, true);
            return ff.getQualifiedName();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static boolean typeExist(TreePathHandle tph, String fqn) {
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)tph.getFileObject());
            CompilerTask ff = new CompilerTask(tph, fqn);
            source.runUserActionTask((CancellableTask)ff, true);
            return ff.typeExist();
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... files) {
        assert (files.length > 0);
        HashSet<URL> dependentRoots = new HashSet<URL>();
        for (FileObject fo : files) {
            Project p = null;
            if (fo != null) {
                p = FileOwnerQuery.getOwner((FileObject)fo);
            }
            if (p != null) {
                URL sourceRoot = URLMapper.findURL((FileObject)ClassPath.getClassPath((FileObject)fo, (String)"classpath/source").findOwnerRoot(fo), (int)0);
                dependentRoots.addAll(SourceUtils.getDependentRoots((URL)sourceRoot));
                continue;
            }
            for (ClassPath cp : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject root : cp.getRoots()) {
                    dependentRoots.add(URLMapper.findURL((FileObject)root, (int)0));
                }
            }
        }
        ClassPath rcp = ClassPathSupport.createClassPath((URL[])dependentRoots.toArray(new URL[dependentRoots.size()]));
        ClassPath nullPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)nullPath, (ClassPath)nullPath, (ClassPath)rcp);
        return cpInfo;
    }

    public static ClasspathInfo getClasspathInfoFor(TreePathHandle handle) {
        return RetoucheUtils.getClasspathInfoFor(RetoucheUtils.getFileObject(handle));
    }

    public static void findUsedGenericTypes(Types utils, List<TypeMirror> typeArgs, List<TypeMirror> result, TypeMirror tm) {
        if (typeArgs.isEmpty()) {
            return;
        }
        if (tm.getKind() == TypeKind.TYPEVAR) {
            int index;
            TypeMirror typeMirror;
            TypeVariable type = (TypeVariable)tm;
            TypeMirror low = type.getLowerBound();
            if (low != null && low.getKind() != TypeKind.NULL) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, low);
            }
            if ((typeMirror = type.getUpperBound()) != null) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
            }
            if ((index = RetoucheUtils.findTypeIndex(utils, typeArgs, type)) >= 0) {
                result.add(typeArgs.remove(index));
            }
        } else if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)tm;
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
            }
        } else if (tm.getKind() == TypeKind.WILDCARD) {
            TypeMirror typeMirror;
            WildcardType type = (WildcardType)tm;
            TypeMirror ex = type.getExtendsBound();
            if (ex != null) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, ex);
            }
            if ((typeMirror = type.getSuperBound()) != null) {
                RetoucheUtils.findUsedGenericTypes(utils, typeArgs, result, typeMirror);
            }
        }
    }

    private static int findTypeIndex(Types utils, List<TypeMirror> typeArgs, TypeMirror type) {
        int i = -1;
        for (TypeMirror typeArg : typeArgs) {
            ++i;
            if (!utils.isSameType(type, typeArg)) continue;
            return i;
        }
        return -1;
    }

    public static List<TypeMirror> resolveTypeParamsAsTypes(List<? extends Element> typeParams) {
        if (typeParams.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeMirror> typeArgs = new ArrayList<TypeMirror>(typeParams.size());
        for (Element element : typeParams) {
            typeArgs.add(element.asType());
        }
        return typeArgs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompilerTask
    implements CancellableTask<CompilationController> {
        private FileObject f;
        private ElementHandle eh;
        private String name;
        private String fqn;
        private String typeToCheck;
        private boolean typeExist;
        private ElementHandle<TypeElement> enclosingTypeHandle;
        private ElementKind kind;
        private IllegalArgumentException iae;
        TreePathHandle handle;

        CompilerTask(TreePathHandle handle) {
            this.handle = handle;
        }

        CompilerTask(TreePathHandle handle, String fqn) {
            this(handle);
            this.typeToCheck = fqn;
        }

        public void cancel() {
        }

        public void run(CompilationController cc) {
            try {
                cc.toPhase(JavaSource.Phase.RESOLVED);
            }
            catch (IOException ex) {
                throw (RuntimeException)new RuntimeException().initCause(ex);
            }
            Element el = this.handle.resolveElement((CompilationInfo)cc);
            this.f = SourceUtils.getFile((Element)el, (ClasspathInfo)cc.getClasspathInfo());
            try {
                this.eh = ElementHandle.create((Element)el);
            }
            catch (IllegalArgumentException iae) {
                this.iae = iae;
            }
            this.name = el.getSimpleName().toString();
            if (el instanceof TypeElement) {
                this.fqn = ((TypeElement)el).getQualifiedName().toString();
            }
            if (this.typeToCheck != null) {
                this.typeExist = cc.getElements().getTypeElement(this.typeToCheck) != null;
            }
            this.enclosingTypeHandle = el instanceof TypeElement ? ElementHandle.create((Element)((TypeElement)el)) : ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)el));
            this.kind = el.getKind();
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public ElementHandle getElementHandle() {
            return this.eh;
        }

        public String getSimpleName() {
            return this.name;
        }

        public String getQualifiedName() {
            return this.fqn;
        }

        public boolean typeExist() {
            return this.typeExist;
        }

        public ElementHandle<TypeElement> getEnclosingTypeHandle() {
            if (this.iae != null) {
                throw this.iae;
            }
            return this.enclosingTypeHandle;
        }

        public ElementKind getElementKind() {
            return this.kind;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuperTypesTask
    implements CancellableTask<CompilationController> {
        private Collection<FileObject> files;
        TreePathHandle handle;

        SuperTypesTask(TreePathHandle handle) {
            this.handle = handle;
        }

        public void cancel() {
        }

        public void run(CompilationController cc) {
            try {
                cc.toPhase(JavaSource.Phase.RESOLVED);
            }
            catch (IOException ex) {
                throw (RuntimeException)new RuntimeException().initCause(ex);
            }
            Element el = this.handle.resolveElement((CompilationInfo)cc);
            this.files = RetoucheUtils.elementsToFile(RetoucheUtils.getSuperTypes((TypeElement)el, (CompilationInfo)cc), cc.getClasspathInfo());
        }

        public Collection<FileObject> getFileObjects() {
            return this.files;
        }
    }
}

