/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;

    public WhereUsedElement(PositionBounds bounds, String displayText, FileObject parentFile, TreePath tp, CompilationInfo info) {
        this.bounds = bounds;
        this.displayText = displayText;
        this.parentFile = parentFile;
        ElementGripFactory.getDefault().put(parentFile, tp, info);
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        ElementGrip composite = ElementGripFactory.getDefault().get(this.parentFile, this.bounds.getBegin().getOffset());
        if (composite == null) {
            composite = this.parentFile;
        }
        return Lookups.singleton((Object)composite);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    public static WhereUsedElement create(CompilationInfo compiler, TreePath tree) {
        CompilationUnitTree unit = tree.getCompilationUnit();
        CharSequence content = null;
        try {
            content = unit.getSourceFile().getCharContent(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        SourcePositions sp = compiler.getTrees().getSourcePositions();
        Tree t = tree.getLeaf();
        int start = (int)sp.getStartPosition(unit, t);
        int end = (int)sp.getEndPosition(unit, t);
        if (end == -1) {
            ErrorManager.getDefault().notify(1, (Throwable)new RuntimeException("Cannot get end position for " + t.getClass().getName() + " " + t + " file:" + compiler.getFileObject().getPath()));
            end = start;
        }
        if (t.getKind() == Tree.Kind.CLASS) {
            end = (start += t.toString().trim().indexOf(((ClassTree)t).getSimpleName().toString())) + ((ClassTree)t).getSimpleName().toString().length();
        }
        if (t.getKind() == Tree.Kind.METHOD) {
            start = start + t.toString().indexOf(((MethodTree)t).getName().toString()) + 1;
            end = start + ((MethodTree)t).getName().toString().length();
        }
        if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
            start = (int)sp.getEndPosition(unit, ((MemberSelectTree)t).getExpression());
        }
        LineMap lm = tree.getCompilationUnit().getLineMap();
        long line = lm.getLineNumber(start);
        long endLine = lm.getLineNumber(end);
        long sta = lm.getStartPosition(line);
        long en = lm.getStartPosition(endLine + 1L) - 1L;
        StringBuffer sb = new StringBuffer();
        sb.append(RetoucheUtils.getHtml(((Object)content.subSequence((int)sta, start)).toString().trim()));
        sb.append(" <b>");
        sb.append(content.subSequence(start, end));
        sb.append("</b> ");
        sb.append(RetoucheUtils.getHtml(((Object)content.subSequence(end, (int)en)).toString().trim()));
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)compiler.getFileObject());
        }
        catch (DataObjectNotFoundException ex) {
            ex.printStackTrace();
        }
        CloneableEditorSupport ces = JavaWhereUsedQueryPlugin.findCloneableEditorSupport(dob);
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        TreePath tr = WhereUsedElement.getEnclosingTree(tree);
        return new WhereUsedElement(bounds, sb.toString().trim(), compiler.getFileObject(), tr, compiler);
    }

    private static TreePath getEnclosingTree(TreePath tp) {
        while (tp != null) {
            Tree tree = tp.getLeaf();
            if (tree.getKind() == Tree.Kind.CLASS || tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.IMPORT) {
                return tp;
            }
            tp = tp.getParentPath();
        }
        return null;
    }
}

