/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.plugins.RetoucheRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractSuperclassRefactoringPlugin
extends RetoucheRefactoringPlugin {
    private final ExtractSuperclassRefactoring refactoring;
    private ElementHandle<TypeElement> classHandle;
    private String pkgName;

    ExtractSuperclassRefactoringPlugin(ExtractSuperclassRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected FileObject getFileObject() {
        return this.refactoring.getSourceType().getFileObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        this.fireProgressListenerStart(1, 2);
        javac.toPhase(JavaSource.Phase.RESOLVED);
        try {
            TreePathHandle sourceType = this.refactoring.getSourceType();
            Problem result = ExtractSuperclassRefactoringPlugin.isElementAvail(sourceType, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (!RetoucheUtils.isElementInOpenProject(sourceType.getFileObject())) {
                Problem problem = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            Element sourceElm = sourceType.resolveElement((CompilationInfo)javac);
            if (sourceElm == null || sourceElm.getKind() != ElementKind.CLASS) {
                Problem problem = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            this.classHandle = ElementHandle.create((Element)((TypeElement)sourceElm));
            PackageElement pkgElm = javac.getElementUtilities().packageElement(sourceElm);
            this.pkgName = pkgElm.getQualifiedName().toString();
            this.fireProgressListenerStep();
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] children;
        Problem result = null;
        String newName = this.refactoring.getSuperClassName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            result = ExtractSuperclassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        FileObject folder = primFile.getParent();
        for (FileObject child : children = folder.getChildren()) {
            if (child.isVirtual() || !child.getName().equals(newName) || !"java".equals(child.getExt())) continue;
            result = ExtractSuperclassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)this.pkgName));
            return result;
        }
        return null;
    }

    @Override
    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Problem checkParameters() {
        ExtractSuperclassRefactoring.MemberInfo[] members = this.refactoring.getMembers();
        if (this.refactoring.getMembers().length == 0) {
            return new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_MembersNotAvailable"));
        }
        return super.checkParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        TypeElement sourceType = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)javac);
        assert (sourceType != null);
        HashSet<? extends Element> members = new HashSet<Element>(sourceType.getEnclosedElements());
        this.fireProgressListenerStart(2, this.refactoring.getMembers().length);
        try {
            for (ExtractSuperclassRefactoring.MemberInfo info : this.refactoring.getMembers()) {
                Problem p = null;
                switch (info.group) {
                    case FIELD: {
                        ElementHandle vehandle = (ElementHandle)info.handle;
                        VariableElement field = (VariableElement)vehandle.resolve((CompilationInfo)javac);
                        p = this.checkFieldParameter(javac, field, members);
                        break;
                    }
                    case METHOD: {
                        ElementHandle eehandle = (ElementHandle)info.handle;
                        ExecutableElement method = (ExecutableElement)eehandle.resolve((CompilationInfo)javac);
                        p = this.checkMethodParameter(javac, method, members);
                    }
                }
                if (p != null) {
                    Problem problem = p;
                    return problem;
                }
                this.fireProgressListenerStep();
            }
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    private Problem checkFieldParameter(CompilationController javac, VariableElement elm, Set<? extends Element> members) throws IOException {
        if (elm == null) {
            return new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
        }
        if (javac.getElementUtilities().isSynthetic((Element)elm) || elm.getKind() != ElementKind.FIELD) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        if (!members.contains(elm)) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        return null;
    }

    private Problem checkMethodParameter(CompilationController javac, ExecutableElement elm, Set<? extends Element> members) throws IOException {
        if (elm == null) {
            return new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
        }
        if (javac.getElementUtilities().isSynthetic((Element)elm) || elm.getKind() != ElementKind.METHOD) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        if (!members.contains(elm)) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        return null;
    }

    @Override
    public Problem prepare(RefactoringElementsBag bag) {
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        try {
            bag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new CreateSuperclassElement(this.refactoring, primFile.getParent(), this.classHandle));
            UpdateClassTask.create(bag, primFile, this.refactoring, this.classHandle);
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
        return null;
    }

    @Override
    protected Problem prepare(WorkingCopy wc, RefactoringElementsBag bag) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    private static List<TypeMirror> findUsedGenericTypes(CompilationInfo javac, TypeElement javaClass, ExtractSuperclassRefactoring refactoring) {
        List<TypeMirror> typeArgs = RetoucheUtils.resolveTypeParamsAsTypes(javaClass.getTypeParameters());
        if (typeArgs.isEmpty()) {
            return typeArgs;
        }
        Types typeUtils = javac.getTypes();
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(typeArgs.size());
        TypeMirror superClass = javaClass.getSuperclass();
        RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, result, superClass);
        ExtractSuperclassRefactoring.MemberInfo[] members = refactoring.getMembers();
        for (int i = 0; i < members.length && !typeArgs.isEmpty(); ++i) {
            ElementHandle handle;
            if (members[i].group == ExtractSuperclassRefactoring.MemberInfo.Group.METHOD) {
                handle = (ElementHandle)members[i].handle;
                ExecutableElement elm = (ExecutableElement)handle.resolve(javac);
                RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, result, elm.getReturnType());
                Iterator<? extends VariableElement> paramIter = elm.getParameters().iterator();
                while (paramIter.hasNext() && !typeArgs.isEmpty()) {
                    VariableElement param = paramIter.next();
                    RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, result, param.asType());
                }
                continue;
            }
            if (members[i].group != ExtractSuperclassRefactoring.MemberInfo.Group.IMPLEMENTS) continue;
            handle = (TypeMirrorHandle)members[i].handle;
            TypeMirror implemetz = handle.resolve(javac);
            RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, result, implemetz);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CreateSuperclassElement
    extends SimpleRefactoringElementImplementation
    implements CancellableTask<WorkingCopy> {
        private final URL folderURL;
        private URL superClassURL;
        private final String superClassName;
        private final ExtractSuperclassRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private CreateSuperclassElement(ExtractSuperclassRefactoring refactoring, FileObject folder, ElementHandle<TypeElement> sourceType) {
            this.refactoring = refactoring;
            this.folderURL = URLMapper.findURL((FileObject)folder, (int)0);
            this.superClassName = refactoring.getSuperClassName();
            this.sourceType = sourceType;
        }

        public void performChange() {
            try {
                FileObject folderFO = URLMapper.findFileObject((URL)this.folderURL);
                if (folderFO == null) {
                    return;
                }
                FileObject tempFO = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Classes/Class.java");
                DataFolder folder = (DataFolder)DataObject.find((FileObject)folderFO);
                DataObject template = DataObject.find((FileObject)tempFO);
                DataObject newSuperClassDO = template.createFromTemplate(folder, this.superClassName);
                this.superClassURL = URLMapper.findURL((FileObject)newSuperClassDO.getPrimaryFile(), (int)0);
                this.refactoring.getContext().add((Object)newSuperClassDO.getPrimaryFile());
                JavaSource js = JavaSource.forFileObject((FileObject)newSuperClassDO.getPrimaryFile());
                js.runModificationTask((CancellableTask)this).commit();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void undoChange() {
            FileObject ifcFO = null;
            if (this.superClassURL != null) {
                ifcFO = URLMapper.findFileObject((URL)this.superClassURL);
            }
            if (ifcFO != null) {
                try {
                    ifcFO.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public String getText() {
            return NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"TXT_ExtractSC_CreateSC", (Object)this.superClassName);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.folderURL);
        }

        public PositionBounds getPosition() {
            return null;
        }

        public Lookup getLookup() {
            FileObject fo = this.superClassURL == null ? null : URLMapper.findFileObject((URL)this.superClassURL);
            return fo != null ? Lookups.singleton((Object)fo) : Lookup.EMPTY;
        }

        public void cancel() {
        }

        public void run(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            ClassTree classTree = CreateSuperclassElement.findClass((CompilationInfo)wc, this.superClassName);
            boolean makeAbstract = false;
            TreeMaker make = wc.getTreeMaker();
            List typeParams = ExtractSuperclassRefactoringPlugin.findUsedGenericTypes((CompilationInfo)wc, (TypeElement)this.sourceType.resolve((CompilationInfo)wc), this.refactoring);
            ArrayList<TypeParameterTree> newTypeParams = new ArrayList<TypeParameterTree>(typeParams.size());
            TypeElement sourceTypeElm = (TypeElement)this.sourceType.resolve((CompilationInfo)wc);
            for (TypeParameterElement typeParameterElement : sourceTypeElm.getTypeParameters()) {
                TypeMirror origParam = typeParameterElement.asType();
                for (TypeMirror newParam : typeParams) {
                    Tree t;
                    if (!wc.getTypes().isSameType(origParam, newParam) || (t = SourceUtils.treeFor((CompilationInfo)wc, (Element)typeParameterElement)).getKind() != Tree.Kind.TYPE_PARAMETER) continue;
                    newTypeParams.add((TypeParameterTree)t);
                }
            }
            ArrayList<? extends Tree> members = new ArrayList<Tree>(classTree.getMembers());
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>();
            arrayList.addAll(classTree.getImplementsClause());
            for (ExtractSuperclassRefactoring.MemberInfo member : this.refactoring.getMembers()) {
                Element elm;
                ElementHandle handle;
                if (member.group == ExtractSuperclassRefactoring.MemberInfo.Group.FIELD) {
                    handle = (ElementHandle)member.handle;
                    elm = (VariableElement)handle.resolve((CompilationInfo)wc);
                    VariableTree tree = (VariableTree)SourceUtils.treeFor((CompilationInfo)wc, (Element)elm);
                    VariableTree copy = make.Variable(make.Modifiers(tree.getModifiers().getFlags(), tree.getModifiers().getAnnotations()), (CharSequence)tree.getName(), tree.getType(), tree.getInitializer());
                    members.add(copy);
                    continue;
                }
                if (member.group == ExtractSuperclassRefactoring.MemberInfo.Group.METHOD) {
                    handle = (ElementHandle)member.handle;
                    elm = (ExecutableElement)handle.resolve((CompilationInfo)wc);
                    MethodTree methodTree = (MethodTree)SourceUtils.treeFor((CompilationInfo)wc, (Element)elm);
                    if (member.makeAbstract && !elm.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        methodTree = make.Method(CreateSuperclassElement.makeAbstract(make, methodTree.getModifiers()), (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), (BlockTree)null, null);
                    }
                    makeAbstract |= methodTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT);
                    members.add(methodTree);
                    continue;
                }
                if (member.group != ExtractSuperclassRefactoring.MemberInfo.Group.IMPLEMENTS) continue;
                handle = (TypeMirrorHandle)member.handle;
                TypeMirror implMirror = handle.resolve((CompilationInfo)wc);
                arrayList.add(make.Type(implMirror));
                makeAbstract |= true;
            }
            Tree superClass = CreateSuperclassElement.makeSuperclass(make, sourceTypeElm);
            ClassTree newClassTree = make.Class(makeAbstract ? CreateSuperclassElement.makeAbstract(make, classTree.getModifiers()) : classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), newTypeParams, superClass, arrayList, members);
            wc.rewrite((Tree)classTree, (Tree)newClassTree);
        }

        private static ClassTree findClass(CompilationInfo javac, String name) {
            for (Tree tree : javac.getCompilationUnit().getTypeDecls()) {
                if (Tree.Kind.CLASS != tree.getKind() || javac.getTreeUtilities().isInterface((ClassTree)tree) || javac.getTreeUtilities().isAnnotation((ClassTree)tree) || javac.getTreeUtilities().isEnum((ClassTree)tree) || !name.contentEquals(((ClassTree)tree).getSimpleName())) continue;
                return (ClassTree)tree;
            }
            throw new IllegalStateException("wrong template, cannot find the class in " + javac.getFileObject());
        }

        private static ModifiersTree makeAbstract(TreeMaker make, ModifiersTree oldMods) {
            if (oldMods.getFlags().contains((Object)Modifier.ABSTRACT)) {
                return oldMods;
            }
            HashSet<Modifier> flags = new HashSet<Modifier>(oldMods.getFlags());
            flags.add(Modifier.ABSTRACT);
            flags.remove((Object)Modifier.FINAL);
            return make.Modifiers(flags, oldMods.getAnnotations());
        }

        private static Tree makeSuperclass(TreeMaker make, TypeElement clazz) {
            DeclaredType supType = (DeclaredType)clazz.getSuperclass();
            TypeElement supEl = (TypeElement)supType.asElement();
            return supEl.getSuperclass().getKind() == TypeKind.NONE ? null : make.Type((TypeMirror)supType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UpdateClassTask
    implements CancellableTask<WorkingCopy> {
        private final ExtractSuperclassRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private UpdateClassTask(ExtractSuperclassRefactoring refactoring, ElementHandle<TypeElement> sourceType) {
            this.sourceType = sourceType;
            this.refactoring = refactoring;
        }

        public static void create(RefactoringElementsBag bag, FileObject fo, ExtractSuperclassRefactoring refactoring, ElementHandle<TypeElement> sourceType) throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            ModificationResult modification = js.runModificationTask((CancellableTask)new UpdateClassTask(refactoring, sourceType));
            List diffs = modification.getDifferences(fo);
            for (ModificationResult.Difference diff : diffs) {
                bag.add((AbstractRefactoring)refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modification));
            }
            bag.registerTransaction((Transaction)new RetoucheCommit(Collections.singletonList(modification)));
        }

        public void cancel() {
        }

        public void run(WorkingCopy wc) throws Exception {
            Tree superClassTree;
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TypeElement clazz = (TypeElement)this.sourceType.resolve((CompilationInfo)wc);
            assert (clazz != null);
            ClassTree classTree = wc.getTrees().getTree(clazz);
            TreeMaker make = wc.getTreeMaker();
            List typeParams = ExtractSuperclassRefactoringPlugin.findUsedGenericTypes((CompilationInfo)wc, clazz, this.refactoring);
            if (typeParams.isEmpty()) {
                superClassTree = make.Identifier((CharSequence)this.refactoring.getSuperClassName());
            } else {
                ArrayList<ExpressionTree> typeParamTrees = new ArrayList<ExpressionTree>(typeParams.size());
                for (TypeMirror typeParam : typeParams) {
                    Tree t = make.Type(typeParam);
                    typeParamTrees.add((ExpressionTree)t);
                }
                superClassTree = make.ParameterizedType((Tree)make.Identifier((CharSequence)this.refactoring.getSuperClassName()), typeParamTrees);
            }
            HashSet<Tree> members2Remove = new HashSet<Tree>();
            HashSet<Tree> interfaces2Remove = new HashSet<Tree>();
            members2Remove.addAll(this.getMembers2Remove((CompilationInfo)wc, this.refactoring.getMembers()));
            interfaces2Remove.addAll(this.getImplements2Remove((CompilationInfo)wc, this.refactoring.getMembers(), clazz));
            ArrayList<Tree> members2Add = new ArrayList<Tree>();
            for (Tree tree : classTree.getMembers()) {
                if (members2Remove.contains(tree)) continue;
                members2Add.add(tree);
            }
            List<Tree> impls2Add = UpdateClassTask.resolveImplements(classTree.getImplementsClause(), interfaces2Remove);
            ClassTree classTree2 = make.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), superClassTree, impls2Add, members2Add);
            wc.rewrite((Tree)classTree, (Tree)classTree2);
        }

        private List<Tree> getMembers2Remove(CompilationInfo javac, ExtractSuperclassRefactoring.MemberInfo[] members) {
            if (members == null || members.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<Tree> result = new ArrayList<Tree>(members.length);
            for (ExtractSuperclassRefactoring.MemberInfo member : members) {
                Tree t;
                Element elm;
                ElementHandle handle;
                if (member.group == ExtractSuperclassRefactoring.MemberInfo.Group.FIELD) {
                    handle = (ElementHandle)member.handle;
                    elm = (VariableElement)handle.resolve(javac);
                    assert (elm != null);
                    t = javac.getTrees().getTree(elm);
                    assert (t != null);
                    result.add(t);
                    continue;
                }
                if (member.group != ExtractSuperclassRefactoring.MemberInfo.Group.METHOD || member.makeAbstract) continue;
                handle = (ElementHandle)member.handle;
                elm = (ExecutableElement)handle.resolve(javac);
                assert (elm != null);
                t = javac.getTrees().getTree((ExecutableElement)elm);
                assert (t != null);
                result.add(t);
            }
            return result;
        }

        private List<Tree> getImplements2Remove(CompilationInfo javac, ExtractSuperclassRefactoring.MemberInfo[] members, TypeElement clazz) {
            if (members == null || members.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<TypeMirror> memberTypes = new ArrayList<TypeMirror>(members.length);
            for (ExtractSuperclassRefactoring.MemberInfo member : members) {
                if (member.group != ExtractSuperclassRefactoring.MemberInfo.Group.IMPLEMENTS) continue;
                TypeMirrorHandle typeMirrorHandle = (TypeMirrorHandle)member.handle;
                TypeMirror tm = typeMirrorHandle.resolve(javac);
                memberTypes.add(tm);
            }
            ClassTree classTree = javac.getTrees().getTree(clazz);
            ArrayList<Tree> result = new ArrayList<Tree>();
            Types types = javac.getTypes();
            block1: for (Tree tree : classTree.getImplementsClause()) {
                TreePath path = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                TypeMirror existingTM = javac.getTrees().getTypeMirror(path);
                for (TypeMirror tm : memberTypes) {
                    if (!types.isSameType(tm, existingTM)) continue;
                    result.add(tree);
                    continue block1;
                }
            }
            return result;
        }

        private static List<Tree> resolveImplements(List<? extends Tree> allImpls, Set<Tree> impls2Remove) {
            ArrayList<Tree> ret;
            if (allImpls == null) {
                ret = new ArrayList<Tree>(1);
            } else {
                ret = new ArrayList(allImpls.size() + 1);
                ret.addAll(allImpls);
            }
            if (impls2Remove != null && !impls2Remove.isEmpty()) {
                ret.removeAll(impls2Remove);
            }
            return ret;
        }
    }
}

