/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.java.plugins.CopyClassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractSuperclassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PullUpRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PushDownRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.SafeDeleteRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.UseSuperTypeRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class JavaRefactoringsFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        Lookup look = refactoring.getRefactoringSource();
        FileObject file = (FileObject)look.lookup(FileObject.class);
        NonRecursiveFolder folder = (NonRecursiveFolder)look.lookup(NonRecursiveFolder.class);
        TreePathHandle handle = (TreePathHandle)look.lookup(TreePathHandle.class);
        if (refactoring instanceof WhereUsedQuery) {
            if (handle != null) {
                return new JavaWhereUsedQueryPlugin((WhereUsedQuery)refactoring);
            }
        } else if (refactoring instanceof RenameRefactoring) {
            if (handle != null || file != null && RetoucheUtils.isJavaFile(file)) {
                return new RenameRefactoringPlugin((RenameRefactoring)refactoring);
            }
            if (file != null && RetoucheUtils.isOnSourceClasspath(file) && file.isFolder()) {
                return new MoveRefactoringPlugin((RenameRefactoring)refactoring);
            }
            if (folder != null && RetoucheUtils.isOnSourceClasspath(folder.getFolder())) {
                return new MoveRefactoringPlugin((RenameRefactoring)refactoring);
            }
        } else if (refactoring instanceof SafeDeleteRefactoring) {
            if (this.checkSafeDelete(refactoring.getRefactoringSource())) {
                return new SafeDeleteRefactoringPlugin((SafeDeleteRefactoring)refactoring);
            }
        } else {
            if (refactoring instanceof MoveRefactoring) {
                return new MoveRefactoringPlugin((MoveRefactoring)refactoring);
            }
            if (refactoring instanceof SingleCopyRefactoring) {
                return new CopyClassRefactoringPlugin((SingleCopyRefactoring)refactoring);
            }
            if (refactoring instanceof ExtractInterfaceRefactoring) {
                return new ExtractInterfaceRefactoringPlugin((ExtractInterfaceRefactoring)refactoring);
            }
            if (refactoring instanceof ExtractSuperclassRefactoring) {
                return new ExtractSuperclassRefactoringPlugin((ExtractSuperclassRefactoring)refactoring);
            }
            if (refactoring instanceof PullUpRefactoring) {
                return new PullUpRefactoringPlugin((PullUpRefactoring)refactoring);
            }
            if (refactoring instanceof PushDownRefactoring) {
                return new PushDownRefactoringPlugin((PushDownRefactoring)refactoring);
            }
            if (refactoring instanceof UseSuperTypeRefactoring) {
                return new UseSuperTypeRefactoringPlugin((UseSuperTypeRefactoring)refactoring);
            }
        }
        return null;
    }

    private boolean checkSafeDelete(Lookup object) {
        boolean a = false;
        for (FileObject f : object.lookupAll(FileObject.class)) {
            a = true;
            if (RetoucheUtils.isJavaFile(f)) continue;
            return false;
        }
        if (object.lookup(TreePathHandle.class) != null) {
            return true;
        }
        return a;
    }
}

