/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveRefactoringPlugin
extends JavaRefactoringPlugin {
    private Map packagePostfix = new HashMap();
    private AbstractRefactoring refactoring;
    ArrayList<FileObject> filesToMove = new ArrayList();
    HashMap<FileObject, ElementHandle> classes;
    Map<FileObject, Set<FileObject>> whoReferences = new HashMap<FileObject, Set<FileObject>>();
    private FileObject[] origFilesToMove;

    public MoveRefactoringPlugin(MoveRefactoring move) {
        this.refactoring = move;
        this.setup(move.getRefactoringSource().lookupAll(FileObject.class), "", true);
    }

    public MoveRefactoringPlugin(RenameRefactoring rename) {
        this.refactoring = rename;
        FileObject fo = (FileObject)rename.getRefactoringSource().lookup(FileObject.class);
        if (fo != null) {
            this.setup(Collections.singletonList(fo), "", true);
        } else {
            this.setup(Collections.singletonList(((NonRecursiveFolder)rename.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder()), "", false);
        }
    }

    public Problem preCheck() {
        Problem preCheckProblem = null;
        for (FileObject file : this.filesToMove) {
            if (RetoucheUtils.isElementInOpenProject(file)) continue;
            preCheckProblem = MoveRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
        }
        return preCheckProblem;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.refactoring instanceof RenameRefactoring) {
            FileObject f = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            if (f != null) {
                String newName = ((RenameRefactoring)this.refactoring).getNewName();
                if (!RetoucheUtils.isValidPackageName(newName)) {
                    String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{newName});
                    return new Problem(true, msg);
                }
                if (f.getParent().getFileObject(newName, f.getExt()) != null) {
                    String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_PackageExists")).format(new Object[]{newName});
                    return new Problem(true, msg);
                }
            }
            return null;
        }
        if (this.refactoring instanceof MoveRefactoring) {
            try {
                for (FileObject f : this.filesToMove) {
                    if (!RetoucheUtils.isJavaFile(f)) continue;
                    String targetPackageName = this.getTargetPackageName(f);
                    if (!RetoucheUtils.isValidPackageName(targetPackageName)) {
                        String s = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage");
                        String msg = new MessageFormat(s).format(new Object[]{targetPackageName});
                        return new Problem(true, msg);
                    }
                    FileObject targetRoot = RetoucheUtils.getClassPathRoot((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
                    FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
                    String pkgName = null;
                    if (targetF != null && !targetF.canWrite()) {
                        return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_PackageIsReadOnly")).format(new Object[]{targetPackageName}));
                    }
                    pkgName = targetPackageName;
                    if (pkgName == null) {
                        pkgName = "";
                    } else if (pkgName.length() > 0) {
                        pkgName = pkgName + '.';
                    }
                    String fileName = f.getName();
                    if (targetF == null) continue;
                    FileObject[] children = targetF.getChildren();
                    for (int x = 0; x < children.length; ++x) {
                        if (!children[x].getName().equals(fileName) || !"java".equals(children[x].getExt()) || children[x].equals(f) || children[x].isVirtual()) continue;
                        return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{fileName}));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        ClassIndex idx = cpInfo.getClassIndex();
        HashSet<FileObject> set = new HashSet<FileObject>();
        for (Map.Entry<FileObject, ElementHandle> entry : this.classes.entrySet()) {
            Set files = idx.getResources(entry.getValue(), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            set.addAll(files);
            this.whoReferences.put(entry.getKey(), files);
        }
        set.addAll(this.filesToMove);
        return set;
    }

    private void initClasses() {
        this.classes = new HashMap();
        for (int i = 0; i < this.filesToMove.size(); ++i) {
            final int j = i;
            try {
                JavaSource source = JavaSource.forFileObject((FileObject)this.filesToMove.get(i));
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List<? extends Tree> trees = parameter.getCompilationUnit().getTypeDecls();
                        for (Tree tree : trees) {
                            if (tree.getKind() != Tree.Kind.CLASS || !((ClassTree)tree).getSimpleName().toString().equals(MoveRefactoringPlugin.this.filesToMove.get(j).getName())) continue;
                            MoveRefactoringPlugin.this.classes.put(MoveRefactoringPlugin.this.filesToMove.get(j), ElementHandle.create((Element)parameter.getTrees().getElement(TreePath.getPath(parameter.getCompilationUnit(), tree))));
                            return;
                        }
                    }
                }, true);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public Problem prepare(RefactoringElementsBag elements) {
        this.initClasses();
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(1, a.size());
        if (!a.isEmpty()) {
            Collection<ModificationResult> results = this.processFiles(a, new UpdateReferences());
            elements.registerTransaction((Transaction)new RetoucheCommit(results));
            for (ModificationResult result : results) {
                for (FileObject jfo : result.getModifiedFileObjects()) {
                    for (ModificationResult.Difference dif : result.getDifferences(jfo)) {
                        elements.add(this.refactoring, (RefactoringElementImplementation)DiffElement.create(dif, jfo, result));
                    }
                }
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    String getNewPackageName() {
        if (this.refactoring instanceof MoveRefactoring) {
            return RetoucheUtils.getPackageName((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
        }
        return ((RenameRefactoring)this.refactoring).getNewName();
    }

    String getTargetPackageName(FileObject fo) {
        if (this.refactoring instanceof RenameRefactoring) {
            if (this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
                return this.getNewPackageName();
            }
            FileObject folder = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
            FileObject root = cp.findOwnerRoot(folder);
            String prefix = FileUtil.getRelativePath((FileObject)root, (FileObject)folder.getParent()).replace('/', '.');
            String postfix = FileUtil.getRelativePath((FileObject)folder, (FileObject)fo.getParent()).replace('/', '.');
            String t = this.concat(prefix, this.getNewPackageName(), postfix);
            return t;
        }
        if (this.packagePostfix != null) {
            String postfix = (String)this.packagePostfix.get(fo);
            String packageName = this.concat(null, this.getNewPackageName(), postfix);
            return packageName;
        }
        return this.getNewPackageName();
    }

    private void setup(Collection fileObjects, String postfix, boolean recursively) {
        for (FileObject fo : fileObjects) {
            if (RetoucheUtils.isJavaFile(fo)) {
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                this.filesToMove.add(fo);
                continue;
            }
            if (!fo.isFolder()) {
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fo)) continue;
            boolean addDot = !"".equals(postfix);
            ArrayList<FileObject> col = new ArrayList<FileObject>();
            for (FileObject fo2 : fo.getChildren()) {
                if (fo2.isFolder() && (!fo2.isFolder() || !recursively)) continue;
                col.add(fo2);
            }
            this.setup(col, postfix + (addDot ? "." : "") + fo.getName(), recursively);
        }
    }

    private String concat(String s1, String s2, String s3) {
        String result = "";
        if (s1 != null && !"".equals(s1)) {
            result = result + s1 + ".";
        }
        result = result + s2;
        if (s3 != null && !"".equals(s3)) {
            result = result + ("".equals(result) ? "" : ".") + s3;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateReferences
    implements CancellableTask<WorkingCopy> {
        public void cancel() {
        }

        public void run(WorkingCopy compiler) throws IOException {
            compiler.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            MoveTransformer findVisitor = new MoveTransformer(compiler, MoveRefactoringPlugin.this);
            findVisitor.scan(compiler.getCompilationUnit(), null);
            for (TreePath tree : findVisitor.getUsages()) {
                ElementGripFactory.getDefault().put(compiler.getFileObject(), tree, (CompilationInfo)compiler);
            }
            MoveRefactoringPlugin.this.fireProgressListenerStep();
        }
    }
}

