/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.SearchVisitor;
import org.openide.filesystems.FileObject;

public class MoveTransformer
extends SearchVisitor {
    private FileObject originalFolder;
    private MoveRefactoringPlugin move;
    private Set<Element> elementsToImport = new HashSet<Element>();
    private boolean isThisFileMoving;
    private boolean isThisFileReferencingOldPackage = false;
    private Set<Element> elementsAlreadyImported = new HashSet<Element>();
    private int index;

    public MoveTransformer(WorkingCopy workingCopy, MoveRefactoringPlugin move) {
        super(workingCopy);
        this.originalFolder = workingCopy.getFileObject().getParent();
        this.move = move;
        this.isThisFileMoving = move.filesToMove.contains(workingCopy.getFileObject());
    }

    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        Element el;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null && this.isElementMoving(el)) {
            this.elementsAlreadyImported.add(el);
            MemberSelectTree nju = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.move.getTargetPackageName(this.move.filesToMove.get(this.index))), el);
            this.workingCopy.rewrite((Tree)node, (Tree)nju);
        }
        return (Tree)super.visitMemberSelect(node, p);
    }

    public Tree visitIdentifier(IdentifierTree node, Element p) {
        Element el;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            if (!this.isThisFileMoving) {
                if (this.isElementMoving(el) && !this.elementsAlreadyImported.contains(el)) {
                    this.elementsToImport.add(el);
                }
            } else if (!this.isThisFileReferencingOldPackage && !this.isElementMoving(el) && this.isTopLevelClass(el) && this.getPackageOf(el).toString().equals(RetoucheUtils.getPackageName(this.workingCopy.getFileObject().getParent()))) {
                this.isThisFileReferencingOldPackage = true;
            }
        }
        return (Tree)super.visitIdentifier(node, p);
    }

    private PackageElement getPackageOf(Element el) {
        while (el.getKind() != ElementKind.PACKAGE) {
            el = el.getEnclosingElement();
        }
        return (PackageElement)el;
    }

    private boolean isThisFileReferencedbyOldPackage() {
        HashSet references = new HashSet(this.move.whoReferences.get(this.workingCopy.getFileObject()));
        references.removeAll(this.move.filesToMove);
        for (FileObject file : references) {
            if (!file.getParent().equals(this.originalFolder)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementMoving(Element el) {
        this.index = 0;
        for (ElementHandle handle : this.move.classes.values()) {
            if (handle.signatureEquals(el)) {
                return true;
            }
            ++this.index;
        }
        this.index = -1;
        return false;
    }

    private boolean isTopLevelClass(Element el) {
        return (el.getKind().isClass() || el.getKind().isInterface()) && el.getEnclosingElement().getKind() == ElementKind.PACKAGE;
    }

    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        Tree result = (Tree)super.visitCompilationUnit(node, p);
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return result;
        }
        if (this.isThisFileMoving) {
            String newPckg = this.move.getTargetPackageName(this.workingCopy.getFileObject());
            if (node.getPackageName() != null && !"".equals(newPckg)) {
                this.workingCopy.rewrite((Tree)node.getPackageName(), (Tree)this.make.Identifier((CharSequence)this.move.getTargetPackageName(this.workingCopy.getFileObject())));
            } else {
                CompilationUnitTree copy = this.make.CompilationUnit((ExpressionTree)("".equals(newPckg) ? null : this.make.Identifier((CharSequence)newPckg)), node.getImports(), node.getTypeDecls(), node.getSourceFile());
                this.workingCopy.rewrite((Tree)node, (Tree)copy);
            }
            if (this.isThisFileReferencingOldPackage) {
                node = this.insertImport(node, node.getPackageName().toString() + ".*");
            }
        }
        for (Element el : this.elementsToImport) {
            FileObject fo = SourceUtils.getFile((Element)el, (ClasspathInfo)this.workingCopy.getClasspathInfo());
            node = this.insertImport(node, this.move.getTargetPackageName(fo) + "." + el.getSimpleName());
        }
        return result;
    }

    private CompilationUnitTree insertImport(CompilationUnitTree node, String imp) {
        for (ImportTree importTree : node.getImports()) {
            if (!importTree.getQualifiedIdentifier().toString().equals(imp)) continue;
            return node;
        }
        CompilationUnitTree nju = this.make.insertCompUnitImport(node, 0, this.make.Import((Tree)this.make.Identifier((CharSequence)imp), false));
        this.workingCopy.rewrite((Tree)node, (Tree)nju);
        return nju;
    }
}

