/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PullUpTransformer;
import org.netbeans.modules.refactoring.java.plugins.PushDownRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PullUpRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PullUpRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private Problem problem;

    PullUpRefactoringPlugin(PullUpRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = refactoring.getSourceType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        JavaSource source = JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
        this.fireProgressListenerStart(1, 4);
        this.problem = null;
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void run(CompilationController cc) throws Exception {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                PullUpRefactoringPlugin.this.problem = JavaRefactoringPlugin.isElementAvail(PullUpRefactoringPlugin.this.treePathHandle, (CompilationInfo)cc);
                if (PullUpRefactoringPlugin.this.problem != null) {
                    return;
                }
                if (!RetoucheUtils.isElementInOpenProject(PullUpRefactoringPlugin.this.treePathHandle.getFileObject())) {
                    PullUpRefactoringPlugin.this.problem = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                    return;
                }
                PullUpRefactoringPlugin.this.fireProgressListenerStep();
                TypeElement e = (TypeElement)PullUpRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)cc);
                if (RetoucheUtils.getSuperTypes(e, (CompilationInfo)cc, true).isEmpty()) {
                    PullUpRefactoringPlugin.this.problem = new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoSuperTypes"));
                    return;
                }
                PullUpRefactoringPlugin.this.fireProgressListenerStep();
                Element el = PullUpRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)cc);
                for (Element element : el.getEnclosedElements()) {
                    if (element.getKind() == ElementKind.CONSTRUCTOR) continue;
                    return;
                }
                PullUpRefactoringPlugin.this.problem = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembers"));
                PullUpRefactoringPlugin.this.fireProgressListenerStep();
            }
        };
        try {
            source.runUserActionTask((CancellableTask)task, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return this.problem;
    }

    public Problem fastCheckParameters() {
        MemberInfo[] info = this.refactoring.getMembers();
        if (info.length == 0) {
            return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembersSelected"));
        }
        if (info.length > 1) {
            for (int i = 0; i < info.length - 1; ++i) {
                for (int j = i + 1; j < info.length; ++j) {
                    if (!info[i].equals(info[j])) continue;
                    return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_CannotPullupDuplicateMembers"));
                }
            }
        }
        if (this.refactoring.getTargetType() == null) {
            return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoTargetType"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem checkParameters() {
        JavaSource source = JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
        this.fireProgressListenerStart(1, 4);
        this.problem = null;
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void run(CompilationController cc) throws Exception {
                TypeElement sourceType = (TypeElement)PullUpRefactoringPlugin.this.refactoring.getSourceType().resolveElement((CompilationInfo)cc);
                Collection<Element> supers = RetoucheUtils.getSuperTypes(sourceType, (CompilationInfo)cc);
                TypeElement targetType = (TypeElement)PullUpRefactoringPlugin.this.refactoring.getTargetType().resolve((CompilationInfo)cc);
                MemberInfo[] members = PullUpRefactoringPlugin.this.refactoring.getMembers();
                PullUpRefactoringPlugin.this.fireProgressListenerStart(2, members.length + 1);
                if (!supers.contains(targetType)) {
                    PullUpRefactoringPlugin.this.problem = new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_IllegalTargetType"));
                    return;
                }
                PullUpRefactoringPlugin.this.fireProgressListenerStep();
                Problem problems = null;
                for (int i = 0; i < members.length; ++i) {
                    Element member = members[i].getElementHandle().resolve((CompilationInfo)cc);
                    if (members[i].getType() != 0) continue;
                    if (RetoucheUtils.elementExistsIn(targetType, member, (CompilationInfo)cc)) {
                        PullUpRefactoringPlugin.this.problem = JavaRefactoringPlugin.createProblem(problems, true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_MemberAlreadyExists", (Object)member.getSimpleName()));
                        return;
                    }
                    PullUpRefactoringPlugin.this.fireProgressListenerStep();
                }
            }
        };
        try {
            source.runUserActionTask((CancellableTask)task, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return this.problem;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        HashSet<FileObject> a = new HashSet<FileObject>();
        a.addAll(RetoucheUtils.getSuperTypesFiles(this.refactoring.getSourceType()));
        a.add(RetoucheUtils.getFileObject(this.treePathHandle));
        this.fireProgressListenerStart(1, a.size());
        if (!a.isEmpty()) {
            Collection<ModificationResult> results = this.processFiles(a, new FindTask(refactoringElements));
            refactoringElements.registerTransaction((Transaction)new RetoucheCommit(results));
            for (ModificationResult result : results) {
                for (FileObject jfo : result.getModifiedFileObjects()) {
                    for (ModificationResult.Difference dif : result.getDifferences(jfo)) {
                        String old = dif.getOldText();
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(dif, jfo, result));
                    }
                }
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;

        public FindTask(RefactoringElementsBag elements) {
            this.elements = elements;
        }

        public void cancel() {
        }

        public void run(WorkingCopy compiler) throws IOException {
            compiler.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            Element el = PullUpRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)compiler);
            if (el == null) {
                return;
            }
            PullUpTransformer findVisitor = new PullUpTransformer(compiler, PullUpRefactoringPlugin.this.refactoring.getMembers(), PullUpRefactoringPlugin.this.refactoring.getSourceType().resolveElement((CompilationInfo)compiler), PullUpRefactoringPlugin.this.refactoring.getTargetType().resolve((CompilationInfo)compiler));
            findVisitor.scan(compiler.getCompilationUnit(), el);
            for (TreePath tree : findVisitor.getUsages()) {
                ElementGripFactory.getDefault().put(compiler.getFileObject(), tree, (CompilationInfo)compiler);
            }
            PullUpRefactoringPlugin.this.fireProgressListenerStep();
        }
    }
}

