/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RenameTransformer;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameRefactoringPlugin
extends JavaRefactoringPlugin {
    private TreePathHandle treePathHandle = null;
    private Collection overriddenByMethods = null;
    private Collection overridesMethods = null;
    private boolean doCheckName = true;
    private FileObject originalFolder = null;
    private Set varNames;
    private RenameRefactoring refactoring;
    private Problem preCheckProblem;
    private Problem checkProblem;
    private Set<ElementHandle<ExecutableElement>> allMethods;

    public RenameRefactoringPlugin(RenameRefactoring rename) {
        this.refactoring = rename;
        TreePathHandle tph = (TreePathHandle)rename.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph != null) {
            this.treePathHandle = tph;
        } else {
            JavaSource source = JavaSource.forFileObject((FileObject)((FileObject)rename.getRefactoringSource().lookup(FileObject.class)));
            try {
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController co) throws Exception {
                        co.toPhase(JavaSource.Phase.RESOLVED);
                        CompilationUnitTree cut = co.getCompilationUnit();
                        for (Tree tree : cut.getTypeDecls()) {
                            Element e = co.getTrees().getElement(TreePath.getPath(cut, tree));
                            if (!e.getSimpleName().toString().equals(co.getFileObject().getName())) continue;
                            RenameRefactoringPlugin.this.treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(cut, tree), (CompilationInfo)co);
                            RenameRefactoringPlugin.this.refactoring.getContext().add((Object)co);
                            break;
                        }
                    }
                }, false);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Problem preCheck() {
        if (this.treePathHandle == null) {
            return null;
        }
        this.preCheckProblem = null;
        ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
        this.fireProgressListenerStart(1, 4);
        try {
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    Element el = RenameRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)info);
                    RenameRefactoringPlugin.this.preCheckProblem = JavaRefactoringPlugin.isElementAvail(RenameRefactoringPlugin.this.treePathHandle, (CompilationInfo)info);
                    if (RenameRefactoringPlugin.this.preCheckProblem != null) {
                        return;
                    }
                    FileObject file = SourceUtils.getFile((Element)el, (ClasspathInfo)info.getClasspathInfo());
                    if (FileUtil.getArchiveFile((FileObject)file) != null) {
                        RenameRefactoringPlugin.this.preCheckProblem = JavaRefactoringPlugin.createProblem(RenameRefactoringPlugin.this.preCheckProblem, true, RenameRefactoringPlugin.getCannotRename(file));
                        return;
                    }
                    if (!RetoucheUtils.isElementInOpenProject(file)) {
                        RenameRefactoringPlugin.this.preCheckProblem = new Problem(true, NbBundle.getMessage(JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                        return;
                    }
                    switch (el.getKind()) {
                        case METHOD: {
                            RenameRefactoringPlugin.this.fireProgressListenerStep();
                            RenameRefactoringPlugin.this.fireProgressListenerStep();
                            RenameRefactoringPlugin.this.overriddenByMethods = RetoucheUtils.getOverridingMethods((ExecutableElement)el, (CompilationInfo)info);
                            RenameRefactoringPlugin.this.fireProgressListenerStep();
                            if (!RenameRefactoringPlugin.this.overriddenByMethods.isEmpty()) {
                                String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_IsOverridden")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)el).getSimpleName().toString()});
                                RenameRefactoringPlugin.this.preCheckProblem = JavaRefactoringPlugin.createProblem(RenameRefactoringPlugin.this.preCheckProblem, false, msg);
                            }
                            RenameRefactoringPlugin.this.overridesMethods = RetoucheUtils.getOverridenMethods((ExecutableElement)el, (CompilationInfo)info);
                            RenameRefactoringPlugin.this.fireProgressListenerStep();
                            if (RenameRefactoringPlugin.this.overridesMethods.isEmpty()) break;
                            boolean fatal = false;
                            for (ExecutableElement method : RenameRefactoringPlugin.this.overridesMethods) {
                                if (!RetoucheUtils.isFromLibrary(method, info.getClasspathInfo())) continue;
                                fatal = true;
                                break;
                            }
                            String msg = fatal ? RenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : RenameRefactoringPlugin.getString("ERR_Overrides");
                            RenameRefactoringPlugin.this.preCheckProblem = JavaRefactoringPlugin.createProblem(RenameRefactoringPlugin.this.preCheckProblem, fatal, msg);
                            break;
                        }
                        case FIELD: 
                        case ENUM_CONSTANT: {
                            RenameRefactoringPlugin.this.fireProgressListenerStep();
                            RenameRefactoringPlugin.this.fireProgressListenerStep();
                            Element hiddenField = RenameRefactoringPlugin.this.hides(el, el.getSimpleName().toString(), (CompilationInfo)info);
                            RenameRefactoringPlugin.this.fireProgressListenerStep();
                            RenameRefactoringPlugin.this.fireProgressListenerStep();
                            if (hiddenField == null) break;
                            String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_Hides")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)el)});
                            RenameRefactoringPlugin.this.preCheckProblem = JavaRefactoringPlugin.createProblem(RenameRefactoringPlugin.this.preCheckProblem, false, msg);
                            break;
                        }
                        case PACKAGE: {
                            break;
                        }
                        case LOCAL_VARIABLE: {
                            break;
                        }
                        case CLASS: 
                        case INTERFACE: 
                        case ANNOTATION_TYPE: 
                        case ENUM: {
                            break;
                        }
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return this.preCheckProblem;
    }

    private static final String getCannotRename(FileObject r) {
        return new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_CannotRenameFile")).format(new Object[]{r.getNameExt()});
    }

    public Problem fastCheckParameters() {
        if (this.treePathHandle == null) {
            return null;
        }
        ElementKind kind = RetoucheUtils.getElementKind(this.treePathHandle);
        String newName = this.refactoring.getNewName();
        Problem result = null;
        String oldName = RetoucheUtils.getSimpleName(this.treePathHandle);
        if (oldName.equals(newName)) {
            boolean nameNotChanged = true;
            if (kind.isClass()) {
                // empty if block
            }
            if (nameNotChanged) {
                return RenameRefactoringPlugin.createProblem(result, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            }
        }
        if (!Utilities.isJavaIdentifier((String)newName)) {
            String s = kind == ElementKind.PACKAGE ? RenameRefactoringPlugin.getString("ERR_InvalidPackage") : RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String msg = new MessageFormat(s).format(new Object[]{newName});
            result = RenameRefactoringPlugin.createProblem(result, true, msg);
            return result;
        }
        if (kind.isClass()) {
            if (this.doCheckName) {
                String oldfqn = RetoucheUtils.getQualifiedName(this.treePathHandle);
                String newFqn = oldfqn.substring(0, oldfqn.lastIndexOf(oldName));
                String pkgname = oldfqn;
                int i = pkgname.indexOf(46);
                pkgname = i >= 0 ? pkgname.substring(0, i) : "";
                String fqn = "".equals(pkgname) ? newName : pkgname + '.' + newName;
                FileObject fo = this.treePathHandle.getFileObject();
                ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
                if (RetoucheUtils.typeExist(this.treePathHandle, newFqn)) {
                    String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{newName, pkgname});
                    return RenameRefactoringPlugin.createProblem(result, true, msg);
                }
            }
            FileObject primFile = this.treePathHandle.getFileObject();
            FileObject folder = primFile.getParent();
            FileObject[] children = folder.getChildren();
            for (int x = 0; x < children.length; ++x) {
                if (children[x] == primFile || children[x].isVirtual() || !children[x].getName().equals(newName) || !"java".equals(children[x].getExt())) continue;
                String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{newName, folder.getPath()});
                result = RenameRefactoringPlugin.createProblem(result, true, msg);
                break;
            }
            if (kind == ElementKind.LOCAL_VARIABLE || kind == ElementKind.PARAMETER) {
                // empty if block
            }
            if (!kind.isField()) {
                if (kind == ElementKind.METHOD) {
                    // empty if block
                }
            }
        }
        return result;
    }

    public Problem checkParameters() {
        if (this.treePathHandle == null) {
            return null;
        }
        this.checkProblem = null;
        int steps = 0;
        if (this.overriddenByMethods != null) {
            steps += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            steps += this.overridesMethods.size();
        }
        this.fireProgressListenerStart(2, 8 + 3 * steps);
        ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
        try {
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    Element element = RenameRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)info);
                    Problem result = null;
                    RenameRefactoringPlugin.this.fireProgressListenerStep();
                    RenameRefactoringPlugin.this.fireProgressListenerStep();
                    if (element.getKind() == ElementKind.METHOD) {
                        RenameRefactoringPlugin.this.fireProgressListenerStep();
                        RenameRefactoringPlugin.this.fireProgressListenerStep();
                    } else if (element.getKind().isField()) {
                        RenameRefactoringPlugin.this.fireProgressListenerStep();
                        RenameRefactoringPlugin.this.fireProgressListenerStep();
                        Element hiddenField = RenameRefactoringPlugin.this.hides(element, RenameRefactoringPlugin.this.refactoring.getNewName(), (CompilationInfo)info);
                        RenameRefactoringPlugin.this.fireProgressListenerStep();
                        RenameRefactoringPlugin.this.fireProgressListenerStep();
                        RenameRefactoringPlugin.this.fireProgressListenerStep();
                        if (hiddenField != null) {
                            String msg = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillHide")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)element).toString()});
                            result = JavaRefactoringPlugin.createProblem(result, false, msg);
                        }
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return this.checkProblem;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        final HashSet<FileObject> set = new HashSet<FileObject>();
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
        try {
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    ClassIndex idx = info.getClasspathInfo().getClassIndex();
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    Element el = RenameRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)info);
                    ElementKind kind = el.getKind();
                    ElementHandle enclosingType = el instanceof TypeElement ? ElementHandle.create((Element)((TypeElement)el)) : ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)el));
                    set.add(SourceUtils.getFile((Element)el, (ClasspathInfo)info.getClasspathInfo()));
                    if (kind.isField()) {
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (el instanceof TypeElement) {
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (kind == ElementKind.METHOD) {
                        ElementHandle encl;
                        RenameRefactoringPlugin.this.allMethods = new HashSet();
                        RenameRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)el)));
                        for (ExecutableElement e : RetoucheUtils.getOverridingMethods((ExecutableElement)el, (CompilationInfo)info)) {
                            set.add(SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo()));
                            encl = ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)e));
                            set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                            RenameRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                        }
                        for (ExecutableElement e : RetoucheUtils.getOverridenMethods((ExecutableElement)el, (CompilationInfo)info)) {
                            set.add(SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo()));
                            encl = ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)e));
                            set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                            RenameRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                        }
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        return set;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        if (this.treePathHandle == null) {
            return null;
        }
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(1, a.size());
        if (!a.isEmpty()) {
            Collection<ModificationResult> results = this.processFiles(a, new FindTask(elements));
            elements.registerTransaction((Transaction)new RetoucheCommit(results));
            for (ModificationResult result : results) {
                for (FileObject jfo : result.getModifiedFileObjects()) {
                    for (ModificationResult.Difference dif : result.getDifferences(jfo)) {
                        String old = dif.getOldText();
                        if (old == null) continue;
                        elements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(dif, jfo, result));
                    }
                }
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    private Element hides(Element field, String name, CompilationInfo info) {
        TypeElement jc = SourceUtils.getEnclosingTypeElement((Element)field);
        Types types = info.getTypes();
        Elements elements = info.getElements();
        jc = (TypeElement)types.asElement(jc.getSuperclass());
        while (jc != null) {
            for (Element element : info.getElements().getAllMembers(jc)) {
                if (!elements.hides(element, field)) continue;
                return element;
            }
            jc = (TypeElement)types.asElement(jc.getSuperclass());
        }
        return null;
    }

    private static final String getString(String key) {
        return NbBundle.getMessage(RenameRefactoringPlugin.class, (String)key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;

        public FindTask(RefactoringElementsBag elements) {
            this.elements = elements;
        }

        public void cancel() {
        }

        public void run(WorkingCopy compiler) throws IOException {
            compiler.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            Element el = RenameRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)compiler);
            assert (el != null);
            RenameTransformer findVisitor = new RenameTransformer(RenameRefactoringPlugin.this.refactoring.getNewName(), compiler, RenameRefactoringPlugin.this.allMethods);
            findVisitor.scan(compiler.getCompilationUnit(), el);
            for (TreePath tree : findVisitor.getUsages()) {
                ElementGripFactory.getDefault().put(compiler.getFileObject(), tree, (CompilationInfo)compiler);
            }
            RenameRefactoringPlugin.this.fireProgressListenerStep();
        }
    }
}

