/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.swing.Action;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.DiffElement;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.DeleteTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class SafeDeleteRefactoringPlugin
extends JavaRefactoringPlugin {
    private SafeDeleteRefactoring refactoring;
    private WhereUsedQuery[] whereUsedQueries;
    private ArrayList<TreePathHandle> grips = new ArrayList();

    public SafeDeleteRefactoringPlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        RefactoringSession inner = RefactoringSession.create((String)"delete");
        HashSet<Object> refactoredObjects = new HashSet<Object>();
        this.fireProgressListenerStart(2, this.whereUsedQueries.length + 1);
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            Object refactoredObject = this.whereUsedQueries[i].getRefactoringSource().lookup(Object.class);
            refactoredObjects.add(refactoredObject);
            this.whereUsedQueries[i].prepare(inner);
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.grips.get(i).getFileObject());
            try {
                ModificationResult result = javaSource.runModificationTask((CancellableTask)new FindTask(refactoringElements, this.grips.get(i)));
                refactoringElements.registerTransaction((Transaction)new RetoucheCommit(Collections.singleton(result)));
                for (FileObject jfo : result.getModifiedFileObjects()) {
                    for (ModificationResult.Difference dif : result.getDifferences(jfo)) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(dif, jfo, result));
                    }
                }
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.fireProgressListenerStep();
        }
        ArrayList importStmts = new ArrayList();
        Iterator iter = inner.getRefactoringElements().iterator();
        while (iter.hasNext()) {
            ElementGrip elem = (ElementGrip)((RefactoringElement)iter.next()).getLookup().lookup(ElementGrip.class);
            boolean isOuterRef = true;
            if (!isOuterRef) continue;
            this.fireProgressListenerStop();
            return new Problem(false, SafeDeleteRefactoringPlugin.getString("ERR_ReferencesFound"), ProblemDetailsFactory.createProblemDetails((ProblemDetailsImplementation)new ProblemDetailsImplemen(new WhereUsedQueryUI(elem.getHandle(), "!!!TODO!!!", (AbstractRefactoring)this.refactoring), inner)));
        }
        if (importStmts.size() > 0) {
            for (RefactoringElementImplementation refacElem : importStmts) {
                refactoringElements.add((AbstractRefactoring)this.refactoring, refacElem);
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        this.grips.clear();
        final ArrayList controllers = new ArrayList();
        for (FileObject f : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            JavaSource source = JavaSource.forFileObject((FileObject)f);
            try {
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController co) throws Exception {
                        co.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        CompilationUnitTree cut = co.getCompilationUnit();
                        for (Tree tree : cut.getTypeDecls()) {
                            TreePathHandle handle = TreePathHandle.create((TreePath)TreePath.getPath(cut, tree), (CompilationInfo)co);
                            if (SafeDeleteRefactoringPlugin.this.containsHandle(handle, (CompilationInfo)co)) continue;
                            SafeDeleteRefactoringPlugin.this.grips.add(handle);
                        }
                        controllers.add(co.getClasspathInfo());
                    }
                }, true);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.grips.addAll(this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class));
        this.whereUsedQueries = new WhereUsedQuery[this.grips.size()];
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            if (!controllers.isEmpty()) {
                this.refactoring.getContext().add(controllers.get(i));
            }
            this.whereUsedQueries[i] = this.createQuery(this.grips.get(i));
            this.whereUsedQueries[i].putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.refactoring.isCheckInComments());
            if (!Tree.Kind.METHOD.equals((Object)this.grips.get(i).getKind())) continue;
            this.whereUsedQueries[i].putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)true);
        }
        Problem problemFromUsage = null;
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            problemFromUsage = this.whereUsedQueries[i].checkParameters();
            if (problemFromUsage == null) continue;
            return problemFromUsage;
        }
        return null;
    }

    private boolean containsHandle(TreePathHandle handle, CompilationInfo info) {
        for (TreePathHandle current : this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            if (!((Object)current.resolveElement(info)).equals(handle.resolveElement(info))) continue;
            return true;
        }
        return false;
    }

    private WhereUsedQuery createQuery(TreePathHandle tph) {
        WhereUsedQuery q = new WhereUsedQuery(Lookups.singleton((Object)tph));
        for (Object o : this.refactoring.getContext().lookupAll(Object.class)) {
            q.getContext().add(o);
        }
        return q;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(SafeDeleteRefactoringPlugin.class, (String)key);
    }

    private Problem getProblemMessage(Object refactoredObject) {
        String errorMsg = NbBundle.getMessage(SafeDeleteUI.class, (String)"DSC_SafeDelProblem", (Object)refactoredObject);
        return new Problem(true, errorMsg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;
        private TreePathHandle jmiObject;

        public FindTask(RefactoringElementsBag elements, TreePathHandle element) {
            this.elements = elements;
            this.jmiObject = element;
        }

        public void cancel() {
        }

        public void run(WorkingCopy compiler) throws IOException {
            compiler.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            Element el = this.jmiObject.resolveElement((CompilationInfo)compiler);
            assert (el != null);
            DeleteTransformer findVisitor = new DeleteTransformer(compiler);
            findVisitor.scan(compiler.getCompilationUnit(), el);
            for (TreePath tree : findVisitor.getUsages()) {
                ElementGripFactory.getDefault().put(compiler.getFileObject(), tree, (CompilationInfo)compiler);
            }
        }
    }

    private static class ImportRefDeleteElement
    extends SimpleRefactoringElementImplementation {
        private final String text = "todo";

        private ImportRefDeleteElement() {
        }

        public String getText() {
            return "todo";
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return null;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private class ProblemDetailsImplemen
    implements ProblemDetailsImplementation {
        private RefactoringUI ui;
        private RefactoringSession rs;

        public ProblemDetailsImplemen(RefactoringUI ui, RefactoringSession rs) {
            this.ui = ui;
            this.rs = rs;
        }

        public void showDetails(Action callback, Cancellable parent) {
            parent.cancel();
            UI.openRefactoringUI((RefactoringUI)this.ui, (RefactoringSession)this.rs, (Action)callback);
        }

        public String getDetailsHint() {
            return SafeDeleteRefactoringPlugin.getString("LBL_ShowUsages");
        }
    }
}

