/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.ui.PullUpAction;
import org.netbeans.modules.refactoring.java.ui.PullUpPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PullUpRefactoringUI
implements RefactoringUI {
    private final PullUpRefactoring refactoring;
    private final Set initialMembers = new HashSet();
    private PullUpPanel panel;
    private String description;

    public PullUpRefactoringUI(TreePathHandle[] selectedElements, CompilationInfo info) {
        this.initialMembers.add(new MemberInfo(selectedElements[0].resolveElement(info), info));
        Element selected = selectedElements[0].resolveElement(info);
        if (!(selected instanceof TypeElement)) {
            selected = SourceUtils.getEnclosingTypeElement((Element)selected);
        }
        TreePath tp = SourceUtils.pathFor((CompilationInfo)info, (Element)selected);
        TreePathHandle sourceType = TreePathHandle.create((TreePath)tp, (CompilationInfo)info);
        this.description = UiUtils.getHeader((TreePath)tp, (CompilationInfo)info, (String)"%name%");
        this.refactoring = new PullUpRefactoring(Lookups.singleton((Object)sourceType));
        this.refactoring.getContext().add((Object)info.getClasspathInfo());
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new PullUpPanel(this.refactoring, this.initialMembers, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(PullUpAction.class, (String)"DSC_PullUp", (Object)this.description);
    }

    public String getName() {
        return NbBundle.getMessage(PullUpAction.class, (String)"LBL_PullUp");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PullUpRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.refactoring.setTargetType(this.panel.getTargetType().getElementHandle());
        this.refactoring.setMembers(this.panel.getMembers());
    }
}

