/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.ui.PushDownPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PushDownRefactoringUI
implements RefactoringUI {
    private final PushDownRefactoring refactoring;
    private final Set initialMembers = new HashSet();
    private PushDownPanel panel;
    private String description;

    public PushDownRefactoringUI(TreePathHandle[] selectedElements, CompilationInfo info) {
        this.initialMembers.add(new MemberInfo(selectedElements[0].resolveElement(info), info));
        Element selected = selectedElements[0].resolveElement(info);
        if (!(selected instanceof TypeElement)) {
            selected = SourceUtils.getEnclosingTypeElement((Element)selected);
        }
        TreePath tp = SourceUtils.pathFor((CompilationInfo)info, (Element)selected);
        TreePathHandle sourceType = TreePathHandle.create((TreePath)tp, (CompilationInfo)info);
        this.description = UiUtils.getHeader((TreePath)tp, (CompilationInfo)info, (String)"%name%");
        this.refactoring = new PushDownRefactoring(Lookups.singleton((Object)sourceType));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(sourceType));
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new PushDownPanel(this.refactoring, this.initialMembers, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(PushDownRefactoringUI.class, (String)"DSC_PushDown", (Object)this.description);
    }

    public String getName() {
        return NbBundle.getMessage(PushDownRefactoringUI.class, (String)"LBL_PushDown");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PushDownRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.refactoring.setMembers(this.panel.getMembers());
    }
}

