/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import java.awt.Image;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.refactoring.java.ui.tree.FolderTreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Utilities;

public class SourceGroupTreeElement
implements TreeElement {
    private WeakReference<SourceGroup> sg;
    private FileObject dir;
    private Icon icon;
    private String displayName;
    private static String PACKAGE_BADGE = "org/netbeans/spi/java/project/support/ui/packageBadge.gif";

    SourceGroupTreeElement(SourceGroup sg) {
        this.sg = new WeakReference<SourceGroup>(sg);
        this.dir = sg.getRootFolder();
        this.icon = sg.getIcon(false);
        if (this.icon == null) {
            try {
                Image image = DataObject.find((FileObject)sg.getRootFolder()).getNodeDelegate().getIcon(1);
                image = Utilities.mergeImages((Image)image, (Image)Utilities.loadImage((String)PACKAGE_BADGE), (int)7, (int)7);
                this.icon = new ImageIcon(image);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        this.displayName = sg.getDisplayName();
    }

    public TreeElement getParent(boolean isLogical) {
        return TreeElementFactory.getTreeElement((Object)FileOwnerQuery.getOwner((FileObject)this.dir));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText(boolean isLogical) {
        return this.displayName;
    }

    public Object getUserObject() {
        SourceGroup s = (SourceGroup)this.sg.get();
        if (s == null) {
            s = FolderTreeElement.getSourceGroup(this.dir);
        }
        return s;
    }
}

