/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

public class SimpleFileOwnerQueryImplementation
implements FileOwnerQueryImplementation {
    private final Set<FileObject> warnedAboutBrokenProjects = new WeakSet();
    private static final Map<URI, Reference<FileObject>> externalOwners = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<FileObject, Collection<URI>> project2External = Collections.synchronizedMap(new WeakHashMap());

    public Project getOwner(URI fileURI) {
        FileObject file;
        URI test = fileURI;
        do {
            file = SimpleFileOwnerQueryImplementation.uri2FileObject(test);
            test = SimpleFileOwnerQueryImplementation.goUp(test);
        } while (file == null && test != null);
        if (file == null) {
            return null;
        }
        return this.getOwner(file);
    }

    public Project getOwner(FileObject f) {
        while (f != null) {
            FileObject externalOwner;
            Reference<FileObject> externalOwnersReference;
            if (f.isFolder()) {
                Project p;
                try {
                    p = ProjectManager.getDefault().findProject(f);
                }
                catch (IOException e) {
                    if (this.warnedAboutBrokenProjects.add(f)) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                    return null;
                }
                if (p != null) {
                    return p;
                }
            }
            if (!externalOwners.isEmpty() && (externalOwnersReference = externalOwners.get(SimpleFileOwnerQueryImplementation.fileObject2URI(f))) != null && (externalOwner = externalOwnersReference.get()) != null) {
                try {
                    return ProjectManager.getDefault().findProject(externalOwner);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    return null;
                }
            }
            f = f.getParent();
        }
        return null;
    }

    public static void reset() {
        externalOwners.clear();
    }

    private static URI fileObject2URI(FileObject f) {
        try {
            return URI.create(f.getURL().toString());
        }
        catch (FileStateInvalidException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(e.toString()).initCause(e);
        }
    }

    public static void markExternalOwnerTransient(FileObject root, Project owner) {
        SimpleFileOwnerQueryImplementation.markExternalOwnerTransient(SimpleFileOwnerQueryImplementation.fileObject2URI(root), owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markExternalOwnerTransient(URI root, Project owner) {
        FileObject ownerFO;
        if (owner != null) {
            externalOwners.put(root, new WeakReference<FileObject>(owner.getProjectDirectory()));
            Map<FileObject, Collection<URI>> map = project2External;
            synchronized (map) {
                FileObject prjDir = owner.getProjectDirectory();
                Collection<URI> roots = project2External.get(prjDir);
                if (roots == null) {
                    roots = new LinkedList<URI>();
                    project2External.put(prjDir, roots);
                }
                roots.add(root);
            }
        }
        Reference<FileObject> ownerReference = externalOwners.remove(root);
        if (ownerReference != null && (ownerFO = ownerReference.get()) != null) {
            Map<FileObject, Collection<URI>> map = project2External;
            synchronized (map) {
                Collection<URI> roots = project2External.get(ownerFO);
                if (roots != null) {
                    roots.remove(root);
                    if (roots.size() == 0) {
                        project2External.remove(ownerFO);
                    }
                }
            }
        }
    }

    private static FileObject uri2FileObject(URI u) {
        URL url;
        try {
            url = u.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            assert (false) : u;
            return null;
        }
        return URLMapper.findFileObject((URL)url);
    }

    private static URI goUp(URI u) {
        String pth;
        URI nue;
        assert (u.isAbsolute()) : u;
        assert (u.getFragment() == null) : u;
        assert (u.getQuery() == null) : u;
        String path = u.getPath();
        if (path == null || path.equals("/")) {
            return null;
        }
        String us = u.toString();
        if (us.endsWith("/")) {
            us = us.substring(0, us.length() - 1);
            assert (path.endsWith("/"));
            path = path.substring(0, path.length() - 1);
        }
        int idx = us.lastIndexOf(47);
        assert (idx != -1) : path;
        us = path.lastIndexOf(47) == 0 ? us.substring(0, idx + 1) : us.substring(0, idx);
        try {
            nue = new URI(us);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        if (Utilities.isWindows() && ((pth = nue.getPath()).length() == 3 && pth.endsWith(":") || pth.length() == 1 && pth.endsWith("/"))) {
            return null;
        }
        assert (nue.isAbsolute()) : nue;
        assert (u.toString().startsWith(nue.toString())) : "not a parent: " + nue + " of " + u;
        return nue;
    }
}

