/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.Prefs;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.GifEncoder;
import ij.io.ImageWriter;
import ij.io.SaveDialog;
import ij.io.TextEncoder;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileSaver {
    private static String defaultDirectory = null;
    private ImagePlus imp;
    private FileInfo fi;
    private String name;
    private String directory;

    public FileSaver(ImagePlus imp) {
        this.imp = imp;
        this.fi = imp.getFileInfo();
    }

    public boolean save() {
        boolean validName;
        FileInfo ofi = null;
        if (this.imp != null) {
            ofi = this.imp.getOriginalFileInfo();
        }
        boolean bl = validName = ofi != null && this.imp.getTitle().equals(ofi.fileName);
        if (validName && ofi.fileFormat == 2 && this.imp.getStackSize() == 1 && ofi.nImages == 1 && (ofi.url == null || ofi.url.equals(""))) {
            this.name = this.imp.getTitle();
            this.directory = ofi.directory;
            String path = this.directory + this.name;
            File f = new File(path);
            if (!IJ.macroRunning() && f != null && f.exists() && !IJ.showMessageWithCancel("Save as TIFF", "The file " + ofi.fileName + " already exists.\nDo you want to replace it?")) {
                return false;
            }
            IJ.showStatus("Saving " + path);
            return this.saveAsTiff(path);
        }
        return this.saveAsTiff();
    }

    String getPath(String type, String extension) {
        this.name = this.imp.getTitle();
        SaveDialog sd = new SaveDialog("Save as " + type, this.name, extension);
        this.name = sd.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = sd.getDirectory();
        this.imp.startTiming();
        String path = this.directory + this.name;
        return path;
    }

    public boolean saveAsTiff() {
        String path = this.getPath("TIFF", ".tif");
        if (path == null) {
            return false;
        }
        if (this.fi.nImages > 1) {
            return this.saveAsTiffStack(path);
        }
        return this.saveAsTiff(path);
    }

    public boolean saveAsTiff(String path) {
        this.fi.nImages = 1;
        Object info = this.imp.getProperty("Info");
        if (info != null && info instanceof String) {
            this.fi.info = (String)info;
        }
        this.fi.description = this.getDescriptionString();
        try {
            TiffEncoder file = new TiffEncoder(this.fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public boolean saveAsTiffStack(String path) {
        if (this.fi.nImages == 1) {
            IJ.error("This is not a stack");
            return false;
        }
        if (this.fi.pixels == null && this.imp.getStack().isVirtual()) {
            IJ.error("Save As Tiff", "Virtual stacks not supported.");
            return false;
        }
        Object info = this.imp.getProperty("Info");
        if (info != null && info instanceof String) {
            this.fi.info = (String)info;
        }
        this.fi.description = this.getDescriptionString();
        this.fi.sliceLabels = this.imp.getStack().getSliceLabels();
        try {
            TiffEncoder file = new TiffEncoder(this.fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public boolean saveAsZip() {
        String path = this.getPath("TIFF/ZIP", ".zip");
        if (path == null) {
            return false;
        }
        return this.saveAsZip(path);
    }

    public boolean saveAsZip(String path) {
        if (!path.endsWith(".zip")) {
            path = path + ".zip";
        }
        if (this.name == null) {
            this.name = this.imp.getTitle();
        }
        if (this.name.endsWith(".zip")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        if (!this.name.endsWith(".tif")) {
            this.name = this.name + ".tif";
        }
        this.fi.description = this.getDescriptionString();
        Object info = this.imp.getProperty("Info");
        if (info != null && info instanceof String) {
            this.fi.info = (String)info;
        }
        this.fi.sliceLabels = this.imp.getStack().getSliceLabels();
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(zos));
            zos.putNextEntry(new ZipEntry(this.name));
            TiffEncoder te = new TiffEncoder(this.fi);
            te.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 2);
        return true;
    }

    public static boolean okForGif(ImagePlus imp) {
        int type = imp.getType();
        if (type == 4 || type == 1 || type == 2) {
            IJ.error("To save as Gif, the image must be \"8-bit\" or \"8-bit Color\".");
            return false;
        }
        return true;
    }

    public boolean saveAsGif() {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        String path = this.getPath("GIF", ".gif");
        if (path == null) {
            return false;
        }
        return this.saveAsGif(path);
    }

    public boolean saveAsGif(String path) {
        if (!FileSaver.okForGif(this.imp)) {
            return false;
        }
        try {
            byte[] pixels = (byte[])this.imp.getProcessor().getPixels();
            GifEncoder encoder = new GifEncoder(this.fi.width, this.fi.height, pixels, this.fi.reds, this.fi.greens, this.fi.blues);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
            encoder.write(output);
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(this.fi, 3);
        return true;
    }

    public static boolean okForJpeg(ImagePlus imp) {
        return true;
    }

    public boolean saveAsJpeg() {
        String path = this.getPath("JPEG", ".jpg");
        if (path == null) {
            return false;
        }
        return this.saveAsJpeg(path);
    }

    public boolean saveAsJpeg(String path) {
        Object jpegWriter = null;
        ImagePlus tempImage = WindowManager.getTempCurrentImage();
        WindowManager.setTempCurrentImage(this.imp);
        if (IJ.isJava2()) {
            IJ.runPlugIn("ij.plugin.JpegWriter", path);
        } else {
            IJ.runPlugIn("Jpeg_Writer", path);
        }
        WindowManager.setTempCurrentImage(tempImage);
        if (this.imp.getType() != 1 && this.imp.getType() != 2) {
            this.updateImp(this.fi, 3);
        }
        return true;
    }

    public boolean saveAsBmp() {
        String path = this.getPath("BMP", ".bmp");
        if (path == null) {
            return false;
        }
        return this.saveAsBmp(path);
    }

    public boolean saveAsBmp(String path) {
        ImagePlus tempImage = WindowManager.getTempCurrentImage();
        WindowManager.setTempCurrentImage(this.imp);
        IJ.runPlugIn("ij.plugin.BMP_Writer", path);
        WindowManager.setTempCurrentImage(tempImage);
        return true;
    }

    public boolean saveAsPgm() {
        String extension = this.imp.getBitDepth() == 24 ? ".pnm" : ".pgm";
        String path = this.getPath("PGM", extension);
        if (path == null) {
            return false;
        }
        return this.saveAsPgm(path);
    }

    public boolean saveAsPgm(String path) {
        ImagePlus tempImage = WindowManager.getTempCurrentImage();
        WindowManager.setTempCurrentImage(this.imp);
        IJ.runPlugIn("ij.plugin.PNM_Writer", path);
        WindowManager.setTempCurrentImage(tempImage);
        return true;
    }

    public boolean saveAsPng() {
        if (!IJ.isJava14()) {
            IJ.error("Save As PNG", "Java 1.4 or later required");
            return false;
        }
        String path = this.getPath("PNG", ".png");
        if (path == null) {
            return false;
        }
        return this.saveAsPng(path);
    }

    public boolean saveAsPng(String path) {
        ImagePlus tempImage = WindowManager.getTempCurrentImage();
        WindowManager.setTempCurrentImage(this.imp);
        IJ.runPlugIn("ij.plugin.PNG_Writer", path);
        WindowManager.setTempCurrentImage(tempImage);
        return true;
    }

    public boolean saveAsFits() {
        if (!FileSaver.okForFits(this.imp)) {
            return false;
        }
        String path = this.getPath("FITS", ".fits");
        if (path == null) {
            return false;
        }
        return this.saveAsFits(path);
    }

    public boolean saveAsFits(String path) {
        if (!FileSaver.okForFits(this.imp)) {
            return false;
        }
        ImagePlus tempImage = WindowManager.getTempCurrentImage();
        WindowManager.setTempCurrentImage(this.imp);
        IJ.runPlugIn("ij.plugin.FITS_Writer", path);
        WindowManager.setTempCurrentImage(tempImage);
        return true;
    }

    public static boolean okForFits(ImagePlus imp) {
        if (imp.getBitDepth() == 8 || imp.getBitDepth() == 24) {
            IJ.error("FITS Writer", "16 or 32 bit image required");
            return false;
        }
        return true;
    }

    public boolean saveAsRaw() {
        String path = this.getPath("Raw", ".raw");
        if (path == null) {
            return false;
        }
        if (this.imp.getStackSize() == 1) {
            return this.saveAsRaw(path);
        }
        return this.saveAsRawStack(path);
    }

    public boolean saveAsRaw(String path) {
        this.fi.nImages = 1;
        this.fi.intelByteOrder = Prefs.intelByteOrder;
        boolean signed16Bit = false;
        short[] pixels = null;
        int n = 0;
        try {
            signed16Bit = this.imp.getCalibration().isSigned16Bit();
            if (signed16Bit) {
                pixels = (short[])this.imp.getProcessor().getPixels();
                n = this.imp.getWidth() * this.imp.getHeight();
                for (int i = 0; i < n; ++i) {
                    pixels[i] = (short)(pixels[i] - 32768);
                }
            }
            ImageWriter file = new ImageWriter(this.fi);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        if (signed16Bit) {
            for (int i = 0; i < n; ++i) {
                pixels[i] = (short)(pixels[i] + 32768);
            }
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsRawStack(String path) {
        int i;
        short[] pixels;
        if (this.fi.nImages == 1) {
            IJ.write("This is not a stack");
            return false;
        }
        this.fi.intelByteOrder = Prefs.intelByteOrder;
        boolean signed16Bit = false;
        Object[] stack = null;
        int n = 0;
        try {
            signed16Bit = this.imp.getCalibration().isSigned16Bit();
            if (signed16Bit) {
                stack = (Object[])this.fi.pixels;
                n = this.imp.getWidth() * this.imp.getHeight();
                for (int slice = 0; slice < this.fi.nImages; ++slice) {
                    pixels = (short[])stack[slice];
                    for (i = 0; i < n; ++i) {
                        pixels[i] = (short)(pixels[i] - 32768);
                    }
                }
            }
            ImageWriter file = new ImageWriter(this.fi);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        if (signed16Bit) {
            for (int slice = 0; slice < this.fi.nImages; ++slice) {
                pixels = (short[])stack[slice];
                for (i = 0; i < n; ++i) {
                    pixels[i] = (short)(pixels[i] + 32768);
                }
            }
        }
        this.updateImp(this.fi, 1);
        return true;
    }

    public boolean saveAsText() {
        String path = this.getPath("Text", ".txt");
        if (path == null) {
            return false;
        }
        return this.saveAsText(path);
    }

    public boolean saveAsText(String path) {
        try {
            Calibration cal = this.imp.getCalibration();
            int precision = Analyzer.getPrecision();
            TextEncoder file = new TextEncoder(this.imp.getProcessor(), cal, precision);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    public boolean saveAsLut() {
        if (this.imp.getType() == 4) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        String path = this.getPath("LUT", ".lut");
        if (path == null) {
            return false;
        }
        return this.saveAsLut(path);
    }

    public boolean saveAsLut(String path) {
        LookUpTable lut = this.imp.createLut();
        int mapSize = lut.getMapSize();
        if (mapSize == 0) {
            IJ.error("RGB Images do not have a LUT.");
            return false;
        }
        if (mapSize < 256) {
            IJ.error("Cannot save LUTs with less than 256 entries.");
            return false;
        }
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        byte[] pixels = new byte[768];
        for (int i = 0; i < 256; ++i) {
            pixels[i] = reds[i];
            pixels[i + 256] = greens[i];
            pixels[i + 512] = blues[i];
        }
        FileInfo fi = new FileInfo();
        fi.width = 768;
        fi.height = 1;
        fi.pixels = pixels;
        try {
            ImageWriter file = new ImageWriter(fi);
            FileOutputStream out = new FileOutputStream(path);
            file.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    private void updateImp(FileInfo fi, int fileFormat) {
        this.imp.changes = false;
        if (this.name != null) {
            fi.fileFormat = fileFormat;
            fi.fileName = this.name;
            fi.directory = this.directory;
            if (fileFormat == 2) {
                fi.offset = 768;
            }
            fi.description = null;
            this.imp.setTitle(this.name);
            this.imp.setFileInfo(fi);
        }
    }

    void showErrorMessage(IOException e) {
        String msg = e.getMessage();
        if (msg.length() > 100) {
            msg = msg.substring(0, 100);
        }
        IJ.error("FileSaver", "An error occured writing the file.\n \n" + msg);
    }

    public String getDescriptionString() {
        boolean enhancedLut;
        int frames;
        int slices;
        int channels;
        Calibration cal = this.imp.getCalibration();
        StringBuffer sb = new StringBuffer(100);
        sb.append("ImageJ=1.38o\n");
        if (this.fi.nImages > 1 && this.fi.fileType != 12) {
            sb.append("images=" + this.fi.nImages + "\n");
        }
        if ((channels = this.imp.getNChannels()) > 1) {
            sb.append("channels=" + channels + "\n");
        }
        if ((slices = this.imp.getNSlices()) > 1) {
            sb.append("slices=" + slices + "\n");
        }
        if ((frames = this.imp.getNFrames()) > 1) {
            sb.append("frames=" + frames + "\n");
        }
        if (this.fi.unit != null) {
            sb.append("unit=" + this.fi.unit + "\n");
        }
        if (this.fi.valueUnit != null && this.fi.calibrationFunction != 22) {
            sb.append("cf=" + this.fi.calibrationFunction + "\n");
            if (this.fi.coefficients != null) {
                for (int i = 0; i < this.fi.coefficients.length; ++i) {
                    sb.append("c" + i + "=" + this.fi.coefficients[i] + "\n");
                }
            }
            sb.append("vunit=" + this.fi.valueUnit + "\n");
            if (cal.zeroClip()) {
                sb.append("zeroclip=true\n");
            }
        }
        if (this.fi.nImages > 1) {
            if (this.fi.pixelDepth != 0.0 && this.fi.pixelDepth != 1.0) {
                sb.append("spacing=" + this.fi.pixelDepth + "\n");
            }
            if (cal.fps != 0.0) {
                if ((double)((int)cal.fps) == cal.fps) {
                    sb.append("fps=" + (int)cal.fps + "\n");
                } else {
                    sb.append("fps=" + cal.fps + "\n");
                }
            }
            if (cal.frameInterval != 0.0) {
                if ((double)((int)cal.frameInterval) == cal.frameInterval) {
                    sb.append("finterval=" + (int)cal.frameInterval + "\n");
                } else {
                    sb.append("finterval=" + cal.frameInterval + "\n");
                }
            }
            if (!cal.getTimeUnit().equals("sec")) {
                sb.append("tunit=" + cal.getTimeUnit() + "\n");
            }
        }
        ImageProcessor ip = this.imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        int type = this.imp.getType();
        boolean bl = enhancedLut = !(type != 0 && type != 3 || min == 0.0 && max == 255.0);
        if (enhancedLut || type == 1 || type == 2) {
            sb.append("min=" + min + "\n");
            sb.append("max=" + max + "\n");
        }
        if (cal.xOrigin != 0.0) {
            sb.append("xorigin=" + cal.xOrigin + "\n");
        }
        if (cal.yOrigin != 0.0) {
            sb.append("yorigin=" + cal.yOrigin + "\n");
        }
        if (cal.zOrigin != 0.0) {
            sb.append("zorigin=" + cal.zOrigin + "\n");
        }
        if (cal.info != null && cal.info.length() <= 64 && cal.info.indexOf(61) == -1 && cal.info.indexOf(10) == -1) {
            sb.append("info=" + cal.info + "\n");
        }
        sb.append('\u0000');
        return new String(sb);
    }
}

