/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class RankFilters
implements PlugInFilter {
    public static final int MEDIAN = 0;
    public static final int MEAN = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int VARIANCE = 4;
    public static final int DESPECKLE = 5;
    ImagePlus imp;
    int filterType = 0;
    String title;
    int kw;
    int kh;
    int slice;
    boolean canceled;
    private static final String[] typeStrings = new String[]{"Median", "Mean", "Minimum", "Maximum", "Variance", "Median"};
    boolean isLineRoi;
    int nSlices;
    static double radius = 2.0;
    static boolean separable = true;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(this.getClass());
        this.imp = imp;
        if (arg.equals("median")) {
            this.filterType = 0;
        } else if (arg.equals("min")) {
            this.filterType = 2;
        } else if (arg.equals("max")) {
            this.filterType = 3;
        } else if (arg.equals("mean")) {
            this.filterType = 1;
        } else if (arg.equals("variance")) {
            this.filterType = 4;
        } else if (arg.equals("despeckle")) {
            this.filterType = 5;
        } else if (arg.equals("masks")) {
            this.showMasks();
            return 4096;
        }
        this.slice = 0;
        this.canceled = false;
        if (imp != null) {
            IJ.resetEscape();
            Roi roi = imp.getRoi();
            this.isLineRoi = roi != null && roi.isLine();
            this.nSlices = imp.getStackSize();
        }
        this.title = typeStrings[this.filterType];
        IJ.showStatus(this.title + ", radius=" + radius + " (esc to abort)");
        if (imp != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (IJ.escapePressed()) {
            this.canceled = true;
            IJ.beep();
            return;
        }
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        if (this.filterType == 1 && separable) {
            this.blur(ip, (int)radius);
        } else {
            this.rank(ip, radius, this.filterType);
        }
        if (this.slice > 1) {
            IJ.showStatus(this.title + ": " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.imp != null && this.slice == this.nSlices) {
            ip.resetMinAndMax();
        }
    }

    public void blur(ImageProcessor ip, int radius) {
        float[] kernel = new float[radius * 2 + 1];
        for (int i = 0; i < kernel.length; ++i) {
            kernel[i] = 1.0f;
        }
        ImageProcessor mask = ip.getMask();
        if (mask != null) {
            ip.snapshot();
        }
        ip.convolve(kernel, kernel.length, 1);
        ip.convolve(kernel, 1, kernel.length);
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void showMasks() {
        int w = 150;
        int h = 150;
        ImageStack stack = new ImageStack(w, h);
        for (double r = 0.5; r < 50.0; r += 0.5) {
            int d = (int)(r + 0.5) * 2 + 1;
            int[] mask = this.createCircularMask(d, r);
            FloatProcessor ip2 = new FloatProcessor(w, h, new int[w * h]);
            ip2.insert(new FloatProcessor(d, d, mask), w / 2 - d / 2, h / 2 - d / 2);
            stack.addSlice("radius=" + r + ", size=" + d, ip2);
        }
        new ImagePlus("Masks", stack).show();
    }

    public void rank(ImageProcessor ip, double radius, int rankType) {
        FloatProcessor fp = null;
        for (int i = 0; i < ip.getNChannels(); ++i) {
            fp = ip.toFloat(i, fp);
            this.rankFloat(fp, radius, rankType);
            ip.setPixels(i, fp);
        }
    }

    boolean showDialog() {
        if (this.filterType == 5) {
            radius = 1.0;
            this.filterType = 0;
            this.imp.startTiming();
            return true;
        }
        GenericDialog gd = new GenericDialog(this.title + "...");
        int digits = this.filterType == 1 ? 0 : 1;
        gd.addNumericField("Radius:", radius, digits, 5, "pixels");
        if (this.filterType == 1) {
            gd.addCheckbox("Separable Square Mask", separable);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        radius = gd.getNextNumber();
        if (this.filterType == 1) {
            separable = gd.getNextBoolean();
        }
        if (radius < 0.5) {
            radius = 0.5;
        }
        this.imp.startTiming();
        return true;
    }

    public void rankFloat(ImageProcessor ip, double radius, int rankType) {
        int kw;
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle r = ip.getRoi();
        boolean isRoi = r.width != width || r.height != height;
        boolean nonRectRoi = ip.getMask() != null;
        int x1 = 0;
        int y1 = 0;
        int x2 = width - 1;
        int y2 = height - 1;
        if (isRoi) {
            x1 = r.x;
            y1 = r.y;
            x2 = x1 + r.width - 1;
            y2 = y1 + r.height - 1;
        }
        if (nonRectRoi) {
            ip.snapshot();
        }
        int kh = kw = (int)(radius + 0.5) * 2 + 1;
        int[] mask = this.createCircularMask(kw, radius);
        int maskSize = 0;
        for (int i = 0; i < kw * kw; ++i) {
            if (mask[i] == 0) continue;
            ++maskSize;
        }
        float[] values = new float[maskSize];
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getPixelsCopy();
        int progress = Math.max((y2 - y1) / 50, 1);
        int xedge = width - uc;
        int yedge = height - vc;
        for (int y = y1; y <= y2; ++y) {
            if (y % progress == 0) {
                IJ.showProgress((double)y / (double)height);
                this.canceled = IJ.escapePressed();
                if (this.canceled) break;
            }
            block9: for (int x = x1; x <= x2; ++x) {
                double sum = 0.0;
                int i = 0;
                int count = 0;
                boolean edgePixel = y < vc || y >= yedge || x < uc || x >= xedge;
                for (int v = -vc; v <= vc; ++v) {
                    int offset = x + (y + v) * width;
                    for (int u = -uc; u <= uc; ++u) {
                        if (mask[i++] == 0) continue;
                        values[count] = edgePixel ? this.getPixel(x + u, y + v, pixels2, width, height) : pixels2[offset + u];
                        ++count;
                    }
                }
                switch (rankType) {
                    case 0: {
                        pixels[x + y * width] = this.findMedian(values);
                        continue block9;
                    }
                    case 1: {
                        pixels[x + y * width] = this.findMean(values);
                        continue block9;
                    }
                    case 2: {
                        pixels[x + y * width] = this.findMin(values);
                        continue block9;
                    }
                    case 3: {
                        pixels[x + y * width] = this.findMax(values);
                        continue block9;
                    }
                    case 4: {
                        pixels[x + y * width] = this.findVariance(values);
                        continue block9;
                    }
                }
            }
        }
        if (nonRectRoi) {
            ip.reset(ip.getMask());
        }
        IJ.showProgress(1.0);
        if (this.canceled) {
            ip.insert(new FloatProcessor(width, height, pixels2, null), 0, 0);
            IJ.beep();
        } else if (rankType == 4) {
            ContrastEnhancer ce = new ContrastEnhancer();
            ce.stretchHistogram(ip, 0.5);
        }
    }

    private float getPixel(int x, int y, float[] pixels, int width, int height) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= height) {
            y = height - 1;
        }
        return pixels[x + y * width];
    }

    int[] createCircularMask(int width, double radius) {
        if (radius >= 1.5 && radius < 1.75) {
            radius = 1.75;
        } else if (radius >= 2.5 && radius < 2.85) {
            radius = 2.85;
        }
        int[] mask = new int[width * width];
        int r = width / 2;
        int r2 = (int)(radius * radius) + 1;
        for (int x = -r; x <= r; ++x) {
            for (int y = -r; y <= r; ++y) {
                if (x * x + y * y > r2) continue;
                mask[r + x + (r + y) * width] = 1;
            }
        }
        return mask;
    }

    private final float findMedian(float[] a) {
        int nValues = a.length;
        int nv1b2 = (nValues - 1) / 2;
        int l = 0;
        int m = nValues - 1;
        float med = a[nv1b2];
        while (l < m) {
            int i = l;
            int j = m;
            while (true) {
                if (a[i] < med) {
                    ++i;
                    continue;
                }
                while (med < a[j]) {
                    --j;
                }
                float dum = a[j];
                a[j] = a[i];
                a[i] = dum;
                if (--j < nv1b2 || ++i > nv1b2) break;
            }
            if (j < nv1b2) {
                l = i;
            }
            if (nv1b2 < i) {
                m = j;
            }
            med = a[nv1b2];
        }
        return med;
    }

    private final float findMin(float[] values) {
        float min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private final float findMax(float[] values) {
        float max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    private final float findMean(float[] values) {
        float sum = values[0];
        for (int i = 1; i < values.length; ++i) {
            sum += values[i];
        }
        return sum / (float)values.length;
    }

    private final float findVariance(float[] values) {
        double sum = 0.0;
        double sum2 = 0.0;
        float min = this.findMin(values);
        int n = values.length;
        for (int i = 1; i < n; ++i) {
            double v = values[i] - min;
            sum += v;
            sum2 += v * v;
        }
        double variance = ((double)n * sum2 - sum * sum) / (double)n;
        return (float)variance;
    }
}

