/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.ViewRequest;
import org.netbeans.core.windows.ViewRequestor;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WindowSystemSnapshot;
import org.netbeans.core.windows.model.DockingStatus;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.model.ModelFactory;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.view.ControllerHandler;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Central
implements ControllerHandler {
    private final Model model = ModelFactory.createWindowSystemModel();
    private final ViewRequestor viewRequestor = new ViewRequestor(this);

    public void topComponentRequestAttention(ModeImpl mode, TopComponent tc) {
        String modeName = this.getModeName(mode);
        this.viewRequestor.scheduleRequest(new ViewRequest(modeName, 63, tc, tc));
    }

    public void topComponentCancelRequestAttention(ModeImpl mode, TopComponent tc) {
        String modeName = this.getModeName(mode);
        this.viewRequestor.scheduleRequest(new ViewRequest(modeName, 64, tc, tc));
    }

    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        this.model.setVisible(visible);
        this.viewRequestor.scheduleRequest(new ViewRequest(null, 0, null, visible));
    }

    public void setMainWindowBoundsJoined(Rectangle mainWindowBoundsJoined) {
        if (mainWindowBoundsJoined == null) {
            return;
        }
        Rectangle old = this.getMainWindowBoundsJoined();
        if (old.equals(mainWindowBoundsJoined)) {
            return;
        }
        this.model.setMainWindowBoundsJoined(mainWindowBoundsJoined);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 1, old, mainWindowBoundsJoined));
        }
    }

    public void setMainWindowBoundsSeparated(Rectangle mainWindowBoundsSeparated) {
        if (mainWindowBoundsSeparated == null) {
            return;
        }
        Rectangle old = this.getMainWindowBoundsSeparated();
        if (old.equals(mainWindowBoundsSeparated)) {
            return;
        }
        this.model.setMainWindowBoundsSeparated(mainWindowBoundsSeparated);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 2, old, mainWindowBoundsSeparated));
        }
    }

    public void setMainWindowFrameStateJoined(int frameState) {
        int old = this.getMainWindowFrameStateJoined();
        if (old == frameState) {
            return;
        }
        this.model.setMainWindowFrameStateJoined(frameState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 3, old, frameState));
        }
    }

    public void setMainWindowFrameStateSeparated(int frameState) {
        int old = this.getMainWindowFrameStateSeparated();
        if (old == frameState) {
            return;
        }
        this.model.setMainWindowFrameStateSeparated(frameState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 4, old, frameState));
        }
    }

    public void setActiveMode(ModeImpl activeMode) {
        ModeImpl old = this.getActiveMode();
        if (activeMode == old) {
            boolean right;
            ModeImpl impl = this.model.getSlidingMode("bottom");
            boolean bottom = impl == null || impl.getSelectedTopComponent() == null;
            impl = this.model.getSlidingMode("left");
            boolean left = impl == null || impl.getSelectedTopComponent() == null;
            impl = this.model.getSlidingMode("right");
            boolean bl = right = impl == null || impl.getSelectedTopComponent() == null;
            if (bottom && left && right) {
                return;
            }
        }
        this.model.setActiveMode(activeMode);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 9, old, activeMode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", old, activeMode);
        if (activeMode != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(activeMode.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    public void setEditorAreaBounds(Rectangle editorAreaBounds) {
        if (editorAreaBounds == null) {
            return;
        }
        Rectangle old = this.getEditorAreaBounds();
        if (old.equals(editorAreaBounds)) {
            return;
        }
        this.model.setEditorAreaBounds(editorAreaBounds);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 7, old, editorAreaBounds));
        }
    }

    public void setEditorAreaConstraints(SplitConstraint[] editorAreaConstraints) {
        Object[] old = this.getEditorAreaConstraints();
        if (Arrays.equals(old, editorAreaConstraints)) {
            return;
        }
        this.model.setEditorAreaConstraints(editorAreaConstraints);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 8, old, editorAreaConstraints));
        }
    }

    public void setEditorAreaState(int editorAreaState) {
        int old = this.getEditorAreaState();
        if (editorAreaState == old) {
            return;
        }
        int requiredState = editorAreaState == 0 ? 0 : 1;
        for (ModeImpl modeImpl : this.getModes()) {
            if (modeImpl.getKind() == 0 && modeImpl.getState() != requiredState) {
                Rectangle bounds;
                this.model.setModeState(modeImpl, requiredState);
                if (editorAreaState == 1 && (bounds = this.model.getModeBounds(modeImpl)).isEmpty()) {
                    this.model.setModeBounds(modeImpl, this.model.getModeBoundsSeparatedHelp(modeImpl));
                }
            }
            if (modeImpl.getKind() != 2 || editorAreaState != 1) continue;
            TopComponent[] tcs = modeImpl.getTopComponents();
            for (int i = 0; i < tcs.length; ++i) {
                String tcID = WindowManagerImpl.getInstance().findTopComponentID(tcs[i]);
                ModeImpl targetMode = this.model.getModeTopComponentPreviousMode(modeImpl, tcID);
                if (targetMode == null || !this.model.getModes().contains(targetMode)) {
                    SplitConstraint[] constraints = this.model.getModeTopComponentPreviousConstraints(modeImpl, tcID);
                    constraints = constraints == null ? new SplitConstraint[]{} : constraints;
                    targetMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
                    this.model.setModeState(targetMode, requiredState);
                    this.model.addMode(targetMode, constraints);
                }
                this.moveTopComponentsIntoMode(targetMode, new TopComponent[]{tcs[i]});
            }
        }
        if (editorAreaState == 1) {
            Rectangle rectangle;
            Rectangle editorAreaBounds = this.model.getEditorAreaBounds();
            if (editorAreaBounds.isEmpty()) {
                this.model.setEditorAreaBounds(this.model.getEditorAreaBoundsHelp());
            }
            if ((rectangle = this.model.getMainWindowBoundsSeparated()).isEmpty()) {
                this.model.setMainWindowBoundsSeparated(this.model.getMainWindowBoundsSeparatedHelp());
            }
        }
        this.model.setEditorAreaState(editorAreaState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 5, old, editorAreaState));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("editorAreaState", old, editorAreaState);
    }

    public void setEditorAreaFrameState(int frameState) {
        int old = this.getEditorAreaFrameState();
        if (old == frameState) {
            return;
        }
        this.model.setEditorAreaFrameState(frameState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 6, old, frameState));
        }
    }

    void switchMaximizedMode(ModeImpl newMaximizedMode) {
        ModeImpl old = this.getCurrentMaximizedMode();
        if (newMaximizedMode == old) {
            return;
        }
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        if (null == newMaximizedMode) {
            if (this.isViewMaximized()) {
                if (this.isEditorMaximized()) {
                    this.restoreViews(this.model.getMaximizedDockingStatus());
                } else {
                    this.restoreViews(this.model.getDefaultDockingStatus());
                }
                ModeImpl currentMaximizedMode = this.getViewMaximizedMode();
                assert (currentMaximizedMode.getTopComponents().length == 1);
                TopComponent maximizedTC = currentMaximizedMode.getTopComponents()[0];
                String tcID = wm.findTopComponentID(maximizedTC);
                ModeImpl prevMode = this.getModeTopComponentPreviousMode(tcID, currentMaximizedMode);
                int prevIndex = this.model.getModeTopComponentPreviousIndex(currentMaximizedMode, tcID);
                if (null == prevMode) {
                    SplitConstraint[] constraints;
                    if (!(prevMode != null && this.model.getModes().contains(prevMode) || (constraints = this.model.getModeTopComponentPreviousConstraints(currentMaximizedMode, tcID)) == null)) {
                        prevMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
                        this.model.addMode(prevMode, constraints);
                    }
                    if (prevMode == null) {
                        prevMode = WindowManagerImpl.getInstance().getDefaultViewMode();
                    }
                }
                prevMode.addOpenedTopComponent(maximizedTC, prevIndex);
                prevMode.setSelectedTopComponent(maximizedTC);
                this.setActiveMode(prevMode);
                this.model.removeMode(currentMaximizedMode);
                this.setViewMaximizedMode(null);
            } else if (this.isEditorMaximized()) {
                this.model.getMaximizedDockingStatus().mark();
                ModeImpl prevActiveMode = this.getActiveMode();
                this.restoreViews(this.model.getDefaultDockingStatus());
                this.setEditorMaximizedMode(null);
                this.setActiveMode(prevActiveMode);
            }
        } else {
            assert (!this.isViewMaximized());
            if (newMaximizedMode.getKind() == 1) {
                this.model.getDefaultDockingStatus().mark();
                this.restoreViews(this.model.getMaximizedDockingStatus());
                this.setEditorMaximizedMode(newMaximizedMode);
            } else if (newMaximizedMode.getKind() == 0) {
                if (this.isEditorMaximized()) {
                    this.model.getMaximizedDockingStatus().mark();
                } else {
                    this.model.getDefaultDockingStatus().mark();
                }
                TopComponent tcToMaximize = newMaximizedMode.getSelectedTopComponent();
                String tcID = wm.findTopComponentID(tcToMaximize);
                int prevIndex = newMaximizedMode.getOpenedTopComponents().indexOf(tcToMaximize);
                ModeImpl mode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, true);
                this.model.addMode(mode, new SplitConstraint[0]);
                mode.addOpenedTopComponent(tcToMaximize);
                mode.setSelectedTopComponent(tcToMaximize);
                this.setModeTopComponentPreviousMode(tcID, mode, newMaximizedMode, prevIndex);
                this.setViewMaximizedMode(mode);
                this.slideAllViews();
                this.setActiveMode(mode);
            } else {
                throw new IllegalArgumentException("Cannot maximize a sliding view");
            }
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 11, old, this.getCurrentMaximizedMode()));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("maximizedMode", old, this.getCurrentMaximizedMode());
    }

    void setEditorMaximizedMode(ModeImpl editorMaximizedMode) {
        this.model.setEditorMaximizedMode(editorMaximizedMode);
    }

    void setViewMaximizedMode(ModeImpl viewMaximizedMode) {
        this.model.setViewMaximizedMode(viewMaximizedMode);
    }

    public void setModeConstraints(ModeImpl mode, SplitConstraint[] modeConstraints) {
        Object[] old = this.getModeConstraints(mode);
        if (Arrays.equals(modeConstraints, old)) {
            return;
        }
        this.model.setModeConstraints(mode, modeConstraints);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 14, old, modeConstraints));
        }
    }

    public void addMode(ModeImpl mode, SplitConstraint[] modeConstraints) {
        SplitConstraint[] old = this.getModeConstraints(mode);
        if (modeConstraints == old) {
            return;
        }
        this.model.addMode(mode, modeConstraints);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 12, null, mode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    public void removeMode(ModeImpl mode) {
        if (!this.getModes().contains(mode)) {
            return;
        }
        this.model.removeMode(mode);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 13, null, mode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    public void setToolbarConfigName(String toolbarConfigName) {
        String old = this.getToolbarConfigName();
        if (old.equals(toolbarConfigName)) {
            return;
        }
        this.model.setToolbarConfigName(toolbarConfigName);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 10, old, toolbarConfigName));
        }
    }

    public void updateUI() {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 61, null, null));
        }
    }

    private void closeMode(ModeImpl mode) {
        if (mode == null) {
            return;
        }
        TopComponent[] tcs = this.getModeOpenedTopComponents(mode).toArray(new TopComponent[0]);
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            if (WindowManagerImpl.getInstance().isTopComponentPersistentWhenClosed(tc)) {
                this.model.addModeClosedTopComponent(mode, tc);
                continue;
            }
            this.model.removeModeTopComponent(mode, tc);
            String id = WindowManagerImpl.getInstance().findTopComponentID(tc);
            PersistenceManager.getDefault().removeGlobalTopComponentID(id);
        }
        ModeImpl oldActive = this.getActiveMode();
        ModeImpl newActive = mode == oldActive ? this.setSomeModeActive() : oldActive;
        boolean modeRemoved = false;
        if (!mode.isPermanent() && this.model.getModeTopComponents(mode).isEmpty() && this.doCheckSlidingModes(mode)) {
            this.model.removeMode(mode);
            modeRemoved = true;
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 45, null, null));
        }
        for (int i = 0; i < tcs.length; ++i) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(tcs[i]);
        }
        if (oldActive != newActive) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActive, newActive);
        }
        if (modeRemoved) {
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        if (newActive != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(newActive.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    private ModeImpl setSomeModeActive() {
        for (ModeImpl modeImpl : this.getModes()) {
            if (modeImpl.getOpenedTopComponents().isEmpty() || 2 == modeImpl.getKind()) continue;
            this.model.setActiveMode(modeImpl);
            return modeImpl;
        }
        this.model.setActiveMode(null);
        return this.model.getActiveMode();
    }

    public void setModeBounds(ModeImpl mode, Rectangle bounds) {
        if (bounds == null) {
            return;
        }
        Rectangle old = this.getModeBounds(mode);
        if (old.equals(bounds)) {
            return;
        }
        this.model.setModeBounds(mode, bounds);
        if (this.isVisible() && this.getEditorAreaState() == 1) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 20, old, bounds));
        }
        mode.doFirePropertyChange("bounds", old, bounds);
    }

    public void setModeFrameState(ModeImpl mode, int frameState) {
        int old = this.getModeFrameState(mode);
        if (frameState == old) {
            return;
        }
        this.model.setModeFrameState(mode, frameState);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 21, old, frameState));
        }
    }

    public void setModeSelectedTopComponent(ModeImpl mode, TopComponent selected) {
        if (!(mode.getKind() == 2 && selected == null || this.getModeOpenedTopComponents(mode).contains(selected))) {
            return;
        }
        TopComponent old = this.getModeSelectedTopComponent(mode);
        if (selected == old) {
            return;
        }
        this.model.setModeSelectedTopComponent(mode, selected);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 22, old, selected));
        }
        if (mode == this.getActiveMode()) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(selected);
        }
    }

    public void setModePreviousSelectedTopComponent(ModeImpl mode, TopComponent tc) {
        this.model.setModePreviousSelectedTopComponent(mode, tc);
    }

    public void addModeOpenedTopComponent(ModeImpl mode, TopComponent tc) {
        if (this.getModeOpenedTopComponents(mode).contains(tc)) {
            return;
        }
        this.removeTopComponentFromOtherModes(mode, tc);
        this.model.addModeOpenedTopComponent(mode, tc);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 23, null, tc));
        }
        WindowManagerImpl.getInstance().notifyTopComponentOpened(tc);
    }

    public void insertModeOpenedTopComponent(ModeImpl mode, TopComponent tc, int index) {
        List<TopComponent> openedTcs = this.getModeOpenedTopComponents(mode);
        if (index >= 0 && !openedTcs.isEmpty() && openedTcs.size() > index && openedTcs.get(index) == tc) {
            return;
        }
        this.removeTopComponentFromOtherModes(mode, tc);
        this.model.insertModeOpenedTopComponent(mode, tc, index);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 23, null, tc));
        }
    }

    public void addModeClosedTopComponent(ModeImpl mode, TopComponent tc) {
        boolean opened = this.getModeOpenedTopComponents(mode).contains(tc);
        if (opened && !tc.canClose()) {
            return;
        }
        if (this.containsModeTopComponent(mode, tc) && !opened) {
            return;
        }
        this.removeTopComponentFromOtherModes(mode, tc);
        this.model.addModeClosedTopComponent(mode, tc);
        ModeImpl oldActive = this.getActiveMode();
        ModeImpl newActive = this.model.getModeOpenedTopComponents(mode).isEmpty() && mode == oldActive ? this.setSomeModeActive() : oldActive;
        if (this.getCurrentMaximizedMode() == mode && this.model.getModeOpenedTopComponents(mode).isEmpty()) {
            this.switchMaximizedMode(null);
        }
        if (this.isVisible() && opened) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 24, null, tc));
        }
        if (opened) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(tc);
        }
        if (oldActive != newActive) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActive, newActive);
        }
        if (newActive != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(newActive.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    public void addModeUnloadedTopComponent(ModeImpl mode, String tcID) {
        this.model.addModeUnloadedTopComponent(mode, tcID);
    }

    public void setUnloadedSelectedTopComponent(ModeImpl mode, String tcID) {
        this.model.setModeUnloadedSelectedTopComponent(mode, tcID);
    }

    public void setUnloadedPreviousSelectedTopComponent(ModeImpl mode, String tcID) {
        this.model.setModeUnloadedPreviousSelectedTopComponent(mode, tcID);
    }

    public List<String> getModeOpenedTopComponentsIDs(ModeImpl mode) {
        return this.model.getModeOpenedTopComponentsIDs(mode);
    }

    public List getModeClosedTopComponentsIDs(ModeImpl mode) {
        return this.model.getModeClosedTopComponentsIDs(mode);
    }

    public List getModeTopComponentsIDs(ModeImpl mode) {
        return this.model.getModeTopComponentsIDs(mode);
    }

    private boolean removeTopComponentFromOtherModes(ModeImpl mode, TopComponent tc) {
        boolean tcRemoved = false;
        for (ModeImpl m : this.model.getModes()) {
            if (m == mode || !this.model.containsModeTopComponent(m, tc)) continue;
            tcRemoved = true;
            this.model.removeModeTopComponent(m, tc);
            boolean modeRemoved = false;
            if (!m.isPermanent() && m.isEmpty() && this.doCheckSlidingModes(m) && mode.getKind() != 2) {
                this.model.removeMode(m);
                modeRemoved = true;
            }
            if (!modeRemoved) continue;
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        return tcRemoved;
    }

    public void removeModeTopComponent(ModeImpl mode, TopComponent tc) {
        if (!this.containsModeTopComponent(mode, tc)) {
            return;
        }
        boolean viewChange = this.getModeOpenedTopComponents(mode).contains(tc);
        if (viewChange && !tc.canClose()) {
            return;
        }
        this.model.removeModeTopComponent(mode, tc);
        String id = WindowManagerImpl.getInstance().findTopComponentID(tc);
        PersistenceManager.getDefault().removeGlobalTopComponentID(id);
        ModeImpl oldActive = this.getActiveMode();
        ModeImpl newActive = this.model.getModeOpenedTopComponents(mode).isEmpty() && mode == oldActive ? this.setSomeModeActive() : oldActive;
        if (this.getCurrentMaximizedMode() == mode && this.model.getModeOpenedTopComponents(mode).isEmpty()) {
            this.switchMaximizedMode(null);
        }
        boolean modeRemoved = false;
        if (!mode.isPermanent() && this.model.getModeTopComponents(mode).isEmpty() && this.doCheckSlidingModes(mode)) {
            this.model.removeMode(mode);
            modeRemoved = true;
        }
        if (viewChange && this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 24, null, tc));
        }
        if (viewChange) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(tc);
        }
        if (oldActive != newActive) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActive, newActive);
        }
        if (modeRemoved) {
            WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        }
        if (newActive != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(newActive.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    private boolean doCheckSlidingModes(ModeImpl mode) {
        ModeImpl impl;
        String tcID;
        int i;
        TopComponent[] tcs;
        ModeImpl slid = this.model.getSlidingMode("bottom");
        if (slid != null) {
            tcs = slid.getTopComponents();
            for (i = 0; i < tcs.length; ++i) {
                tcID = WindowManagerImpl.getInstance().findTopComponentID(tcs[i]);
                impl = this.model.getModeTopComponentPreviousMode(slid, tcID);
                if (impl != mode) continue;
                return false;
            }
        }
        if ((slid = this.model.getSlidingMode("left")) != null) {
            tcs = slid.getTopComponents();
            for (i = 0; i < tcs.length; ++i) {
                tcID = WindowManagerImpl.getInstance().findTopComponentID(tcs[i]);
                impl = this.model.getModeTopComponentPreviousMode(slid, tcID);
                if (impl != mode) continue;
                return false;
            }
        }
        if ((slid = this.model.getSlidingMode("right")) != null) {
            tcs = slid.getTopComponents();
            for (i = 0; i < tcs.length; ++i) {
                tcID = WindowManagerImpl.getInstance().findTopComponentID(tcs[i]);
                impl = this.model.getModeTopComponentPreviousMode(slid, tcID);
                if (impl != mode) continue;
                return false;
            }
        }
        return true;
    }

    public void removeModeClosedTopComponentID(ModeImpl mode, String tcID) {
        this.model.removeModeClosedTopComponentID(mode, tcID);
    }

    public boolean isGroupOpened(TopComponentGroupImpl tcGroup) {
        return this.model.isGroupOpened(tcGroup);
    }

    public void openGroup(TopComponentGroupImpl tcGroup) {
        if (this.isGroupOpened(tcGroup)) {
            return;
        }
        if (this.isEditorMaximized() && this.isViewMaximized()) {
            this.switchMaximizedMode(null);
        }
        HashSet<TopComponent> openedBeforeTopComponents = new HashSet<TopComponent>();
        Set<TopComponent> tcs = tcGroup.getTopComponents();
        for (TopComponent tc : tcs) {
            if (!tc.isOpened()) continue;
            openedBeforeTopComponents.add(tc);
        }
        tcs = tcGroup.getOpeningSet();
        HashSet<ModeImpl> openedModes = new HashSet<ModeImpl>(tcs.size());
        ArrayList<TopComponent> openedTcs = new ArrayList<TopComponent>();
        for (TopComponent tc : tcs) {
            String tcID;
            if (tc.isOpened()) continue;
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            ModeImpl mode = (ModeImpl)wm.findMode(tc);
            if (mode == null) {
                mode = wm.getDefaultViewMode();
            } else if (mode.getOpenedTopComponentsIDs().isEmpty()) {
                openedModes.add(mode);
            }
            this.model.addModeOpenedTopComponent(mode, tc);
            if (this.isEditorMaximized() && mode.getState() != 1 && !this.isTopComponentDockedInMaximizedMode(tcID = wm.findTopComponentID(tc)) && mode.getKind() != 2) {
                this.slide(tc, mode, this.getSlideSideForMode(mode));
            }
            openedTcs.add(tc);
        }
        this.model.openGroup(tcGroup, new HashSet<TopComponent>(openedTcs), openedBeforeTopComponents);
        for (ModeImpl mode : openedModes) {
            TopComponent prevSelTC = mode.getPreviousSelectedTopComponent();
            if (null == prevSelTC) continue;
            mode.setSelectedTopComponent(prevSelTC);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(tcGroup, 42, null, openedTcs.toArray(new TopComponent[0])));
        }
        for (TopComponent tc : openedTcs) {
            WindowManagerImpl.getInstance().notifyTopComponentOpened(tc);
        }
    }

    public void closeGroup(TopComponentGroupImpl tcGroup) {
        if (!this.isGroupOpened(tcGroup)) {
            return;
        }
        Set tcs = tcGroup.getClosingSet();
        ArrayList<TopComponent> closedTcs = new ArrayList<TopComponent>();
        Set<TopComponent> openedTcsByGroup = this.model.getGroupOpenedTopComponents(tcGroup);
        Set<TopComponent> openedTcsBefore = this.model.getGroupOpenedBeforeTopComponents(tcGroup);
        for (TopComponent tc : this.model.getGroupTopComponents(tcGroup)) {
            boolean wasOpenedBefore = openedTcsBefore.contains(tc);
            boolean openedByGroup = openedTcsByGroup.contains(tc);
            if (tc.isOpened()) {
                if (wasOpenedBefore || openedByGroup) continue;
                this.model.addGroupOpeningTopComponent(tcGroup, tc);
                continue;
            }
            if (!wasOpenedBefore && !openedByGroup) continue;
            this.model.removeGroupOpeningTopComponent(tcGroup, tc);
        }
        ArrayList<ModeImpl> groupModes = new ArrayList<ModeImpl>(tcs.size());
        for (TopComponent tc : tcs) {
            ModeImpl mode;
            if (!tc.isOpened() || openedTcsBefore.contains(tc) || null == (mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tc))) continue;
            groupModes.add(mode);
        }
        for (ModeImpl mode : groupModes) {
            TopComponent selTC = mode.getSelectedTopComponent();
            if (null == selTC) continue;
            this.setModePreviousSelectedTopComponent(mode, selTC);
        }
        for (TopComponent tc : tcs) {
            ModeImpl mode;
            if (!tc.isOpened() || openedTcsBefore.contains(tc)) continue;
            boolean ignore = false;
            for (TopComponentGroupImpl group : this.model.getTopComponentGroups()) {
                if (group == tcGroup || !group.isOpened() || !group.getOpeningSet().contains(tc)) continue;
                ignore = true;
                break;
            }
            if (ignore || (mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tc)) == null) continue;
            if (WindowManagerImpl.getInstance().isTopComponentPersistentWhenClosed(tc)) {
                this.model.addModeClosedTopComponent(mode, tc);
            } else {
                this.model.removeModeTopComponent(mode, tc);
                String id = WindowManagerImpl.getInstance().findTopComponentID(tc);
                PersistenceManager.getDefault().removeGlobalTopComponentID(id);
            }
            closedTcs.add(tc);
        }
        this.model.closeGroup(tcGroup);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(tcGroup, 43, null, closedTcs.toArray(new TopComponent[0])));
        }
        for (TopComponent tc : closedTcs) {
            WindowManagerImpl.getInstance().notifyTopComponentClosed(tc);
        }
    }

    public void addTopComponentGroup(TopComponentGroupImpl tcGroup) {
        this.model.addTopComponentGroup(tcGroup);
    }

    public void removeTopComponentGroup(TopComponentGroupImpl tcGroup) {
        this.model.removeTopComponentGroup(tcGroup);
    }

    public boolean addGroupUnloadedTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.addGroupUnloadedTopComponent(tcGroup, tcID);
    }

    public boolean removeGroupUnloadedTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.removeGroupUnloadedTopComponent(tcGroup, tcID);
    }

    public boolean addGroupUnloadedOpeningTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.addGroupUnloadedOpeningTopComponent(tcGroup, tcID);
    }

    public boolean removeGroupUnloadedOpeningTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.removeGroupUnloadedOpeningTopComponent(tcGroup, tcID);
    }

    public boolean addGroupUnloadedClosingTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.addGroupUnloadedClosingTopComponent(tcGroup, tcID);
    }

    public boolean removeGroupUnloadedClosingTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        return this.model.removeGroupUnloadedClosingTopComponent(tcGroup, tcID);
    }

    public boolean addGroupUnloadedOpenedTopComponent(TopComponentGroupImpl tcGroup, String tcID) {
        if (!this.isGroupOpened(tcGroup)) {
            return false;
        }
        return this.model.addGroupUnloadedOpenedTopComponent(tcGroup, tcID);
    }

    public Set getGroupOpenedTopComponents(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupOpenedTopComponents(tcGroup);
    }

    public Set<String> getGroupTopComponentsIDs(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupTopComponentsIDs(tcGroup);
    }

    public Set<String> getGroupOpeningSetIDs(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupOpeningSetIDs(tcGroup);
    }

    public Set<String> getGroupClosingSetIDs(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupClosingSetIDs(tcGroup);
    }

    public Set<String> getGroupOpenedTopComponentsIDs(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupOpenedTopComponentsIDs(tcGroup);
    }

    public boolean isVisible() {
        return this.model.isVisible();
    }

    public Set<? extends Mode> getModes() {
        return this.model.getModes();
    }

    public Rectangle getMainWindowBoundsJoined() {
        return this.model.getMainWindowBoundsJoined();
    }

    public Rectangle getMainWindowBoundsSeparated() {
        return this.model.getMainWindowBoundsSeparated();
    }

    public int getMainWindowFrameStateJoined() {
        return this.model.getMainWindowFrameStateJoined();
    }

    public int getMainWindowFrameStateSeparated() {
        return this.model.getMainWindowFrameStateSeparated();
    }

    public ModeImpl getActiveMode() {
        return this.model.getActiveMode();
    }

    public Rectangle getEditorAreaBounds() {
        return this.model.getEditorAreaBounds();
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.model.getEditorAreaConstraints();
    }

    public int getEditorAreaState() {
        return this.model.getEditorAreaState();
    }

    public int getEditorAreaFrameState() {
        return this.model.getEditorAreaFrameState();
    }

    public Component getEditorAreaComponent() {
        return this.viewRequestor.getEditorAreaComponent();
    }

    ModeImpl getCurrentMaximizedMode() {
        if (this.isViewMaximized()) {
            return this.model.getViewMaximizedMode();
        }
        if (this.isEditorMaximized()) {
            return this.model.getEditorMaximizedMode();
        }
        return null;
    }

    ModeImpl getEditorMaximizedMode() {
        return this.model.getEditorMaximizedMode();
    }

    ModeImpl getViewMaximizedMode() {
        return this.model.getViewMaximizedMode();
    }

    public SplitConstraint[] getModeConstraints(ModeImpl mode) {
        return this.model.getModeConstraints(mode);
    }

    public String getToolbarConfigName() {
        return this.model.getToolbarConfigName();
    }

    public String getModeName(ModeImpl mode) {
        return this.model.getModeName(mode);
    }

    public Rectangle getModeBounds(ModeImpl mode) {
        return this.model.getModeBounds(mode);
    }

    public int getModeState(ModeImpl mode) {
        return this.model.getModeState(mode);
    }

    public int getModeKind(ModeImpl mode) {
        return this.model.getModeKind(mode);
    }

    public String getModeSide(ModeImpl mode) {
        return this.model.getModeSide(mode);
    }

    public int getModeFrameState(ModeImpl mode) {
        return this.model.getModeFrameState(mode);
    }

    public boolean isModePermanent(ModeImpl mode) {
        return this.model.isModePermanent(mode);
    }

    public boolean isModeEmpty(ModeImpl mode) {
        return this.model.isModeEmpty(mode);
    }

    public boolean containsModeTopComponent(ModeImpl mode, TopComponent tc) {
        return this.model.containsModeTopComponent(mode, tc);
    }

    public TopComponent getModeSelectedTopComponent(ModeImpl mode) {
        return this.model.getModeSelectedTopComponent(mode);
    }

    public TopComponent getModePreviousSelectedTopComponent(ModeImpl mode) {
        return this.model.getModePreviousSelectedTopComponent(mode);
    }

    public List<TopComponent> getModeTopComponents(ModeImpl mode) {
        return this.model.getModeTopComponents(mode);
    }

    public List<TopComponent> getModeOpenedTopComponents(ModeImpl mode) {
        return this.model.getModeOpenedTopComponents(mode);
    }

    public int getModeTopComponentTabPosition(ModeImpl mode, TopComponent tc) {
        return this.model.getModeOpenedTopComponentTabPosition(mode, tc);
    }

    public Set<TopComponentGroupImpl> getTopComponentGroups() {
        return this.model.getTopComponentGroups();
    }

    public String getGroupName(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupName(tcGroup);
    }

    public Set<TopComponent> getGroupTopComponents(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupTopComponents(tcGroup);
    }

    public Set<TopComponent> getGroupOpeningTopComponents(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupOpeningTopComponents(tcGroup);
    }

    public Set getGroupClosingTopComponents(TopComponentGroupImpl tcGroup) {
        return this.model.getGroupClosingTopComponents(tcGroup);
    }

    public void topComponentDisplayNameChanged(ModeImpl mode, TopComponent tc) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 31, null, tc));
        }
    }

    public void topComponentDisplayNameAnnotation(ModeImpl mode, TopComponent tc) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 32, null, tc));
        }
    }

    public void topComponentToolTipChanged(ModeImpl mode, TopComponent tc) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 33, null, tc));
        }
    }

    public void topComponentIconChanged(ModeImpl mode, TopComponent tc) {
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 34, null, tc));
        }
    }

    public void resetModel() {
        this.model.reset();
    }

    public void attachTopComponentsToSide(TopComponent[] tcs, ModeImpl attachMode, String side) {
        this.attachTopComponentsToSide(tcs, attachMode, side, true);
    }

    private void attachTopComponentsToSide(TopComponent[] tcs, ModeImpl attachMode, String side, boolean fireEvents) {
        if (tcs == null || tcs.length == 0) {
            return;
        }
        ModeImpl newMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), attachMode.getKind(), false);
        if (!newMode.canContain(tcs[0])) {
            return;
        }
        this.model.addModeToSide(newMode, attachMode, side);
        this.attachTopComponentsHelper(tcs, newMode, fireEvents);
    }

    private void attachTopComponentsAroundDesktop(TopComponent[] tcs, String side, boolean fireEvents) {
        if (tcs == null || tcs.length == 0) {
            return;
        }
        ModeImpl newMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 0, false);
        if (!newMode.canContain(tcs[0])) {
            return;
        }
        this.model.addModeAround(newMode, side);
        this.attachTopComponentsHelper(tcs, newMode, fireEvents);
    }

    private void attachTopComponentsAroundEditor(TopComponent[] tcs, String side, boolean fireEvents, int modeKind) {
        if (tcs == null || tcs.length == 0) {
            return;
        }
        ModeImpl newMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), modeKind, false);
        if (!newMode.canContain(tcs[0])) {
            return;
        }
        this.model.addModeAroundEditor(newMode, side);
        this.attachTopComponentsHelper(tcs, newMode, fireEvents);
    }

    private void attachTopComponentsIntoNewMode(TopComponent[] tcs, Rectangle bounds, int modeKind, int modeState) {
        if (tcs == null || tcs.length == 0) {
            return;
        }
        WindowManagerImpl wmi = WindowManagerImpl.getInstance();
        ModeImpl newMode = wmi.createModeImpl(ModeImpl.getUnusedModeName(), modeKind, modeState, false);
        newMode.setBounds(bounds);
        if (!newMode.canContain(tcs[0])) {
            return;
        }
        this.model.addMode(newMode, new SplitConstraint[]{new SplitConstraint(1, 100, 0.5)});
        if (modeState == 1) {
            for (int i = 0; i < tcs.length; ++i) {
                ModeImpl prevMode = (ModeImpl)wmi.findMode(tcs[i]);
                String tcID = wmi.findTopComponentID(tcs[i]);
                if (prevMode.getState() == 1) {
                    prevMode = this.model.getModeTopComponentPreviousMode(prevMode, tcID);
                }
                int prevIndex = prevMode.getOpenedTopComponentsIDs().indexOf(tcID);
                if (prevMode == null) continue;
                this.model.setModeTopComponentPreviousMode(newMode, tcID, prevMode, prevIndex);
                this.model.setModeTopComponentPreviousConstraints(newMode, wmi.findTopComponentID(tcs[i]), prevMode.getConstraints());
            }
        }
        this.attachTopComponentsHelper(tcs, newMode, true);
    }

    private void attachTopComponentsHelper(TopComponent[] tcs, ModeImpl newMode, boolean fireEvents) {
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            this.removeTopComponentFromOtherModes(newMode, tc);
            this.model.addModeOpenedTopComponent(newMode, tc);
        }
        ModeImpl oldActiveMode = this.getActiveMode();
        this.model.setActiveMode(newMode);
        this.model.setModeSelectedTopComponent(newMode, tcs[0]);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(tcs[0], 41, null, newMode));
        }
        if (!fireEvents) {
            return;
        }
        WindowManagerImpl.notifyRegistryTopComponentActivated(tcs[0]);
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
        if (oldActiveMode != newMode) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActiveMode, newMode);
        }
    }

    public void activateModeTopComponent(ModeImpl mode, TopComponent tc) {
        if (!this.getModeOpenedTopComponents(mode).contains(tc)) {
            return;
        }
        ModeImpl oldActiveMode = this.getActiveMode();
        if (oldActiveMode != null && oldActiveMode.equals(mode) && tc != null && tc.equals(this.model.getModeSelectedTopComponent(mode))) {
            return;
        }
        this.model.setActiveMode(mode);
        this.model.setModeSelectedTopComponent(mode, tc);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(mode, 44, null, tc));
        }
        WindowManagerImpl.notifyRegistryTopComponentActivated(tc);
        if (oldActiveMode != mode) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActiveMode, mode);
        }
    }

    public boolean isDragInProgress() {
        return this.viewRequestor.isDragInProgress();
    }

    public Frame getMainWindow() {
        return this.viewRequestor.getMainWindow();
    }

    public String guessSlideSide(TopComponent tc) {
        return this.viewRequestor.guessSlideSide(tc);
    }

    String getSlideSideForMode(ModeImpl mode) {
        return this.model.getSlideSideForMode(mode);
    }

    public boolean isDocked(TopComponent comp) {
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(comp);
        return mode != null && mode.getState() == 0;
    }

    public void createModeModel(ModeImpl mode, String name, int state, int kind, boolean permanent) {
        this.model.createModeModel(mode, name, state, kind, permanent);
    }

    public void createGroupModel(TopComponentGroupImpl tcGroup, String name, boolean opened) {
        this.model.createGroupModel(tcGroup, name, opened);
    }

    public WindowSystemSnapshot createWindowSystemSnapshot() {
        return this.model.createWindowSystemSnapshot();
    }

    @Override
    public void userActivatedMode(ModeImpl mode) {
        if (mode != null) {
            this.setActiveMode(mode);
        }
    }

    @Override
    public void userActivatedModeWindow(ModeImpl mode) {
        if (mode != null) {
            this.setActiveMode(mode);
        }
    }

    @Override
    public void userActivatedEditorWindow() {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        TopComponent[] tcs = wm.getRecentViewList();
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            ModeImpl mode = (ModeImpl)wm.findMode(tc);
            if (mode == null || mode.getKind() != 1 || mode.getOpenedTopComponents().isEmpty()) continue;
            this.setActiveMode(mode);
            return;
        }
        ModeImpl mode = wm.getDefaultEditorMode();
        if (mode != null && !mode.getOpenedTopComponents().isEmpty()) {
            this.setActiveMode(mode);
        } else {
            this.setActiveMode(null);
        }
    }

    @Override
    public void userActivatedTopComponent(ModeImpl mode, TopComponent selected) {
        if (mode != null) {
            this.setModeSelectedTopComponent(mode, selected);
        }
    }

    @Override
    public void userResizedMainWindow(Rectangle bounds) {
        if (this.getEditorAreaState() == 0) {
            this.model.setMainWindowBoundsJoined(bounds);
        } else {
            this.model.setMainWindowBoundsSeparated(bounds);
        }
    }

    @Override
    public void userResizedMainWindowBoundsSeparatedHelp(Rectangle bounds) {
        if (this.getEditorAreaState() == 0 && this.getMainWindowBoundsSeparated().isEmpty()) {
            this.model.setMainWindowBoundsUserSeparatedHelp(bounds);
        }
    }

    @Override
    public void userResizedEditorArea(Rectangle bounds) {
        this.model.setEditorAreaBounds(bounds);
    }

    @Override
    public void userResizedEditorAreaBoundsHelp(Rectangle bounds) {
        if (this.getEditorAreaState() == 0 && this.getEditorAreaBounds().isEmpty()) {
            this.model.setEditorAreaBoundsUserHelp(bounds);
        }
    }

    @Override
    public void userResizedModeBounds(ModeImpl mode, Rectangle bounds) {
        Rectangle old = this.model.getModeBounds(mode);
        this.model.setModeBounds(mode, bounds);
        mode.doFirePropertyChange("bounds", old, bounds);
    }

    @Override
    public void userResizedModeBoundsSeparatedHelp(ModeImpl mode, Rectangle bounds) {
        this.model.setModeBoundsSeparatedHelp(mode, bounds);
    }

    @Override
    public void userChangedFrameStateMainWindow(int frameState) {
        if (this.getEditorAreaState() == 0) {
            this.model.setMainWindowFrameStateJoined(frameState);
        } else {
            this.model.setMainWindowFrameStateSeparated(frameState);
        }
    }

    @Override
    public void userChangedFrameStateEditorArea(int frameState) {
        this.model.setEditorAreaFrameState(frameState);
    }

    @Override
    public void userChangedFrameStateMode(ModeImpl mode, int frameState) {
        this.model.setModeFrameState(mode, frameState);
    }

    @Override
    public void userChangedSplit(ModelElement[] snapshots, double[] splitWeights) {
        this.model.setSplitWeights(snapshots, splitWeights);
    }

    @Override
    public void userClosedTopComponent(ModeImpl mode, TopComponent tc) {
        if (WindowManagerImpl.getInstance().isTopComponentPersistentWhenClosed(tc)) {
            this.addModeClosedTopComponent(mode, tc);
        } else {
            this.removeModeTopComponent(mode, tc);
        }
        if (mode.getOpenedTopComponents().isEmpty() && mode == this.getCurrentMaximizedMode()) {
            this.switchMaximizedMode(null);
        }
    }

    @Override
    public void userClosedMode(ModeImpl mode) {
        if (mode != null) {
            this.closeMode(mode);
            if (mode.getOpenedTopComponents().isEmpty() && mode == this.getCurrentMaximizedMode()) {
                this.switchMaximizedMode(null);
            }
        }
    }

    @Override
    public void userDroppedTopComponents(ModeImpl mode, TopComponent[] tcs) {
        this.updateViewAfterDnD(this.moveTopComponentsIntoMode(mode, tcs));
    }

    @Override
    public void userDroppedTopComponents(ModeImpl mode, TopComponent[] tcs, int index) {
        this.updateViewAfterDnD(this.moveTopComponentsIntoMode(mode, tcs, index));
    }

    @Override
    public void userDroppedTopComponents(ModeImpl mode, TopComponent[] tcs, String side) {
        this.attachTopComponentsToSide(tcs, mode, side, false);
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDroppedTopComponentsIntoEmptyEditor(TopComponent[] tcs) {
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode("editor");
        this.moveTopComponentsIntoMode(mode, tcs);
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDroppedTopComponentsAround(TopComponent[] tcs, String side) {
        this.attachTopComponentsAroundDesktop(tcs, side, false);
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDroppedTopComponentsAroundEditor(TopComponent[] tcs, String side, int modeKind) {
        this.attachTopComponentsAroundEditor(tcs, side, false, modeKind);
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDroppedTopComponentsIntoFreeArea(TopComponent[] tcs, Rectangle bounds, int modeKind) {
        this.attachTopComponentsIntoNewMode(tcs, bounds, modeKind, 1);
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userUndockedTopComponent(TopComponent tc, int modeKind) {
        Point tcLoc = tc.getLocation();
        Dimension tcSize = tc.getSize();
        SwingUtilities.convertPointToScreen(tcLoc, (Component)tc);
        Rectangle bounds = new Rectangle(tcLoc, tcSize);
        if (modeKind == 2) {
            modeKind = 0;
        }
        this.attachTopComponentsIntoNewMode(new TopComponent[]{tc}, bounds, modeKind, 1);
        this.updateViewAfterDnD(true);
    }

    @Override
    public void userDockedTopComponent(TopComponent tc, int modeKind) {
        SplitConstraint[] constraints;
        ModeImpl dockTo = null;
        String tcID = WindowManagerImpl.getInstance().findTopComponentID(tc);
        ModeImpl source = (ModeImpl)WindowManagerImpl.getInstance().findMode(tc);
        dockTo = this.model.getModeTopComponentPreviousMode(source, tcID);
        int dockIndex = this.model.getModeTopComponentPreviousIndex(source, tcID);
        if (!(dockTo != null && this.model.getModes().contains(dockTo) || (constraints = this.model.getModeTopComponentPreviousConstraints(source, tcID)) == null)) {
            dockTo = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), modeKind, false);
            this.model.addMode(dockTo, constraints);
        }
        if (dockTo == null) {
            dockTo = modeKind == 1 ? WindowManagerImpl.getInstance().getDefaultEditorMode() : WindowManagerImpl.getInstance().getDefaultViewMode();
        }
        this.updateViewAfterDnD(this.moveTopComponentsIntoMode(dockTo, new TopComponent[]{tc}, dockIndex));
    }

    private boolean moveTopComponentsIntoMode(ModeImpl mode, TopComponent[] tcs) {
        return this.moveTopComponentsIntoMode(mode, tcs, -1);
    }

    private boolean moveTopComponentsIntoMode(ModeImpl mode, TopComponent[] tcs, int index) {
        boolean moved = false;
        boolean intoSliding = mode.getKind() == 2;
        boolean intoSeparate = mode.getState() == 1;
        ModeImpl prevMode = null;
        for (int i = 0; i < tcs.length; ++i) {
            int prevIndex;
            TopComponent tc = tcs[i];
            String tcID = WindowManagerImpl.getInstance().findTopComponentID(tc);
            if (!mode.canContain(tc)) continue;
            for (ModeImpl m : this.model.getModes()) {
                if (!this.model.containsModeTopComponent(m, tc)) continue;
                if (m.getKind() == 2 || m.getState() == 1) {
                    prevMode = this.model.getModeTopComponentPreviousMode(m, tcID);
                    break;
                }
                prevMode = m;
                break;
            }
            int n = prevIndex = prevMode != null && (intoSliding || intoSeparate) ? prevMode.getOpenedTopComponentsIDs().indexOf(tcID) : -1;
            if (this.removeTopComponentFromOtherModes(mode, tc)) {
                moved = true;
            }
            if (index > -1) {
                this.model.insertModeOpenedTopComponent(mode, tc, index);
            } else {
                this.model.addModeOpenedTopComponent(mode, tc);
            }
            if (prevMode == null || !intoSliding && !intoSeparate) continue;
            this.model.setModeTopComponentPreviousMode(mode, tcID, prevMode, prevIndex);
            this.model.setModeTopComponentPreviousConstraints(mode, tcID, this.model.getModeConstraints(prevMode));
        }
        if (!intoSliding) {
            this.model.setActiveMode(mode);
            this.model.setModeSelectedTopComponent(mode, tcs[tcs.length - 1]);
        } else {
            if (prevMode != null && prevMode == this.getActiveMode() && prevMode.getOpenedTopComponents().isEmpty()) {
                this.setSomeModeActive();
            }
            if (mode.getBounds().width == 0 && mode.getBounds().height == 0) {
                mode.setBounds(tcs[tcs.length - 1].getBounds());
            }
        }
        return moved;
    }

    private void updateViewAfterDnD(boolean unmaximize) {
        if (unmaximize) {
            this.switchMaximizedMode(null);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 46, null, null));
        }
    }

    public void addSlidingMode(ModeImpl mode, ModeImpl original, String side, Map<String, Integer> slideInSizes) {
        ModeImpl targetMode = this.model.getSlidingMode(side);
        if (targetMode != null) {
            return;
        }
        targetMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 2, false);
        this.model.addSlidingMode(mode, side, slideInSizes);
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 12, null, mode));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("modes", null, null);
    }

    @Override
    public void userEnabledAutoHide(TopComponent tc, ModeImpl source, String targetSide) {
        String tcID = WindowManagerImpl.getInstance().findTopComponentID(tc);
        if (this.isEditorMaximized()) {
            this.setTopComponentDockedInMaximizedMode(tcID, false);
        }
        this.slide(tc, source, targetSide);
    }

    void slide(TopComponent tc, ModeImpl source, String targetSide) {
        ModeImpl targetMode = this.model.getSlidingMode(targetSide);
        if (targetMode == null) {
            targetMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), 2, false);
            this.model.addSlidingMode(targetMode, targetSide, null);
            this.model.setModeBounds(targetMode, new Rectangle(tc.getBounds()));
        }
        ModeImpl oldActive = this.getActiveMode();
        this.moveTopComponentsIntoMode(targetMode, new TopComponent[]{tc});
        ModeImpl newActive = this.getActiveMode();
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 47, null, null));
        }
        if (oldActive != newActive) {
            WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", oldActive, newActive);
        }
        if (newActive != null) {
            WindowManagerImpl.notifyRegistryTopComponentActivated(newActive.getSelectedTopComponent());
        } else {
            WindowManagerImpl.notifyRegistryTopComponentActivated(null);
        }
    }

    @Override
    public void userResizedSlidingMode(ModeImpl mode, Rectangle rect) {
        this.model.setModeBounds(mode, new Rectangle(rect));
        String side = this.model.getSlidingModeConstraints(mode);
        this.model.setSlideInSize(side, mode.getSelectedTopComponent(), "bottom".equals(side) ? rect.height : rect.width);
        if (null != mode.getSelectedTopComponent()) {
            String tcID = WindowManagerImpl.getInstance().findTopComponentID(mode.getSelectedTopComponent());
            this.model.setTopComponentMaximizedWhenSlidedIn(tcID, false);
        }
    }

    @Override
    public void userDisabledAutoHide(TopComponent tc, ModeImpl source) {
        if (this.isViewMaximized()) {
            this.switchMaximizedMode(null);
        }
        String tcID = WindowManagerImpl.getInstance().findTopComponentID(tc);
        if (this.isEditorMaximized()) {
            this.setTopComponentDockedInMaximizedMode(tcID, true);
        }
        this.unSlide(tc, source);
    }

    private void unSlide(TopComponent tc, ModeImpl source) {
        SplitConstraint[] constraints;
        String tcID = WindowManagerImpl.getInstance().findTopComponentID(tc);
        ModeImpl targetMode = this.model.getModeTopComponentPreviousMode(source, tcID);
        int targetIndex = this.model.getModeTopComponentPreviousIndex(source, tcID);
        if (!(targetMode != null && this.model.getModes().contains(targetMode) || (constraints = this.model.getModeTopComponentPreviousConstraints(source, tcID)) == null)) {
            targetMode = WindowManagerImpl.getInstance().createModeImpl(ModeImpl.getUnusedModeName(), source.getKind(), false);
            this.model.addMode(targetMode, constraints);
        }
        if (targetMode == null) {
            targetMode = source.getKind() == 1 ? WindowManagerImpl.getInstance().getDefaultEditorMode() : WindowManagerImpl.getInstance().getDefaultViewMode();
        }
        this.moveTopComponentsIntoMode(targetMode, new TopComponent[]{tc}, targetIndex);
        if (source.isEmpty()) {
            this.model.removeMode(source);
        }
        if (this.isVisible()) {
            this.viewRequestor.scheduleRequest(new ViewRequest(null, 48, null, null));
        }
        WindowManagerImpl.getInstance().doFirePropertyChange("activeMode", null, this.getActiveMode());
    }

    public ModeImpl getModeTopComponentPreviousMode(String tcID, ModeImpl currentSlidingMode) {
        return this.model.getModeTopComponentPreviousMode(currentSlidingMode, tcID);
    }

    public int getModeTopComponentPreviousIndex(String tcID, ModeImpl currentSlidingMode) {
        return this.model.getModeTopComponentPreviousIndex(currentSlidingMode, tcID);
    }

    public void setModeTopComponentPreviousMode(String tcID, ModeImpl currentSlidingMode, ModeImpl prevMode, int prevIndex) {
        this.model.setModeTopComponentPreviousMode(currentSlidingMode, tcID, prevMode, prevIndex);
    }

    Map<String, Integer> getSlideInSizes(String side) {
        return this.model.getSlideInSizes(side);
    }

    void setTopComponentDockedInMaximizedMode(String tcID, boolean docked) {
        if (docked) {
            this.model.getMaximizedDockingStatus().addDocked(tcID);
        } else {
            this.model.getMaximizedDockingStatus().addSlided(tcID);
        }
    }

    boolean isTopComponentDockedInMaximizedMode(String tcID) {
        return this.model.getMaximizedDockingStatus().isDocked(tcID);
    }

    void setTopComponentSlidedInDefaultMode(String tcID, boolean slided) {
        if (slided) {
            this.model.getDefaultDockingStatus().addSlided(tcID);
        } else {
            this.model.getDefaultDockingStatus().addDocked(tcID);
        }
    }

    boolean isTopComponentMaximizedWhenSlidedIn(String tcID) {
        return this.model.isTopComponentMaximizedWhenSlidedIn(tcID);
    }

    void setTopComponentMaximizedWhenSlidedIn(String tcID, boolean maximized) {
        this.model.setTopComponentMaximizedWhenSlidedIn(tcID, maximized);
    }

    void userToggledTopComponentSlideInMaximize(String tcID) {
        this.setTopComponentMaximizedWhenSlidedIn(tcID, !this.isTopComponentMaximizedWhenSlidedIn(tcID));
        if (this.isVisible()) {
            TopComponent tc = WindowManagerImpl.getInstance().findTopComponent(tcID);
            ModeImpl mode = WindowManagerImpl.getInstance().findModeForOpenedID(tcID);
            if (null != tc && null != mode && null != mode.getSide()) {
                this.viewRequestor.scheduleRequest(new ViewRequest(tc, 65, null, mode.getSide()));
            }
        }
    }

    boolean isTopComponentSlidedInDefaultMode(String tcID) {
        return this.model.getDefaultDockingStatus().isSlided(tcID);
    }

    boolean isEditorMaximized() {
        return null != this.model.getEditorMaximizedMode();
    }

    boolean isViewMaximized() {
        return null != this.model.getViewMaximizedMode();
    }

    private void restoreViews(DockingStatus viewStatus) {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        Set<? extends Mode> modes = this.getModes();
        for (ModeImpl modeImpl : modes) {
            String tcID;
            List<TopComponent> views;
            if (modeImpl.getState() == 1) continue;
            if (modeImpl.getKind() == 0) {
                views = this.getModeOpenedTopComponents(modeImpl);
                Collections.reverse(views);
                for (TopComponent tc : views) {
                    tcID = wm.findTopComponentID(tc);
                    if (!viewStatus.shouldSlide(tcID)) continue;
                    this.slide(tc, modeImpl, this.guessSlideSide(tc));
                }
                continue;
            }
            if (modeImpl.getKind() != 2) continue;
            views = this.getModeOpenedTopComponents(modeImpl);
            Collections.reverse(views);
            for (TopComponent tc : views) {
                tcID = wm.findTopComponentID(tc);
                if (!viewStatus.shouldDock(tcID)) continue;
                this.unSlide(tc, modeImpl);
            }
        }
        for (ModeImpl modeImpl : modes) {
            TopComponent prevActiveTc;
            if (modeImpl.getState() == 1 || modeImpl.getKind() != 0 || null == (prevActiveTc = modeImpl.getPreviousSelectedTopComponent())) continue;
            this.setModeSelectedTopComponent(modeImpl, prevActiveTc);
        }
    }

    private void slideAllViews() {
        Set<? extends Mode> modes = this.getModes();
        for (ModeImpl modeImpl : modes) {
            if (modeImpl.getKind() != 0 || modeImpl == this.getViewMaximizedMode() || modeImpl.getState() == 1) continue;
            List<TopComponent> views = this.getModeOpenedTopComponents(modeImpl);
            Collections.reverse(views);
            for (TopComponent tc : views) {
                this.slide(tc, modeImpl, this.guessSlideSide(tc));
            }
        }
    }

    private static void debugLog(String message) {
        Debug.log(Central.class, message);
    }
}

