/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class CloneDocumentAction
extends AbstractAction
implements PropertyChangeListener {
    public CloneDocumentAction() {
        this.putValue("Name", NbBundle.getMessage(CloneDocumentAction.class, (String)"CTL_CloneDocumentAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public void actionPerformed(ActionEvent ev) {
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc == null || !(tc instanceof TopComponent.Cloneable)) {
            return;
        }
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tc);
        if (mode == null) {
            return;
        }
        if (mode.getKind() == 1) {
            ActionUtils.cloneWindow(tc);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("activated".equals(evt.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        TopComponent tc = TopComponent.getRegistry().getActivated();
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tc);
        this.setEnabled(tc instanceof TopComponent.Cloneable && mode != null && mode.getKind() == 1);
    }
}

